/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.controller;

import com.alibaba.fastjson2.JSON;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.xml.XMLObject;
import com.codefans.training.framework.common.JsonResultUtils;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ToResponseData;
import com.codefans.training.framework.controller.WrapUpContentType;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.controller.WrapUpResponseBodyReturnValueHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class WrapUpResponseBodyReturnValueHandler
implements HandlerMethodReturnValueHandler {
    protected final HttpMessageConverter<Object> messageConverter;

    public WrapUpResponseBodyReturnValueHandler(HttpMessageConverter<Object> converter) {
        this.messageConverter = converter;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getContainingClass(), WrapUpResponseBody.class) || returnType.hasMethodAnnotation(WrapUpResponseBody.class);
    }

    protected ServletServerHttpRequest createInputMessage(NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return new ServletServerHttpRequest(servletRequest);
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws IOException, HttpMessageNotWritableException {
        mavContainer.setRequestHandled(true);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        this.writeWithMessageConverters(returnValue, returnType, outputMessage);
    }

    protected void writeWithMessageConverters(Object value, MethodParameter returnType, ServletServerHttpResponse httpResponse) throws IOException, HttpMessageNotWritableException {
        WrapUpResponseBody wrap = (WrapUpResponseBody)returnType.getMethodAnnotation(WrapUpResponseBody.class);
        WrapUpContentType wrapUpType = wrap != null ? wrap.contentType() : WrapUpContentType.DATA;
        switch (1.$SwitchMap$com$codefans$training$framework$controller$WrapUpContentType[wrapUpType.ordinal()]) {
            case 1: {
                JsonResultUtils.writeOriginalObject((Object)value, (HttpServletResponse)httpResponse.getServletResponse());
                return;
            }
            case 2: {
                String scriptValue = ReflectionOpt.isScalarType(value.getClass()) ? StringBaseOpt.objectToString((Object)value) : JSON.toJSONString((Object)value);
                JsonResultUtils.writeJavaScript((String)scriptValue, (HttpServletResponse)httpResponse.getServletResponse());
                return;
            }
            case 3: {
                if (!(value instanceof RenderedImage)) {
                    throw new ObjectException(500, "\u9700\u8981image/gif\u683c\u5f0f\u7684RenderedImage\u5bf9\u8c61\u3002");
                }
                JsonResultUtils.writeOriginalImage((RenderedImage)((RenderedImage)value), (HttpServletResponse)httpResponse.getServletResponse());
                return;
            }
            case 4: {
                String xmlValue = ReflectionOpt.isScalarType(value.getClass()) ? StringBaseOpt.objectToString((Object)value) : XMLObject.objectToXMLString((String)"response", (Object)value);
                JsonResultUtils.writeOriginalXml((String)xmlValue, (HttpServletResponse)httpResponse.getServletResponse());
                return;
            }
            case 5: {
                JsonResultUtils.writeOriginalHtml((Object)value, (HttpServletResponse)httpResponse.getServletResponse());
                return;
            }
            case 6: {
                if (value instanceof File) {
                    JsonResultUtils.writeOriginalFile((File)((File)value), (HttpServletResponse)httpResponse.getServletResponse());
                } else if (value instanceof InputStream) {
                    JsonResultUtils.writeOriginalFile((InputStream)((InputStream)value), (String)"\u672a\u547d\u540d\u6587\u4ef6", (HttpServletResponse)httpResponse.getServletResponse());
                } else {
                    throw new ObjectException(500, "\u9700\u8981File\u5bf9\u8c61\u3002");
                }
                return;
            }
        }
        if (value == null) {
            ResponseData outputValue = ResponseData.successResponse;
            this.messageConverter.write((Object)outputValue, MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
            return;
        }
        Object outputValue = value instanceof ToResponseData ? ((ToResponseData)value).toResponseData() : (value instanceof ResponseData ? (ResponseData)value : ResponseData.makeResponseData((Object)value));
        if (wrapUpType == WrapUpContentType.BASE64) {
            outputValue = ResponseData.makeErrorMessageWithData((Object)Base64.encodeBase64String((byte[])JSON.toJSONString((Object)outputValue.getData()).getBytes(StandardCharsets.UTF_8)), (int)outputValue.getCode(), (String)outputValue.getMessage());
        }
        this.messageConverter.write(outputValue, MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
    }
}

