/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.repository;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.codefans.training.module.CaseInfo;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class CaseInfoDao
extends BaseDaoImpl<CaseInfo, String> {
    public List<CaseInfo> listCourseCases(String courseId, boolean includeSubCase) {
        if (includeSubCase) {
            return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId}));
        }
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId, "caseCatalog", "C"}));
    }

    public List<CaseInfo> listSubCases(String preCaseId) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"preCaseId", preCaseId}));
    }

    public boolean isExistSerial(String courseId, Integer courseSerial) {
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(1) as hasCase from CASE_INFO where COURSE_ID=? and CASE_CATALOG='C' and CASE_SERIAL=?", (Object[])new Object[]{courseId, courseSerial})) > 0;
    }

    public void moveCaseSerial(String courseId, Integer fromSerial, Integer toSerial) {
        if (fromSerial < toSerial) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL-1 where COURSE_ID=? and CASE_CATALOG='C' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{courseId, fromSerial, toSerial});
        } else {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL+1 where COURSE_ID=? and CASE_CATALOG='C' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{courseId, toSerial, fromSerial});
        }
    }

    public void moveSubCaseSerial(String preCaseId, Integer fromSerial, Integer toSerial) {
        if (fromSerial < toSerial) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL-1 where PRE_CASE_ID=? and CASE_CATALOG='S' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{preCaseId, fromSerial, toSerial});
        } else {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL+1 where PRE_CASE_ID=? and CASE_CATALOG='S' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{preCaseId, toSerial, fromSerial});
        }
    }

    public CaseInfo getCaseBySerial(String courseId, Integer caseSerial) {
        return (CaseInfo)this.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId, "caseSerial", caseSerial}));
    }

    public void updateCaseSerial(String caseId, Integer newSerial) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=? where CASE_ID=?", (Object[])new Object[]{newSerial, caseId});
    }

    public void updateCaseTestSum(String caseId, Integer testSum) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set TEST_SUM = ? where CASE_ID=?", (Object[])new Object[]{testSum, caseId});
    }

    public void updateCaseStatus(String caseId, String status) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_STATUS = ? where CASE_ID=?", (Object[])new Object[]{status, caseId});
    }
}

