/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.repository;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.codefans.training.module.CourseWare;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="courseWareDao")
public class CourseWareDao
extends BaseDaoImpl<CourseWare, String> {
    public List<CourseWare> listPlanCourses(String planId) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"planId", planId}));
    }

    public CourseWare fetchNextCourses(String planId, Integer serial) {
        List courseWares = this.listObjectsByFilter(" where PLAN_ID = ? and COURSE_STATUS ='P' and COURSE_SERIAL> ? order by COURSE_SERIAL limit 2", new Object[]{planId, serial});
        if (courseWares != null && courseWares.size() > 0) {
            return (CourseWare)courseWares.get(0);
        }
        return null;
    }

    public boolean isExistSerial(String planId, Integer courseSerial) {
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(1) as hasCourse from COURSE_WARE where PLAN_ID=? and COURSE_SERIAL=?", (Object[])new Object[]{planId, courseSerial})) > 0;
    }

    public void moveCourseSerial(String planId, Integer fromSerial, Integer toSerial) {
        if (fromSerial < toSerial) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update COURSE_WARE set COURSE_SERIAL=COURSE_SERIAL-1 where PLAN_ID=? and COURSE_SERIAL>=? and COURSE_SERIAL<=?", (Object[])new Object[]{planId, fromSerial, toSerial});
        } else {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update COURSE_WARE set COURSE_SERIAL=COURSE_SERIAL+1 where PLAN_ID=? and COURSE_SERIAL>=? and COURSE_SERIAL<=?", (Object[])new Object[]{planId, toSerial, fromSerial});
        }
    }

    public CourseWare getCourseBySerial(String planId, Integer courseSerial) {
        return (CourseWare)this.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"planId", planId, "courseSerial", courseSerial}));
    }

    public void updateCourseSerial(String courseId, Integer newSerial) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update COURSE_WARE set COURSE_SERIAL=? where COURSE_ID=?", (Object[])new Object[]{newSerial, courseId});
    }
}

