/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.repository;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ObjectException;
import com.codefans.training.module.UserInfo;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="userInfoDao")
public class UserInfoDao
extends BaseDaoImpl<UserInfo, String> {
    public boolean isExistsPhoneNumber(String phoneNumber) {
        if (StringUtils.isBlank((CharSequence)phoneNumber)) {
            return false;
        }
        return this.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"phoneNumber", phoneNumber})) > 0;
    }

    public boolean isExistsLoginName(String loginName) {
        if (StringUtils.isBlank((CharSequence)loginName)) {
            return false;
        }
        return this.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"loginName", loginName})) > 0;
    }

    public boolean isExistsEmailNo(String emailNo) {
        if (StringUtils.isBlank((CharSequence)emailNo)) {
            return false;
        }
        return this.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"emailNo", emailNo})) > 0;
    }

    public Date extendVipPeriod(String userCode, int days) {
        Date toDay;
        UserInfo userInfo = (UserInfo)this.getObjectById((Object)userCode);
        if (userInfo == null) {
            throw new ObjectException(611, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Date endDate = userInfo.getVipPeriodDate();
        if (endDate.before(toDay = DatetimeOpt.currentUtilDate())) {
            endDate = toDay;
        }
        userInfo.setVipPeriodDate(DatetimeOpt.addDays((Date)endDate, (int)days));
        this.updateObject(new String[]{"vipPeriodDate"}, (Serializable)userInfo);
        return userInfo.getVipPeriodDate();
    }
}

