/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.sandbox;

import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import org.apache.commons.lang3.StringUtils;

public class SystemError
extends Exception {
    private String message;
    private String stdout;
    private String stderr;

    public SystemError(String message, String stdout, String stderr) {
        super(message + " " + stderr);
        this.message = message;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public ResponseData toResponseData() {
        ResponseMapData responseData = new ResponseMapData(500, StringUtils.isBlank((CharSequence)this.message) ? this.stderr : this.message);
        responseData.addResponseData("error", (Object)this.stderr);
        responseData.addResponseData("output", (Object)this.stdout);
        return responseData;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemError)) {
            return false;
        }
        SystemError other = (SystemError)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$stdout = this.getStdout();
        String other$stdout = other.getStdout();
        if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
            return false;
        }
        String this$stderr = this.getStderr();
        String other$stderr = other.getStderr();
        return !(this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $stdout = this.getStdout();
        result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
        String $stderr = this.getStderr();
        result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SystemError(message=" + this.getMessage() + ", stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ")";
    }
}

