/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.ExperienceRating;
import com.codefans.training.module.NotifyUserStatus;
import com.codefans.training.module.SystemNotify;
import com.codefans.training.module.UserExperience;
import com.codefans.training.module.UserFeedback;
import com.codefans.training.repository.CaseInfoDao;
import com.codefans.training.repository.ExperienceRatingDao;
import com.codefans.training.repository.NotifyUserStatusDao;
import com.codefans.training.repository.SystemNotifyDao;
import com.codefans.training.repository.UserExperienceDao;
import com.codefans.training.repository.UserFeedbackDao;
import com.codefans.training.service.OperationManager;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperationManagerImpl
implements OperationManager {
    @Autowired
    private UserFeedbackDao userFeedbackDao;
    @Autowired
    private UserExperienceDao userExperienceDao;
    @Autowired
    private ExperienceRatingDao experienceRatingDao;
    @Autowired
    private CaseInfoDao caseInfoDao;
    @Autowired
    private SystemNotifyDao systemNotifyDao;
    @Autowired
    private NotifyUserStatusDao notifyUserStatusDao;

    public UserExperience getUserExperience(String userCode, String relObjectId, String experienceType) {
        return (UserExperience)this.userExperienceDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "experienceType", experienceType, "relObjectId", relObjectId}));
    }

    public List<UserExperience> listPublicExperienceByRef(String relObjectId, String experienceType) {
        return this.userExperienceDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"experienceType", experienceType, "relObjectId", relObjectId, "experienceStatus", "P"}));
    }

    public List<UserExperience> listUserExperience(String userCode, PageDesc pageDesc) {
        return this.userExperienceDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}), pageDesc);
    }

    public List<UserExperience> listReviewExperience(Map<String, Object> filter, PageDesc pageDesc) {
        filter.put("experienceStatus", "A");
        return this.userExperienceDao.listObjectsByProperties(filter, pageDesc);
    }

    public void saveNewExperience(UserExperience userExperience) {
        userExperience.setExperienceStatus("S");
        this.userExperienceDao.saveNewObject((Serializable)userExperience);
    }

    public void updateExperience(UserExperience userExperience) {
        if ("P".equals(userExperience.getExperienceStatus())) {
            throw new ObjectException(611, "\u5df2\u516c\u5f00\u7684\u5fc3\u5f97\u4e0d\u80fd\u7f16\u8f91\uff01");
        }
        this.userExperienceDao.updateObject((Serializable)userExperience);
    }

    public void updateExperienceStatus(String experienceId, String status) {
        this.userExperienceDao.updateExperienceStatus(experienceId, status);
    }

    public void deleteExperience(String userCode, String experienceId) {
        UserExperience userExperience = (UserExperience)this.userExperienceDao.getObjectById((Object)experienceId);
        if (!StringUtils.equals((CharSequence)userCode, (CharSequence)userExperience.getUserCode())) {
            throw new ObjectException(611, "\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u5fc3\u5f97\uff01");
        }
        if ("P".equals(userExperience.getExperienceStatus())) {
            throw new ObjectException(611, "\u5df2\u516c\u5f00\u7684\u5fc3\u5f97\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.userExperienceDao.deleteObjectById((Object)experienceId);
    }

    public void auditExperience(UserFeedback userFeedback, String auditStatus) {
        if (!StringUtils.equalsAny((CharSequence)auditStatus, (CharSequence[])new CharSequence[]{"R", "P"})) {
            throw new ObjectException(611, "\u5ba1\u6838\u72b6\u6001\u4e0d\u6b63\u786e\uff01");
        }
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)userFeedback.getRelOptId());
        if (caseInfo == null) {
            throw new ObjectException(611, "\u9898\u76ee\u4fe1\u606f\uff1a" + userFeedback.getRelOptId() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5b8c\u6574\u6027\uff01");
        }
        caseInfo.setCaseStatus(auditStatus);
        this.caseInfoDao.updateCaseStatus(caseInfo.getCaseId(), auditStatus);
        userFeedback.setFeedbackType("G");
        if (StringUtils.isBlank((CharSequence)userFeedback.getFeedbackContent())) {
            if ("R".equals(auditStatus)) {
                userFeedback.setFeedbackContent("\u9898\u76ee\u516c\u5f00\u5ba1\u6838\u672a\u83b7\u901a\u8fc7\uff01");
            } else {
                userFeedback.setFeedbackContent("\u9898\u76ee\u516c\u5f00\u5ba1\u6838\u901a\u8fc7\uff01");
            }
        }
        this.userFeedbackDao.saveNewObject((Serializable)userFeedback);
    }

    public void ratingExperience(ExperienceRating experienceRating) {
        this.experienceRatingDao.saveNewObject((Serializable)experienceRating);
    }

    public List<CaseInfo> listReviewCase(Map<String, Object> filter, PageDesc pageDesc) {
        filter.put("caseCatalog", "U");
        filter.put("caseStatus", "A");
        return this.caseInfoDao.listObjectsByProperties(filter, pageDesc);
    }

    public void updateCaseStatus(String caseId, String status) {
        this.caseInfoDao.updateCaseStatus(caseId, status);
    }

    public void auditCase(UserFeedback userFeedback, String auditStatus) {
        if (!StringUtils.equalsAny((CharSequence)auditStatus, (CharSequence[])new CharSequence[]{"R", "P"})) {
            throw new ObjectException(611, "\u5ba1\u6838\u72b6\u6001\u4e0d\u6b63\u786e\uff01");
        }
        UserExperience userExperience = (UserExperience)this.userExperienceDao.getObjectById((Object)userFeedback.getRelOptId());
        if (userExperience == null) {
            throw new ObjectException(611, "\u5fc3\u5f97\u4fe1\u606f\uff1a" + userFeedback.getRelOptId() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5b8c\u6574\u6027\uff01");
        }
        userExperience.setReviewer(userFeedback.getUserCode());
        userExperience.setReviewTime(DatetimeOpt.currentUtilDate());
        userExperience.setExperienceStatus(auditStatus);
        this.userExperienceDao.updateObject(new String[]{"reviewer", "reviewTime", "experienceStatus"}, (Serializable)userExperience);
        userFeedback.setFeedbackType("E");
        if (StringUtils.isBlank((CharSequence)userFeedback.getFeedbackContent())) {
            if ("R".equals(auditStatus)) {
                userFeedback.setFeedbackContent("\u5fc3\u5f97\u516c\u5f00\u5ba1\u6838\u672a\u83b7\u901a\u8fc7\uff01");
            } else {
                userFeedback.setFeedbackContent("\u5fc3\u5f97\u516c\u5f00\u5ba1\u6838\u901a\u8fc7\uff01");
            }
        }
        this.userFeedbackDao.saveNewObject((Serializable)userFeedback);
    }

    public List<SystemNotify> listSystemNotify(Map<String, Object> filters, PageDesc pageDesc) {
        return this.systemNotifyDao.listObjectsByProperties(filters, pageDesc);
    }

    public JSONArray listUserNotify(String userCode, boolean unreadOnly, PageDesc pageDesc) {
        return this.systemNotifyDao.listUserNotify(userCode, unreadOnly, pageDesc);
    }

    public void saveNewNotify(SystemNotify systemNotify) {
        systemNotify.setNotifyStatus("D");
        this.systemNotifyDao.saveNewObject((Serializable)systemNotify);
    }

    public void updateNotify(SystemNotify systemNotify) {
        if ("F".equals(systemNotify.getNotifyStatus())) {
            throw new ObjectException(611, "\u6b63\u5f0f\u901a\u77e5\u4e0d\u80fd\u7f16\u8f91\uff01");
        }
        this.systemNotifyDao.updateObject((Serializable)systemNotify);
    }

    public void deleteNotify(String notifyId) {
        SystemNotify systemNotify = (SystemNotify)this.systemNotifyDao.getObjectById((Object)notifyId);
        if ("F".equals(systemNotify.getNotifyStatus())) {
            throw new ObjectException(611, "\u6b63\u5f0f\u901a\u77e5\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.systemNotifyDao.deleteObjectById((Object)notifyId);
    }

    public void publicNotify(SystemNotify systemNotify) {
        systemNotify.setNoticeTime(DatetimeOpt.currentUtilDate());
        systemNotify.setNotifyStatus("F");
        this.systemNotifyDao.updateObject((Serializable)systemNotify);
    }

    public void readNotify(String userCode, String notifyId) {
        NotifyUserStatus notifyUserStatus = new NotifyUserStatus();
        notifyUserStatus.setNotifyId(notifyId);
        notifyUserStatus.setUserCode(userCode);
        this.notifyUserStatusDao.saveNewObject((Serializable)notifyUserStatus);
    }

    public List<UserFeedback> listUserFeedback(Map<String, Object> filters, PageDesc pageDesc) {
        return this.userFeedbackDao.listObjectsByProperties(filters, pageDesc);
    }

    public void saveNewFeedback(UserFeedback userFeedback) {
        this.userFeedbackDao.saveNewObject((Serializable)userFeedback);
    }
}

