/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.config;

import com.centit.support.database.utils.DBType;
import com.centit.support.security.SecurityOptUtils;
import com.codefans.training.config.ApplicationProperties;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(proxyTargetClass=true)
public class JdbcConfig {
    protected Logger logger = LoggerFactory.getLogger(JdbcConfig.class);
    @Autowired
    private ApplicationProperties applicationProperties;

    @Bean(destroyMethod="close")
    public HikariDataSource dataSource() {
        ApplicationProperties.JdbcConfig jdbcConfig = this.applicationProperties.getJdbc();
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(jdbcConfig.getDriver());
        ds.setUsername(SecurityOptUtils.decodeSecurityString((String)jdbcConfig.getUsername()));
        ds.setPassword(SecurityOptUtils.decodeSecurityString((String)jdbcConfig.getPassword()));
        ds.setJdbcUrl(jdbcConfig.getUrl());
        ds.setConnectionTimeout(30000L);
        ds.setMaximumPoolSize(100);
        ds.setMaxLifetime(80000000L);
        ds.setIdleTimeout(6000000L);
        ds.setValidationTimeout(5000L);
        ds.setMinimumIdle(5);
        if (StringUtils.isNotBlank((CharSequence)jdbcConfig.getValidationQuery())) {
            ds.setConnectionTestQuery(jdbcConfig.getValidationQuery());
        } else {
            String vsql = DBType.getDBValidationQuery((DBType)DBType.mapDBType((String)jdbcConfig.getUrl()));
            ds.setConnectionTestQuery(vsql);
        }
        return ds;
    }

    @Lazy
    @Bean
    public DataSourceTransactionManager transactionManager(@Autowired DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        return transactionManager;
    }

    @Lazy
    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }
}

