/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.config;

import com.alibaba.fastjson2.support.spring6.data.redis.GenericFastJsonRedisSerializer;
import com.centit.support.security.SecurityOptUtils;
import com.codefans.training.config.ApplicationProperties;
import com.codefans.training.framework.session.CentitSessionRedisRepo;
import com.codefans.training.framework.session.CentitSessionRepo;
import com.codefans.training.framework.session.SmartHttpSessionResolver;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisIndexedHttpSession;

@Configuration
@EnableRedisIndexedHttpSession(maxInactiveIntervalInSeconds=7200)
public class RedisSessionPersistenceConfig {
    @Autowired
    private ApplicationProperties applicationProperties;

    @Bean
    public SmartHttpSessionResolver smartHttpSessionStrategy() {
        return new SmartHttpSessionResolver(this.applicationProperties.getSession().isCookieFist(), this.applicationProperties.getSession().getCookiePath(), this.applicationProperties.getSession().isAddAccessToken());
    }

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration(this.applicationProperties.getRedis().getHost(), this.applicationProperties.getRedis().getPort().intValue());
        configuration.setDatabase(this.applicationProperties.getRedis().getDatabase().intValue());
        if (StringUtils.isNotBlank((CharSequence)this.applicationProperties.getRedis().getPassword())) {
            configuration.setPassword(RedisPassword.of((String)SecurityOptUtils.decodeSecurityString((String)this.applicationProperties.getRedis().getPassword())));
        }
        return new LettuceConnectionFactory(configuration);
    }

    @Bean
    public CentitSessionRepo centitSessionRepo(@Autowired RedisIndexedSessionRepository sessionRepository) {
        return new CentitSessionRedisRepo(sessionRepository);
    }

    @Bean(value={"springSessionDefaultRedisSerializer"})
    public RedisSerializer<Object> redisSerializer() {
        return new GenericFastJsonRedisSerializer();
    }
}

