/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.file.FileSystemOpt;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.CaseTestUnit;
import com.codefans.training.module.CoursePlan;
import com.codefans.training.module.CourseWare;
import com.codefans.training.module.MoveDataDto;
import com.codefans.training.service.CourseAssignManager;
import com.codefans.training.utils.OsFileStoreUtils;
import com.codefans.training.utils.UploadDownloadUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="\u8bfe\u4ef6\u5236\u4f5c", description="\u8bfe\u4ef6\u5236\u4f5c\u63a5\u53e3\uff0c\u5236\u4f5c\u8bfe\u7a0b\u8ba1\u5212\u3001\u8bfe\u4ef6\u3001\u9898\u76ee\u7b49\u7b49")
@Controller
@RequestMapping(value={"/assign"})
public class CourseAssignController
extends BaseController {
    @Autowired
    protected CourseAssignManager courseAssignManager;

    @Operation(summary="\u67e5\u8be2\u8bfe\u7a0b\u8ba1\u5212", description="\u67e5\u8be2\u8bfe\u7a0b\u8ba1\u5212\uff0c\u53ef\u4ee5\u6839\u636e\u79d1\u76ee\uff08\u8bfe\u7a0b\u7c7b\u578b\u6765\u67e5\u8be2\uff09, \u6682\u65f6\u6ca1\u6709\u5206\u9875\u529f\u80fd")
    @GetMapping(value={"/list/plan/{planType}"})
    @Parameters(value={@Parameter(name="planType", description="\u8bfe\u7a0b\u7c7b\u578b:PRO \u4e3b\u8bfe\u7a0b, EXT \u62d3\u5c55\u8bfe, ALL\u6240\u6709\u8bfe\u7a0b", required=true), @Parameter(name="isPublished", description="\u662f\u5426\u53d1\u5e03\uff0ctrue \u662f false \u5426")})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public List<CoursePlan> listPlan(@PathVariable(value="planType") String planType, String isPublished) {
        return this.courseAssignManager.listCoursePlans(planType, BooleanBaseOpt.castObjectToBoolean((Object)isPublished, (Boolean)false).booleanValue());
    }

    @Operation(summary="\u83b7\u53d6\u8bfe\u7a0b\u8ba1\u5212")
    @GetMapping(value={"/plan/{planId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    @Parameter(name="planId", description="\u8bfe\u7a0b\u8ba1\u5212\u4e3b\u952e", required=true)
    public CoursePlan getPlan(@PathVariable(value="planId") String planId) {
        return this.courseAssignManager.getCoursePlan(planId);
    }

    @Operation(summary="\u65b0\u5efa\u8bfe\u7a0b\u8ba1\u5212")
    @PostMapping(value={"/plan"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public CoursePlan createPlan(@RequestBody CoursePlan coursePlan) {
        this.courseAssignManager.createCoursePlan(coursePlan);
        return coursePlan;
    }

    @Operation(summary="\u4fee\u6539\u8bfe\u7a0b\u8ba1\u5212")
    @PutMapping(value={"/plan"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void updatePlan(@RequestBody CoursePlan coursePlan) {
        this.courseAssignManager.updateCoursePlan(coursePlan);
    }

    @Operation(summary="\u53d1\u5e03\u8bfe\u7a0b\u8ba1\u5212")
    @PutMapping(value={"/plan/publish"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void publishPlan(@RequestBody String planJson) {
        JSONObject json = JSONObject.parseObject((String)planJson);
        String planId = json.getString("planId");
        this.courseAssignManager.changePlanStatus(planId, "P");
    }

    @Operation(summary="\u4e0b\u67b6\u8bfe\u7a0b\u8ba1\u5212")
    @PutMapping(value={"/plan/delist"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void delistPlan(@RequestBody String planJson) {
        JSONObject json = JSONObject.parseObject((String)planJson);
        String planId = json.getString("planId");
        this.courseAssignManager.changePlanStatus(planId, "N");
    }

    @Operation(summary="\u67e5\u8be2\u8bfe\u7a0b\u8ba1\u5212\u7684\u6240\u6709\u8bfe\u4ef6", description="\u67e5\u8be2\u8bfe\u7a0b\u8ba1\u5212\u7684\u6240\u6709\u8bfe\u4ef6\uff0c\u6ca1\u6709\u5206\u9875\u529f\u80fd")
    @GetMapping(value={"/list/course/{planId}"})
    @Parameter(name="planId", description="\u8bfe\u7a0b\u8ba1\u5212\u4e3b\u952e", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public List<CourseWare> listCourse(@PathVariable(value="planId") String planId) {
        return this.courseAssignManager.listPlanCourses(planId);
    }

    @Operation(summary="\u83b7\u53d6\u8bfe\u4ef6\u5185\u5bb9")
    @GetMapping(value={"/course/{courseId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    @Parameter(name="courseId", description="\u8bfe\u4ef6\u7684\u4e3b\u952e", required=true)
    public CourseWare getCourseWare(@PathVariable(value="courseId") String courseId) {
        return this.courseAssignManager.getCourseWare(courseId);
    }

    @Operation(summary="\u65b0\u5efa\u8bfe\u4ef6\u5185\u5bb9")
    @PostMapping(value={"/course"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public CourseWare createCourse(@RequestBody CourseWare courseWare) {
        if (StringUtils.isBlank((CharSequence)courseWare.getCourseType())) {
            courseWare.setCourseType("T");
        }
        this.courseAssignManager.addCourse(courseWare);
        return courseWare;
    }

    @Operation(summary="\u4fee\u6539\u8bfe\u4ef6\u5185\u5bb9")
    @PutMapping(value={"/course"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void updateCourse(@RequestBody CourseWare courseWare) {
        this.courseAssignManager.updateCourse(courseWare);
    }

    @Operation(summary="\u5c06\u8bfe\u4ef6\u72b6\u6001\u751f\u6210\u4e3a\u5df2\u53d1\u5e03\u72b6\u6001")
    @PutMapping(value={"/course/publish"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void publishCourse(@RequestBody String courseJson) {
        JSONObject json = JSONObject.parseObject((String)courseJson);
        String courseId = json.getString("courseId");
        this.courseAssignManager.changeCourseStatus(courseId, "P");
    }

    @Operation(summary="\u4e0b\u67b6\u8bfe\u4ef6\u5185\u5bb9")
    @PutMapping(value={"/course/delist"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void delistCourse(@RequestBody String courseJson) {
        JSONObject json = JSONObject.parseObject((String)courseJson);
        String courseId = json.getString("courseId");
        this.courseAssignManager.changeCourseStatus(courseId, "N");
    }

    @Operation(summary="\u79fb\u52a8\u8bfe\u4ef6\u987a\u5e8f")
    @PutMapping(value={"/course/move"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void moveCourse(@RequestBody MoveDataDto moveInfo) {
        this.courseAssignManager.moveCourse(moveInfo.getObjectId(), moveInfo.getFromSerial(), moveInfo.getToSerial());
    }

    @Operation(summary="\u5220\u9664\u8bfe\u4ef6\u5185\u5bb9")
    @DeleteMapping(value={"/course/{courseId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void deleteCourse(@PathVariable(value="courseId") String courseId) {
        this.courseAssignManager.deleteCourse(courseId);
    }

    @Operation(summary="\u67e5\u8be2\u8bfe\u4ef6\u7684\u6240\u6709\u9898\u76ee", description="\u67e5\u8be2\u8bfe\u7a0b\u8bfe\u4ef6\u7684\u8bfe\u7a0b\u5185\u5bb9\u8ddf\uff0c\u6ca1\u6709\u5206\u9875\u529f\u80fd")
    @GetMapping(value={"/list/case/{courseId}"})
    @Parameter(name="courseId", description="\u8bfe\u4ef6\u7684\u4e3b\u952e", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public List<CaseInfo> listCourseCases(@PathVariable(value="courseId") String courseId) {
        return this.courseAssignManager.listCourseCases(courseId);
    }

    @Operation(summary="\u83b7\u53d6\u9898\u76ee\u5185\u5bb9")
    @GetMapping(value={"/case/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    @Parameter(name="caseId", description="\u8bfe\u7a0b\u9898\u76ee\u7684\u4e3b\u952e", required=true)
    public JSONObject getCaseInfo(@PathVariable(value="caseId") String caseId) {
        return this.courseAssignManager.fetchCaseInfo(caseId, false);
    }

    @Operation(summary="\u65b0\u5efa\u8bfe\u4ef6\u9898\u76ee\u5185\u5bb9")
    @PostMapping(value={"/case"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public CaseInfo createCaseInfo(@RequestBody CaseInfo caseInfo) {
        if (StringUtils.isBlank((CharSequence)caseInfo.getCaseCatalog())) {
            caseInfo.setCaseCatalog("C");
        }
        caseInfo.setCaseStatus("P");
        this.courseAssignManager.addCase(caseInfo);
        return caseInfo;
    }

    @Operation(summary="\u4fee\u6539\u8bfe\u4ef6\u7684\u9898\u76ee\u5185\u5bb9")
    @PutMapping(value={"/case"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void updateCaseInfo(@RequestBody CaseInfo caseInfo) {
        caseInfo.setCaseStatus("P");
        this.courseAssignManager.updateCase(caseInfo);
    }

    @Operation(summary="\u79fb\u52a8\u8bfe\u4ef6\u7684\u9898\u76ee\u987a\u5e8f")
    @PutMapping(value={"/case/move"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void moveCaseInfo(@RequestBody MoveDataDto moveInfo) {
        this.courseAssignManager.moveCase(moveInfo.getObjectId(), moveInfo.getFromSerial(), moveInfo.getToSerial());
    }

    @Operation(summary="\u5220\u9664\u8bfe\u4ef6\u7684\u9898\u76ee\u5185\u5bb9")
    @DeleteMapping(value={"/case/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void deleteCaseInfo(@PathVariable(value="caseId") String caseId) {
        this.courseAssignManager.deleteCase(caseId);
    }

    @Operation(summary="\u65b0\u5efa\u6d4b\u8bd5\u7528\u4f8b")
    @PostMapping(value={"/test"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public CaseTestUnit saveTestCase(@RequestBody CaseTestUnit testUnit) {
        this.courseAssignManager.updateTestCase(testUnit);
        return testUnit;
    }

    @Operation(summary="\u79fb\u52a8\u6d4b\u8bd5\u7528\u4f8b\u987a\u5e8f")
    @PutMapping(value={"/test/move"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void moveTestCase(@RequestBody MoveDataDto moveInfo) {
        this.courseAssignManager.moveTestCase(moveInfo.getObjectId(), moveInfo.getFromSerial(), moveInfo.getToSerial());
    }

    @Operation(summary="\u5220\u9664\u6d4b\u8bd5\u7528\u4f8b")
    @DeleteMapping(value={"/test/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void deleteTestCase(@PathVariable(value="caseId") String caseId, Integer serial) {
        this.courseAssignManager.deleteTestCase(caseId, serial);
    }

    @Operation(summary="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b")
    @GetMapping(value={"/test/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public CaseTestUnit getTestCase(@PathVariable(value="caseId") String caseId, Integer serial) {
        return this.courseAssignManager.getTestCase(caseId, serial);
    }

    @Operation(summary="\u4e0b\u8f7d\u6d4b\u8bd5\u7528\u4f8b\u8f93\u5165\u6587\u4ef6")
    @GetMapping(value={"/test/{caseId}/input"})
    @CertificateFilter(userType="P")
    public void downloadTestCaseInput(@PathVariable(value="caseId") String caseId, Integer serial, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = "input" + serial + ".txt";
        String runtimeDir = OsFileStoreUtils.getRuntimePath((String)caseId);
        String inputPath = runtimeDir + File.separatorChar + "input" + serial + ".txt";
        long fileSize = FileSystemOpt.fetchFileSize((String)inputPath);
        if (fileSize <= 0L) {
            UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileName, (HttpServletResponse)response);
            return;
        }
        UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)new FileInputStream(inputPath), (long)fileSize, (String)fileName, (String)"attachment", null);
    }

    @Operation(summary="\u4e0b\u8f7d\u6d4b\u8bd5\u7528\u4f8b\u8f93\u5165\u6587\u4ef6")
    @GetMapping(value={"/test/{caseId}/output"})
    @WrapUpResponseBody
    @CertificateFilter(userType="P")
    public void downloadTestCaseOutput(@PathVariable(value="caseId") String caseId, Integer serial, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = "output" + serial + ".txt";
        String runtimeDir = OsFileStoreUtils.getRuntimePath((String)caseId);
        String outputPath = runtimeDir + File.separatorChar + "output" + serial + ".txt";
        long fileSize = FileSystemOpt.fetchFileSize((String)outputPath);
        if (fileSize <= 0L) {
            UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileName, (HttpServletResponse)response);
        } else {
            UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)new FileInputStream(outputPath), (long)fileSize, (String)fileName, (String)"attachment", null);
        }
    }
}

