/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.common.WebOptUtils;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpContentType;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.utils.OsFileStoreUtils;
import com.codefans.training.utils.UploadDownloadUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.detect.AutoDetectReader;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Tag(name="\u6587\u4ef6\u4e0a\u4f20\u4e0b\u8f7d\u63a5\u53e3", description="\u6587\u4ef6\u4e0a\u4f20\u4e0b\u8f7d\uff0c\u652f\u6301\u65ad\u70b9\u7eed\u4f20")
@Controller
@RequestMapping(value={"/file"})
public class FileController
extends BaseController {
    @Operation(summary="\u6587\u4ef6\u6574\u4f53\u4e0a\u4f20\u7ed3\u6784\uff0c\u9002\u7528\u4e8eIE8")
    @CrossOrigin(originPatterns={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @CertificateFilter
    @WrapUpResponseBody
    public Map<String, Object> uploadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair formData = UploadDownloadUtils.fetchInputStreamFromRequest((HttpServletRequest)request);
        String token = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"fileMd5", "md5"});
        boolean needCheck = StringUtils.isNotBlank((CharSequence)token);
        String tempFilePath = OsFileStoreUtils.getRandomTempFilePath();
        try {
            if (FileSystemOpt.existFile((String)tempFilePath)) {
                FileSystemOpt.deleteFile((String)tempFilePath);
            }
            FileIOOpt.writeInputStreamToFile((InputStream)((InputStream)formData.getRight()), (String)tempFilePath);
            File tempFile = new File(tempFilePath);
            String fileMd5 = FileMD5Maker.makeFileMD5((File)tempFile);
            if (needCheck && !token.equals(fileMd5)) {
                throw new ObjectException(425, "\u6587\u4ef6MD5\u7801\u6821\u9a8c\u5931\u8d25");
            }
            OsFileStoreUtils.moveFileToLibrary((String)tempFilePath, (String)fileMd5);
            return CollectionsOpt.createHashMap((Object[])new Object[]{"fileName", formData.getLeft(), "md5", fileMd5});
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ObjectException(500, e.getMessage(), (Throwable)e);
        }
    }

    @Operation(summary="\u68c0\u67e5\u7eed\u4f20\u70b9\uff0c\u5982\u679csignal\u4e3acontinue\u8bf7\u7eed\u4f20\uff0c\u5982\u679c\u4e3acomplete\u8868\u793a\u6587\u4ef6\u5df2\u5b58\u5728\u65e0\u9700\u4e0a\u4f20")
    @CrossOrigin(originPatterns={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.GET})
    @RequestMapping(value={"/range"}, method={RequestMethod.GET})
    @CertificateFilter
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public JSONObject checkFileRange(HttpServletRequest request) throws IOException {
        boolean complete;
        String fileMd5 = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"token", "fileMd5", "md5"});
        if (StringUtils.isBlank((CharSequence)fileMd5)) {
            throw new ObjectException(611, "\u65ad\u70b9\u4e0a\u4f20\u9700\u8981\u4f20\u8f93md5\u7801\u4f5c\u4e3a\u6587\u4ef6\u6807\u8bc6\uff01");
        }
        Long fileSize = NumberBaseOpt.parseLong((String)WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"size", "fileSize"}), (Long)-1L);
        String fileName = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"});
        if (OsFileStoreUtils.checkFile((String)OsFileStoreUtils.matchFileStoreUrl((String)fileMd5))) {
            complete = true;
            fileSize = OsFileStoreUtils.checkFileSize((String)OsFileStoreUtils.matchFileStoreUrl((String)fileMd5));
        } else {
            String tempFilePath = OsFileStoreUtils.getTempFilePath((String)fileMd5);
            long tempFileSize = OsFileStoreUtils.checkFileSize((String)tempFilePath);
            if (fileSize > 0L && fileSize == tempFileSize) {
                complete = true;
                OsFileStoreUtils.moveFileToLibrary((String)tempFilePath, (String)fileMd5);
            } else {
                complete = false;
            }
        }
        return UploadDownloadUtils.makeRangeUploadJson((long)fileSize, (String)fileMd5, (String)fileName, (boolean)complete);
    }

    @Operation(summary="\u65ad\u70b9\u7eed\u4f20\u63a5\u53e3")
    @CrossOrigin(originPatterns={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/range"}, method={RequestMethod.POST})
    @CertificateFilter
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public JSONObject uploadFileRange(String token, long size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair formData = UploadDownloadUtils.fetchInputStreamFromRequest((HttpServletRequest)request);
        if (OsFileStoreUtils.checkFile((String)OsFileStoreUtils.matchFileStoreUrl((String)token))) {
            return UploadDownloadUtils.makeRangeUploadJson((long)size, (String)token, (String)((String)formData.getLeft()), (boolean)true);
        }
        String tempFilePath = OsFileStoreUtils.getTempFilePath((String)token);
        try {
            long uploadSize = UploadDownloadUtils.uploadRange((String)tempFilePath, (InputStream)((InputStream)formData.getRight()), (String)token, (long)size, (HttpServletRequest)request);
            if (uploadSize == size) {
                OsFileStoreUtils.moveFileToLibrary((String)tempFilePath, (String)token);
                return UploadDownloadUtils.makeRangeUploadJson((long)size, (String)token, (String)((String)formData.getLeft()), (boolean)true);
            }
            return UploadDownloadUtils.makeRangeUploadJson((long)uploadSize, (String)token, (String)((String)formData.getLeft()), (boolean)false);
        }
        catch (ObjectException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ObjectException(500, e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/view/{fileMd5}"}, method={RequestMethod.GET})
    @Operation(summary="\u6839\u636e\u6743\u9650\u9884\u89c8\u6587\u4ef6\uff0c\u53ef\u4ee5\u4f20\u5165authCode\u5206\u4eab\u7801")
    @CertificateFilter
    public void previewFile(@PathVariable(value="fileMd5") String fileMd5, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"});
        String fileType = FileType.getFileExtName((String)fileName);
        String fileUrl = OsFileStoreUtils.matchFileStoreUrl((String)fileMd5);
        if (!OsFileStoreUtils.checkFile((String)fileUrl)) {
            UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileName, (HttpServletResponse)response);
            return;
        }
        try {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileType, (CharSequence[])new CharSequence[]{"txt", "html", "htm", "csv", "pdf", "xml"})) {
                String charset = null;
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileType, (CharSequence[])new CharSequence[]{"txt", "csv"})) {
                    charset = new AutoDetectReader(OsFileStoreUtils.loadFileStream((String)fileUrl)).getCharset().name();
                }
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)OsFileStoreUtils.loadFileStream((String)fileUrl), (long)OsFileStoreUtils.getFileSize((String)fileUrl), (String)fileName, (String)"inline", (String)charset);
            } else {
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)OsFileStoreUtils.loadFileStream((String)fileUrl), (long)OsFileStoreUtils.getFileSize((String)fileUrl), (String)fileName, (String)"inline", null);
            }
        }
        catch (Exception e) {
            throw new ObjectException(500, e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/download/{fileMd5}"}, method={RequestMethod.GET})
    @CertificateFilter
    @Operation(summary="\u6839\u636e\u6587\u4ef6\u7684id\u4e0b\u8f7d\u6587\u4ef6")
    public void downloadFileByMd5(@PathVariable(value="fileMd5") String fileMd5, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"});
        String fileUrl = OsFileStoreUtils.matchFileStoreUrl((String)fileMd5);
        if (!OsFileStoreUtils.checkFile((String)fileUrl)) {
            UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileName, (HttpServletResponse)response);
            return;
        }
        UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)OsFileStoreUtils.loadFileStream((String)fileUrl), (long)OsFileStoreUtils.getFileSize((String)fileUrl), (String)fileName, (String)"attachment", null);
    }
}

