/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.config.ApplicationProperties;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.common.PageQueryResult;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.controller.BaseController;
import com.codefans.training.framework.controller.WrapUpResponseBody;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.ProgramDto;
import com.codefans.training.module.UserCase;
import com.codefans.training.module.UserInfo;
import com.codefans.training.module.UserProgram;
import com.codefans.training.service.CourseAssignManager;
import com.codefans.training.service.CppRunttimeService;
import com.codefans.training.service.PracticeManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Tag(name="\u7ec3\u4e60\u3001\u505a\u4f5c\u4e1a", description="\u5b66\u751f\u505a\u4f5c\u4e1a")
@Controller
@RequestMapping(value={"/practice"})
public class PracticeController
extends BaseController {
    @Autowired
    protected PracticeManager practiceManager;
    @Autowired
    protected CourseAssignManager courseAssignManager;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private CppRunttimeService cppRunttimeService;

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u8bfe\u7a0b\u8ba1\u5212 - \u7528\u6237\u8ba1\u5212\u7ba1\u7406", description="\u6240\u6709\u72b6\u6001\u4e3a\u5df2\u53d1\u5e03\uff08P\uff09\u7684\u7528\u6237\u5df2\u7ecf\u5f00\u901a\u7684\u8bfe\u7a0b")
    @GetMapping(value={"/plan/{planType}"})
    @Parameter(name="planType", description="\u8bfe\u7a0b\u7c7b\u578b:PRO \u4e3b\u8bfe\u7a0b, EXT \u62d3\u5c55\u8bfe, ALL\u6240\u6709\u8bfe\u7a0b", required=true)
    @WrapUpResponseBody
    @CertificateFilter
    public JSONArray listUserPlan(@PathVariable(value="planType") String planType, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.listUserPlans(currentUser.getUserCode(), planType);
    }

    @Operation(summary="\u8ba2\u9605\u65b0\u7684\u8bfe\u7a0b\u8ba1\u5212 - \u7528\u6237\u8ba1\u5212\u7ba1\u7406", description="\u7528\u6237\u5728\u4e00\u4e2a\u6708\u5185\u53ea\u80fd\u4e3b\u52a8\u5207\u6362\u4e00\u6b21\u65b0\u7684\u8bfe\u7a0b")
    @PostMapping(value={"/subscribe/{planId}"})
    @Parameter(name="planId", description="\u8bfe\u7a0b\u8ba1\u5212\u4e3b\u952e", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void subscribePlan(@PathVariable(value="planId") String planId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.practiceManager.subscribeCoursePlan(currentUser.getUserCode(), planId);
    }

    @Operation(summary="\u53d6\u6d88\u8bfe\u7a0b\u8ba1\u5212 - \u7528\u6237\u8ba1\u5212\u7ba1\u7406", description="\u7528\u6237\u53ea\u80fd\u53d6\u6d88\u62d3\u5c55\u8bfe\u7a0b")
    @PostMapping(value={"/unsubscribe/{planId}"})
    @Parameter(name="planId", description="\u8bfe\u7a0b\u8ba1\u5212\u4e3b\u952e", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void unsubscribePlan(@PathVariable(value="planId") String planId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.practiceManager.unsubscribeCoursePlan(currentUser.getUserCode(), planId);
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u5f53\u524d\u8bfe\u7a0b - \u8bad\u7ec3\u9996\u9875\u63a5\u53e3", description="\u83b7\u53d6\u7528\u6237\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u7684\u8bfe\u7a0b")
    @GetMapping(value={"/current"})
    @WrapUpResponseBody
    @CertificateFilter
    public JSONArray listUserCourse(HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.listUserCourses(currentUser.getUserCode());
    }

    @Operation(summary="\u67e5\u8be2\u5386\u53f2\u8bfe\u7a0b - \u8bad\u7ec3\u9996\u9875\u63a5\u53e3", description="\u8fd9\u4e2a\u63a5\u53e3\u652f\u6301\u5206\u9875\u67e5\u8be2\uff0c\u548c\u5386\u53f2\u8fc7\u7a0b\u72b6\u6001\u8fc7\u6ee4\uff08onlySkip\uff09")
    @Parameters(value={@Parameter(name="onlySkip", description="\u53ea\u663e\u793a\u6ca1\u6709\u5b8c\u6210\u7684\u8bfe\u7a0b"), @Parameter(name="notFullMark", description="\u53ea\u663e\u793a\u6ca1\u6709\u6ee1\u5206\u7684\u8bfe\u7a0b")})
    @GetMapping(value={"/history"})
    @WrapUpResponseBody
    @CertificateFilter
    public PageQueryResult<Object> listUserHistoryCourse(String onlySkip, String notFullMark, PageDesc pageDesc, HttpServletRequest request) {
        boolean onlySkipFlag = BooleanBaseOpt.castObjectToBoolean((Object)onlySkip, (Boolean)false);
        boolean notFullMarkFlag = BooleanBaseOpt.castObjectToBoolean((Object)notFullMark, (Boolean)false);
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        JSONArray jsonArray = this.practiceManager.listUserCompletedCourses(currentUser.getUserCode(), onlySkipFlag, notFullMarkFlag, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)jsonArray, (PageDesc)pageDesc);
    }

    @Operation(summary="\u67e5\u8be2\u8bfe\u7a0b\u8be6\u7ec6\u4fe1\u606f - \u8bad\u7ec3\u9875\u8bfe\u7a0b\u5c55\u793a", description="\u67e5\u8be2\u8bfe\u7a0b\u8be6\u7ec6\u4fe1\u606f\uff0c\u7528\u4e8e\u5c55\u793a\u8bad\u7ec3\u9875\u9762\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u5df2\u7ecf\u5305\u62ec\u5de6\u4fa7\u7684\u6811\u5f62\u7ed3\u6784\uff08\u590d\u5408\u9898\u3001\u7f16\u7a0b\u9898\uff09")
    @GetMapping(value={"/course/{courseId}"})
    @WrapUpResponseBody
    @CertificateFilter
    public JSONObject fetchUserCourseDetail(@PathVariable(value="courseId") String courseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.fetchUserCourseDetail(currentUser.getUserCode(), courseId);
    }

    @Operation(summary="\u83b7\u53d6\u9898\u76ee\u5185\u5bb9 - \u8bad\u7ec3\u9875\u9898\u76ee\u8be6\u7ec6\u4fe1\u606f", description="\u9898\u76ee\u8be6\u7ec6\u4fe1\u606f\u5c55\u793a\u5728\u53f3\u4fa7")
    @GetMapping(value={"/case/{caseId}"})
    @WrapUpResponseBody
    @CertificateFilter
    @Parameter(name="caseId", description="\u8bfe\u7a0b\u9898\u76ee\u7684\u4e3b\u952e", required=true)
    public JSONObject getCaseInfo(@PathVariable(value="caseId") String caseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        return this.practiceManager.fetchUserCaseInfo(currentUser.getUserCode(), caseId);
    }

    @Operation(summary="\u5b8c\u6210\u8bfe\u4ef6\u7684\u5b66\u4e60 - \u8bad\u7ec3\u63d0\u4ea4\u8bfe\u7a0b", description="\u8bfe\u4ef6\u53ea\u6709\u83b7\u5f97\u4e00\u5b9a\u7684\u5f97\u5206\uff0c\u6216\u8005\u5b66\u4e60\u4e00\u6bb5\u65f6\u95f4\u540e\u624d\u53ef\u4ee5\u63d0\u4ea4\u5b8c\u6210")
    @PostMapping(value={"/complete/{courseId}"})
    @Parameter(name="courseId", description="\u8bfe\u4ef6ID", required=true)
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void completeCourse(@PathVariable(value="courseId") String courseId, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        this.practiceManager.completeCourse(currentUser.getUserCode(), courseId);
    }

    @Operation(summary="\u63d0\u4ea4\u9898\u76ee\u7b54\u6848\uff08\u975e\u7f16\u7a0b\u9898\uff09 - \u8bad\u7ec3\u63d0\u4ea4\u9898\u76ee", description="\u9898\u76ee\u53ef\u4ee5\u591a\u6b21\u63d0\u4ea4\u7b54\u6848\uff0c\u4ee5\u5de6\u53f3\u63d0\u4ea4\u4e3a\u51c6\uff0c\u7f16\u7a0b\u63d0\u4ee5\u5f97\u5206\u6700\u9ad8\u7684\u4e3a\u51c6")
    @PostMapping(value={"/answer"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public JSONObject submitCaseAnswer(@RequestBody UserCase userCase, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userCase.setUserCode(currentUser.getUserCode());
        return this.practiceManager.submitCaseAnswer(userCase);
    }

    @Operation(summary="\u7ed9\u7f16\u7a0b\u9898\u6dfb\u52a0\u65b0\u7684\u89e3\u51b3\u65b9\u6848 - \u8bad\u7ec3\u6dfb\u52a0\u65b9\u6848", description="\u7f16\u7a0b\u9898\u4e00\u63d0\u591a\u89e3")
    @PostMapping(value={"/program"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void addCaseProgram(@RequestBody UserProgram userProgram, HttpServletRequest request) {
        UserInfo currentUser = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        userProgram.setUserCode(currentUser.getUserCode());
        this.practiceManager.addCaseProgram(userProgram);
    }

    @Operation(summary="\u4fee\u6539\u89e3\u51b3\u65b9\u6848\u540d\u79f0 - \u8bad\u7ec3\u4fee\u6539\u65b9\u6848\u540d", description="\u8fd9\u4e2a\u53ea\u80fd\u4fee\u6539\u4e00\u4e2a\u5b57\u6bb5\uff0c\u5bf9\u8c61\u4e2d\u53ea\u8981\u6709programId\u548cprogramName\u4e24\u4e2a\u5c5e\u6027\u5c31\u53ef\u4ee5\u4e86")
    @PutMapping(value={"/program"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void updateProgramName(@RequestBody UserProgram userProgram) {
        this.practiceManager.updateProgramName(userProgram.getProgramId(), userProgram.getProgramName());
    }

    @Operation(summary="\u5220\u9664\u89e3\u51b3\u65b9\u6848 - \u8bad\u7ec3")
    @Parameter(name="programId", description="\u89e3\u51b3\u65b9\u6848ID", required=true)
    @DeleteMapping(value={"/program/{programId}"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public void deleteCaseProgram(@PathVariable(value="programId") String programId) {
        this.practiceManager.deleteCaseProgram(programId);
    }

    @Operation(summary="\u6d4b\u8bd5\u4ee3\u7801 - \u8bad\u7ec3", description="\u63d0\u4ea4\u6d4b\u8bd5\u7528\u4f8b\u548c\u4ee3\u7801\uff0c\u8fd4\u56de\u8f93\u51fa\u7ed3\u679c\uff0c\u4ee3\u66ff\u8c03\u8bd5\u5de5\u4f5c\u3002")
    @PostMapping(value={"/run"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public ResponseData runProgram(@RequestBody ProgramDto programDto, String runAsLocal) throws IOException {
        if (BooleanBaseOpt.castObjectToBoolean((Object)runAsLocal, (Boolean)false).booleanValue()) {
            return this.cppRunttimeService.runProgramLocal(programDto);
        }
        return this.cppRunttimeService.runProgramRemote(programDto);
    }

    @Operation(summary="\u63d0\u4ea4\u4ee3\u7801- \u8bad\u7ec3", description="\u63d0\u4ea4\u7f16\u7a0b\u9898\u4ee3\u7801\uff0c\u5e76\u5224\u5206\u3002")
    @PostMapping(value={"/submit"})
    @WrapUpResponseBody
    @CertificateFilter(userType="V")
    public ResponseData submitProgram(@RequestBody UserProgram userProgram, String runAsLocal) throws IOException {
        if (BooleanBaseOpt.castObjectToBoolean((Object)runAsLocal, (Boolean)false).booleanValue()) {
            return this.cppRunttimeService.submitProgramLocal(userProgram);
        }
        return this.cppRunttimeService.submitProgramRemote(userProgram);
    }
}

