/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.auth;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ObjectException;
import com.codefans.training.framework.auth.CertificateFilter;
import com.codefans.training.framework.session.SessionDataUtils;
import com.codefans.training.module.UserInfo;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class CertificateFilterAspect {
    @Pointcut(value="@annotation(com.codefans.training.framework.auth.CertificateFilter)")
    public void certFilter() {
    }

    private String makeMessage(CertificateFilter filterInfo, String defaultMessage) {
        return StringUtils.isBlank((CharSequence)filterInfo.message()) ? defaultMessage : filterInfo.message();
    }

    @Before(value="certFilter() && @annotation(filterInfo)")
    public void doBefore(JoinPoint joinPoint, CertificateFilter filterInfo) {
        if (StringUtils.isBlank((CharSequence)filterInfo.userType())) {
            return;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            throw new ObjectException(302, this.makeMessage(filterInfo, "\u7528\u6237\u6ca1\u6709\u767b\u5f55\uff0c\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f\uff01"));
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        UserInfo userInfo = SessionDataUtils.getSessionUser((HttpServletRequest)request);
        if (userInfo == null) {
            throw new ObjectException(302, this.makeMessage(filterInfo, "\u7528\u6237\u6ca1\u6709\u767b\u5f55\uff0c\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f\uff01"));
        }
        if ("A".equals(filterInfo.userType())) {
            return;
        }
        if ("V".equals(filterInfo.userType()) ? !StringUtils.equalsAny((CharSequence)userInfo.getUserType(), (CharSequence[])new CharSequence[]{"U", "P"}) || userInfo.getVipPeriodDate() == null || DatetimeOpt.currentUtilDate().after(userInfo.getVipPeriodDate()) : !filterInfo.userType().contains(userInfo.getUserType())) {
            throw new ObjectException(403, this.makeMessage(filterInfo, "\u7528\u6237\u6ca1\u6709\u6ca1\u6709\u6743\u9650\uff01"));
        }
    }
}

