/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.common;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.file.FileType;
import com.centit.support.xml.XMLObject;
import com.codefans.training.framework.common.ResponseData;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonResultUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonResultUtils.class);
    private static final String DEFAULT_RESPONSE_CHARACTER = "UTF-8";

    private JsonResultUtils() {
    }

    public static <T> void writeOriginalResponse(String contentType, T objValue, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        try {
            if (objValue instanceof String) {
                response.getWriter().write((String)objValue);
            } else {
                response.getWriter().print(objValue);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalJson(Object json, HttpServletResponse response) {
        String objectString = json instanceof JSONObject || json instanceof JSONArray ? json.toString() : JSON.toJSONString((Object)json);
        JsonResultUtils.writeOriginalResponse((String)"application/json; charset=utf-8", (Object)objectString, (HttpServletResponse)response);
    }

    public static void writeOriginalJson(String jsonValue, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse((String)"application/json; charset=utf-8", (Object)jsonValue, (HttpServletResponse)response);
    }

    public static <T> void writeOriginalHtml(T objValue, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse((String)"text/html; charset=utf-8", objValue, (HttpServletResponse)response);
    }

    public static void writeOriginalXml(String xml, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse((String)"text/xml; charset=utf-8", (Object)xml, (HttpServletResponse)response);
    }

    public static void writeOriginalImage(RenderedImage image, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("image/gif");
        try (ServletOutputStream os = response.getOutputStream();){
            ImageIO.write(image, "gif", (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalFile(InputStream is, String fileName, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(FileType.getFileMimeType((String)fileName));
        response.setHeader("Content-Disposition", "attachment; filename=" + StringEscapeUtils.escapeHtml4((String)fileName));
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            int length;
            byte[] buffer = new byte[65536];
            while ((length = is.read(buffer, 0, buffer.length)) != -1) {
                bufferOut.write(buffer, 0, length);
                bufferOut.flush();
            }
        }
        catch (IOException e) {
            logger.error("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalFile(File file, HttpServletResponse response) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            JsonResultUtils.writeOriginalFile((InputStream)inputStream, (String)file.getName(), (HttpServletResponse)response);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u6253\u5f00\u5931\u8d25\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void writeOriginalObject(Object objValue, HttpServletResponse response) {
        if (ReflectionOpt.isScalarType(objValue.getClass())) {
            JsonResultUtils.writeOriginalResponse((String)"text/plain; charset=utf-8", (Object)JSON.toJSONString((Object)objValue), (HttpServletResponse)response);
        } else {
            String objectString = objValue instanceof JSONObject || objValue instanceof JSONArray ? objValue.toString() : JSON.toJSONString((Object)objValue);
            JsonResultUtils.writeOriginalResponse((String)"application/json; charset=utf-8", (Object)objectString, (HttpServletResponse)response);
        }
    }

    public static void writeJavaScript(String scriptValue, HttpServletResponse response) {
        JsonResultUtils.writeOriginalResponse((String)"application/javascript; charset=utf-8", (Object)scriptValue, (HttpServletResponse)response);
    }

    public static void writeSingleDataJson(int code, String message, Object objValue, HttpServletResponse response, PropertyPreFilter simplePropertyPreFilter) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", code);
        param.put("message", message);
        if (objValue != null) {
            param.put("data", objValue);
        }
        String text = JSON.toJSONString(param, (Filter)simplePropertyPreFilter, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        JsonResultUtils.writeOriginalJson((String)text, (HttpServletResponse)response);
    }

    public static void writeSingleDataXml(int code, String message, Object objValue, HttpServletResponse response) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", code);
        param.put("message", message);
        if (objValue != null) {
            param.put("data", objValue);
        }
        String text = XMLObject.objectToXMLString((String)"response", param);
        JsonResultUtils.writeOriginalXml((String)text, (HttpServletResponse)response);
    }

    public static void writeResponseDataAsJson(ResponseData resData, HttpServletResponse response, PropertyPreFilter propertyPreFilter) {
        JsonResultUtils.writeSingleDataJson((int)resData.getCode(), (String)resData.getMessage(), (Object)resData.getData(), (HttpServletResponse)response, (PropertyPreFilter)propertyPreFilter);
    }

    public static void writeResponseDataAsJson(ResponseData resData, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)resData.getCode(), (String)resData.getMessage(), (Object)resData.getData(), (HttpServletResponse)response, null);
    }

    public static void writeResponseDataAsXml(ResponseData resData, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataXml((int)resData.getCode(), (String)resData.getMessage(), (Object)resData.getData(), (HttpServletResponse)response);
    }

    public static void writeHttpErrorMessage(int errorCode, String errorMessage, HttpServletResponse response) {
        try {
            response.sendError(errorCode, errorMessage);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeErrorMessageJson(int errorCode, String errorMessage, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)errorCode, (String)errorMessage, null, (HttpServletResponse)response, null);
    }

    public static void writeMessageJson(String message, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)0, (String)message, null, (HttpServletResponse)response, null);
    }

    public static void writeMessageAndData(String message, Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)0, (String)message, (Object)objValue, (HttpServletResponse)response, null);
    }

    public static void writeErrorMessageJson(String errorMessage, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)500, (String)errorMessage, null, (HttpServletResponse)response, null);
    }

    public static void writeBlankJson(HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)0, (String)"OK", null, (HttpServletResponse)response, null);
    }

    public static void writeSingleDataJson(Object objValue, HttpServletResponse response, PropertyPreFilter simplePropertyPreFilter) {
        JsonResultUtils.writeSingleDataJson((int)0, (String)"OK", (Object)objValue, (HttpServletResponse)response, (PropertyPreFilter)simplePropertyPreFilter);
    }

    public static void writeSingleDataJson(Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)0, (String)"OK", (Object)objValue, (HttpServletResponse)response, null);
    }

    public static void writeSingleDataXml(Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataXml((int)0, (String)"OK", (Object)objValue, (HttpServletResponse)response);
    }

    public static void writeSingleErrorDataJson(int errorCode, String errorMessage, Object objValue, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((int)errorCode, (String)errorMessage, (Object)objValue, (HttpServletResponse)response, null);
    }

    public static void writeSuccessJson(HttpServletResponse response) {
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

