/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.common;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.codefans.training.framework.common.ImmutableResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import com.codefans.training.framework.common.ResponseSingleData;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Schema(name="\u7edf\u4e00\u7684\u8fd4\u56de\u7c7b", title="\u8fd4\u56de\u7684json\u6570\u636e\u683c\u5f0f")
public interface ResponseData
extends Serializable {
    public static final int RESULT_OK = 0;
    public static final int ERROR_USER_LOGIN_ERROR = 101;
    public static final int HTTP_CONTINUE = 100;
    public static final int HTTP_SWITCHING_PROTOCOLS = 101;
    public static final int HTTP_PROCESSING = 102;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET_CONTENT = 205;
    public static final int HTTP_PARTIAL_CONTENT = 206;
    public static final int HTTP_MULTIPLE_CHOICES = 300;
    public static final int HTTP_MOVED_PERMANENTLY = 301;
    public static final int HTTP_MOVE_TEMPORARILY = 302;
    public static final int ERROR_USER_NOT_LOGIN = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_SWITCH_PROXY = 306;
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int ERROR_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int ERROR_UNAUTHORIZED = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int ERROR_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int ERROR_NOT_FOUND = 404;
    public static final int HTTP_METHOD_NOT_ALLOWED = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int ERROR_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int HTTP_REQUEST_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECONDITION_FAILED = 412;
    public static final int HTTP_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQUEST_URI_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int HTTP_EXPECTATION_FAILED = 417;
    public static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    public static final int HTTP_LOCKED = 423;
    public static final int HTTP_FAILED_DEPENDENCY = 424;
    public static final int HTTP_UNORDERED_COLLECTION = 425;
    public static final int HTTP_UPGRADE_REQUIRED = 426;
    public static final int HTTP_RETRY_WITH = 449;
    public static final int HTTP_INTERNAL_SERVER_ERROR = 500;
    public static final int ERROR_INTERNAL_SERVER_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_SERVICE_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int HTTP_VARIANT_ALSO_NEGOTIATES = 506;
    public static final int HTTP_INSUFFICIENT_STORAGE = 507;
    public static final int HTTP_BANDWIDTH_LIMIT_EXCEEDED = 509;
    public static final int HTTP_NOT_EXTENDED = 510;
    public static final int HTTP_UNPARSEABLE_RESPONSE_HEADERS = 600;
    public static final int ERROR_PROCESS_ERROR = 700;
    public static final int ERROR_FIELD_INPUT_NOT_VALID = 701;
    public static final int ERROR_FIELD_INPUT_CONFLICT = 702;
    public static final int ERROR_PRECONDITION_FAILED = 703;
    public static final int ERROR_PROCESS_FAILED = 704;
    public static final int ERROR_POSTCONDITION_FAILED = 705;
    public static final int ERROR_BAD_PROCESS_POWER = 706;
    public static final int ERROR_BAD_PROCESS_DATASCOPE = 707;
    public static final int ERROR_METHOD_DISABLED = 708;
    public static final int ERROR_SESSION_TIMEOUT = 709;
    public static final int ERROR_USER_NOTFOUND = 710;
    public static final int ERROR_USER_CONFIG = 711;
    public static final int ERROR_SYSTEM_CONFIG = 712;
    public static final int ERROR_OPERATION = 800;
    public static final String RES_CODE_FILED = "code";
    public static final String RES_MSG_FILED = "message";
    public static final String RES_DATA_FILED = "data";
    public static final ResponseData successResponse = new ImmutableResponseData();
    public static final ResponseData errorResponse = new ImmutableResponseData(500, "\u5185\u90e8\u672a\u77e5\u9519\u8bef\uff01");

    @Schema(name="\u6807\u5fd7\u6027\u4ee3\u7801", title="\u7ed3\u679c\u7f16\u7801\uff0c0\uff1a\u6210\u529f\uff0c\u5176\u4ed6\uff1a\u9519\u8bef\u7f16\u7801\u3002")
    public int getCode();

    @Schema(name="\u8fd4\u56de\u4fe1\u606f", title="code=0\uff1a\u6d88\u606f\uff1acode!=0:\u9519\u8bef\u4fe1\u606f\u3002")
    public String getMessage();

    @Schema(name="\u8fd4\u56de\u6570\u636e", title="JSON\u683c\u5f0f\u7684\u6570\u636e\u5185\u5bb9\uff0c\u6839\u636e\u4e1a\u52a1\u7684\u9700\u8981\u5b9a\u4e49;\u524d\u7aef\u53ef\u4ee5\u901a\u8fc7\u5728\u7ebf\u8c03\u8bd5\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002")
    public Object getData();

    default public String toJSONString(PropertyPreFilter simplePropertyPreFilter) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(RES_CODE_FILED, this.getCode());
        param.put(RES_MSG_FILED, this.getMessage());
        if (this.getData() != null) {
            param.put(RES_DATA_FILED, this.getData());
            if (simplePropertyPreFilter != null) {
                return JSON.toJSONString(param, (Filter)simplePropertyPreFilter, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
            }
        }
        return JSONObject.toJSONString(param, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    default public String toJSONString() {
        return this.toJSONString(null);
    }

    public static ResponseSingleData makeSuccessResponse() {
        return new ResponseSingleData();
    }

    public static ResponseSingleData makeSuccessResponse(String message) {
        return new ResponseSingleData(message);
    }

    public static ResponseSingleData makeErrorMessage(String message) {
        return new ResponseSingleData(500, message);
    }

    public static ResponseSingleData makeErrorMessage(int errorCode, String message) {
        return new ResponseSingleData(errorCode, message);
    }

    public static ResponseSingleData makeErrorMessageWithData(Object obj, int errorCode, String message) {
        ResponseSingleData response = new ResponseSingleData(errorCode, message);
        response.setData(obj);
        return response;
    }

    public static ResponseSingleData makeResponseData(Object objValue) {
        return ResponseSingleData.makeResponseData((Object)objValue);
    }

    public static ResponseData makeResponseData(String message, Object objValue) {
        ResponseSingleData response = new ResponseSingleData(message);
        response.setData(objValue);
        return response;
    }

    public static ResponseMapData makeResponseData(Map<String, Object> resMapData) {
        return ResponseMapData.makeResponseData(resMapData);
    }
}

