/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.controller;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.QueryUtils;
import com.codefans.training.framework.common.JsonResultUtils;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import com.codefans.training.framework.common.WebOptUtils;
import com.codefans.training.framework.controller.DatePropertiesEditor;
import com.codefans.training.framework.controller.SqlDatePropertiesEditor;
import com.codefans.training.framework.controller.SqlTimestampPropertiesEditor;
import com.codefans.training.framework.controller.StringPropertiesEditor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyEditor;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

public abstract class BaseController {
    public static final String OBJLIST = "objList";
    public static final String PAGE_DESC = "pageDesc";
    protected Logger logger = LoggerFactory.getLogger(BaseController.class);
    protected boolean logDebug = this.logger.isDebugEnabled();

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(4096);
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringPropertiesEditor(true));
        binder.registerCustomEditor(java.util.Date.class, (PropertyEditor)new DatePropertiesEditor());
        binder.registerCustomEditor(Date.class, (PropertyEditor)new SqlDatePropertiesEditor());
        binder.registerCustomEditor(Timestamp.class, (PropertyEditor)new SqlTimestampPropertiesEditor());
    }

    @ExceptionHandler
    public void exceptionHandler(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        if (ex == null) {
            this.logger.error("\u672a\u77e5\u9519\u8bef\uff0ccause by " + request.getRequestURL().toString());
            return;
        }
        if (ex instanceof ObjectException) {
            ObjectException objex = (ObjectException)ex;
            this.logger.error(ObjectException.extortExceptionTraceMessage((Throwable)objex, (int)1) + ex.getMessage());
            if (WebOptUtils.exceptionNotAsHttpError && (objex.getExceptionCode() == 302 || objex.getExceptionCode() == 401)) {
                JsonResultUtils.writeHttpErrorMessage((int)objex.getExceptionCode(), (String)objex.getLocalizedMessage(), (HttpServletResponse)response);
            } else {
                ResponseMapData responseData = new ResponseMapData(objex.getExceptionCode(), ObjectException.extortExceptionOriginMessage((Throwable)objex));
                if (this.logDebug) {
                    responseData.addResponseData("trace", (Object)ObjectException.extortExceptionTraceMessage((Throwable)objex));
                }
                responseData.addResponseData("object", objex.getObjectData());
                JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response);
            }
            return;
        }
        this.logger.error(ObjectException.extortExceptionMessage((Throwable)ex));
        if (ex instanceof BindException) {
            BindException bindingResult = (BindException)ex;
            ResponseMapData responseData = new ResponseMapData(400);
            StringBuilder errMsg = new StringBuilder();
            if (bindingResult.hasErrors()) {
                for (FieldError fieldError : bindingResult.getFieldErrors()) {
                    responseData.addResponseData(fieldError.getField(), (Object)fieldError.getDefaultMessage());
                    errMsg.append(fieldError.getField()).append("\uff1a").append(fieldError.getDefaultMessage()).append("\uff1b");
                }
            }
            responseData.setMessage(errMsg.toString());
            JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response);
            return;
        }
        ResponseMapData responseData = new ResponseMapData(500, ObjectException.extortExceptionOriginMessage((Throwable)ex));
        if (this.logDebug) {
            responseData.addResponseData("trace", (Object)ObjectException.extortExceptionTraceMessage((Throwable)ex));
        }
        JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response);
    }

    public static Map<String, Object> collectRequestParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry ent : parameterMap.entrySet()) {
            String valueName;
            String[] values;
            String pretreatmentSql = (String)ent.getKey();
            if (pretreatmentSql.startsWith("_") || (values = CollectionsOpt.removeBlankString((String[])((String[])ent.getValue()))) == null) continue;
            Object paramValue = values.length == 1 ? values[0] : values;
            ImmutableTriple paramDesc = QueryUtils.parseParameter((String)pretreatmentSql);
            String pretreatment = (String)paramDesc.getRight();
            String string = valueName = StringUtils.isBlank((CharSequence)((CharSequence)paramDesc.getMiddle())) ? (String)paramDesc.getLeft() : (String)paramDesc.getMiddle();
            if (StringUtils.isNotBlank((CharSequence)pretreatment)) {
                paramValue = QueryUtils.pretreatParameter((String)pretreatment, (Object)paramValue);
            }
            map.put(valueName, paramValue);
        }
        return map;
    }
}

