/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.framework.session;

import com.centit.support.algorithm.CollectionsOpt;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HeaderHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionIdResolver;

public class SmartHttpSessionResolver
implements HttpSessionIdResolver {
    private CookieHttpSessionIdResolver browser;
    private HeaderHttpSessionIdResolver api;
    private boolean cookieFirst;
    private boolean addAccessToken;

    public List<String> resolveAccessTokenSessionId(HttpServletRequest request) {
        String sessionId;
        if (this.addAccessToken && StringUtils.isNotBlank((CharSequence)(sessionId = request.getParameter("x-auth-token")))) {
            return CollectionsOpt.createList((Object[])new String[]{sessionId});
        }
        return CollectionsOpt.createList((Object[])new String[0]);
    }

    public SmartHttpSessionResolver(boolean cookieFirst, String cookiePath, boolean addAccessToken) {
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        cookieSerializer.setCookiePath(cookiePath);
        this.browser = new CookieHttpSessionIdResolver();
        this.browser.setCookieSerializer((CookieSerializer)cookieSerializer);
        this.api = new HeaderHttpSessionIdResolver("x-auth-token");
        this.cookieFirst = cookieFirst;
        this.addAccessToken = addAccessToken;
    }

    public List<String> resolveSessionIds(HttpServletRequest request) {
        if (this.cookieFirst) {
            List sessionIds = this.browser.resolveSessionIds(request);
            if (sessionIds != null && sessionIds.size() > 0) {
                return sessionIds;
            }
            sessionIds = this.api.resolveSessionIds(request);
            if (sessionIds != null && sessionIds.size() > 0) {
                return sessionIds;
            }
            return this.resolveAccessTokenSessionId(request);
        }
        List sessionIds = this.api.resolveSessionIds(request);
        if (sessionIds != null && sessionIds.size() > 0) {
            return sessionIds;
        }
        sessionIds = this.resolveAccessTokenSessionId(request);
        if (sessionIds != null && sessionIds.size() > 0) {
            return sessionIds;
        }
        return this.browser.resolveSessionIds(request);
    }

    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        this.api.setSessionId(request, response, sessionId);
        this.browser.setSessionId(request, response, sessionId);
    }

    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
        this.api.expireSession(request, response);
        this.browser.expireSession(request, response);
    }
}

