/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.repository;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.codefans.training.module.CaseInfo;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class CaseInfoDao
extends BaseDaoImpl<CaseInfo, String> {
    public List<CaseInfo> listCourseCases(String courseId, boolean includeSubCase) {
        if (includeSubCase) {
            return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId}));
        }
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId, "caseCatalog", "C"}));
    }

    public int countCourseCases(String courseId) {
        return this.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId}));
    }

    public JSONArray listSubCases(String preCaseId, boolean removeAnswer) {
        Object sql = "select CASE_ID, CASE_CATALOG, CASE_TYPE, CASE_STATUS, COURSE_ID, PLAN_ID, CASE_TITLE, CASE_CONTENT, CASE_SERIAL, CASE_SCORE, ";
        if (!removeAnswer) {
            sql = (String)sql + "STANDARD_ANSWER, ";
        }
        sql = (String)sql + "CASE_GRADE, PRE_CASE_ID, OPTIONS_SUM, TEST_SUM, FAVOR_SCORE, PASSED_USER, TIME_LIMIT, SPACE_LIMIT, COMPARISON_MODE, JUDGING_CODE from CASE_INFO where PRE_CASE_ID = ? order by CASE_SERIAL";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{preCaseId});
    }

    public boolean isExistSerial(String courseId, Integer courseSerial) {
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(1) as hasCase from CASE_INFO where COURSE_ID=? and CASE_CATALOG='C' and CASE_SERIAL=?", (Object[])new Object[]{courseId, courseSerial})) > 0;
    }

    public void moveCaseSerial(String courseId, Integer fromSerial, Integer toSerial) {
        if (fromSerial < toSerial) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL-1 where COURSE_ID=? and CASE_CATALOG='C' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{courseId, fromSerial, toSerial});
        } else {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL+1 where COURSE_ID=? and CASE_CATALOG='C' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{courseId, toSerial, fromSerial});
        }
    }

    public void moveSubCaseSerial(String preCaseId, Integer fromSerial, Integer toSerial) {
        if (fromSerial < toSerial) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL-1 where PRE_CASE_ID=? and CASE_CATALOG='S' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{preCaseId, fromSerial, toSerial});
        } else {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=CASE_SERIAL+1 where PRE_CASE_ID=? and CASE_CATALOG='S' and CASE_SERIAL>=? and CASE_SERIAL<=?", (Object[])new Object[]{preCaseId, toSerial, fromSerial});
        }
    }

    public void moveSubCaseCourse(String preCaseId, String newCourseId) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set COURSE_ID = \uff1f where PRE_CASE_ID=? ", (Object[])new Object[]{newCourseId, preCaseId});
    }

    public CaseInfo getCaseBySerial(String courseId, Integer caseSerial) {
        return (CaseInfo)this.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"courseId", courseId, "caseSerial", caseSerial}));
    }

    public void updateCaseSerial(String caseId, Integer newSerial) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_SERIAL=? where CASE_ID=?", (Object[])new Object[]{newSerial, caseId});
    }

    public void updateCaseTestSum(String caseId, Integer testSum) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set TEST_SUM = ? where CASE_ID=?", (Object[])new Object[]{testSum, caseId});
    }

    public void updateCaseStatus(String caseId, String status) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO set CASE_STATUS = ? where CASE_ID=?", (Object[])new Object[]{status, caseId});
    }

    public void updateCompoundCaseScore(String preCaseId) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select sum(b.CASE_SCORE) from CASE_INFO b where b.PRE_CASE_ID = ? ", (Object[])new Object[]{preCaseId});
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update CASE_INFO a set a.CASE_SCORE= ?  where a.CASE_ID = ?", (Object[])new Object[]{NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)0), preCaseId});
    }
}

