/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.repository;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.codefans.training.module.UserPlan;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class UserPlanDao
extends BaseDaoImpl<UserPlan, JSONObject> {
    public UserPlan getUserPlan(String userId, String planId) {
        return (UserPlan)this.getObjectById((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userId, "planId", planId}));
    }

    public UserPlan getUserCurrentPlan(String userId, String planType) {
        List userPlanList = this.listObjectsByFilter(" join COURSE_PLAN b on a.PLAN_ID = b.PLAN_ID where a.USER_CODE = :userCode and a.USER_PLAN_STATUS = 'A' and b.PLAN_TYPE = :planType ", CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userId, "planType", "A", planType}), "a");
        if (userPlanList == null || userPlanList.isEmpty()) {
            return null;
        }
        return (UserPlan)userPlanList.get(0);
    }

    public void updateUserPlanStatus(String userId, String planId, String status) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update USER_PLAN set USER_PLAN_STATUS = ?, LAST_UPDATE_TIME = ? where USER_CODE = ? and PLAN_ID = ?", (Object[])new Object[]{status, DatetimeOpt.currentUtilDate(), userId, planId});
    }

    public Date fetchLastChangePlanTime(String userId, String planType) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select max(a.START_TIME) as startTime from USER_PLAN a  join COURSE_PLAN b on a.PLAN_ID = b.PLAN_ID  where a.USER_CODE = ? and a.JOIN_PLAN_TYPE = 'U' and b.PLAN_TYPE = ? ", (Object[])new Object[]{userId, planType});
        return DatetimeOpt.castObjectToDate((Object)obj);
    }

    public Integer fetchUserPlanLevel(String userCode, String planType) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select max(a.PLAN_LEVEL) as PLAN_LEVEL from COURSE_PLAN a join USER_PLAN b  on a.PLAN_ID = b.PLAN_ID where a.PLAN_TYPE = ? and b.USER_CODE=?", (Object[])new Object[]{planType, userCode});
        return NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)-1);
    }

    public Integer countUnsubscribePlan(String userCode, String planType) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(1) as PLAN_SUM from COURSE_PLAN a where a.PLAN_TYPE = ? and a.PLAN_STATUS = 'P'  and not exists (select * from USER_PLAN b where b.PLAN_ID = a.PLAN_ID and b.USER_CODE = ? )", (Object[])new Object[]{planType, userCode});
        return NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)0);
    }
}

