/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.sandbox;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import com.codefans.training.sandbox.Constants;
import com.codefans.training.sandbox.SystemError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class SandboxRun {
    private static final Logger log = LoggerFactory.getLogger((String)"hojSandboxRun");
    private static final RestTemplate restTemplate;
    private static final SandboxRun instance;
    private static String SANDBOX_BASE_URL;
    private static String COMPILE_CMD;
    public static final HashMap<String, Integer> RESULT_MAP_STATUS;
    private static final int maxProcessNumber = 128;
    private static final int TIME_LIMIT_MS = 16000;
    private static final int MEMORY_LIMIT_MB = 512;
    private static final int STACK_LIMIT_MB = 128;
    private static final int STDIO_SIZE_MB = 32;
    public static final List<String> signals;
    private static final JSONArray COMPILE_FILES;

    private SandboxRun() {
    }

    public static String setSandboxBaseUrl(String judgeServerUrl) {
        SANDBOX_BASE_URL = judgeServerUrl;
        return SANDBOX_BASE_URL;
    }

    public static String setCompileCmd(String compileCmd) {
        COMPILE_CMD = compileCmd;
        return COMPILE_CMD;
    }

    private JSONArray run(String uri, JSONObject param) throws SystemError {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)JSON.toJSONString((Object)param), (MultiValueMap)headers);
        try {
            ResponseEntity postForEntity = restTemplate.postForEntity(SANDBOX_BASE_URL + uri, (Object)request, String.class, new Object[0]);
            return JSONArray.parseArray((String)((String)postForEntity.getBody()), (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        catch (RestClientResponseException ex) {
            if (!ex.getStatusCode().is2xxSuccessful()) {
                throw new SystemError("Cannot connect to sandbox service.", null, ex.getResponseBodyAsString());
            }
        }
        catch (Exception e) {
            throw new SystemError("Call SandBox Error.", null, e.getMessage());
        }
        return null;
    }

    public static void deleteFile(String fileId) {
        block2: {
            try {
                restTemplate.delete(SANDBOX_BASE_URL + "/file/{0}", new Object[]{fileId});
            }
            catch (RestClientResponseException ex) {
                if (ex.getStatusCode().is2xxSuccessful()) break block2;
                log.error("\u5b89\u5168\u6c99\u7bb1\u5224\u9898\u7684\u5220\u9664\u5185\u5b58\u4e2d\u7684\u6587\u4ef6\u7f13\u5b58\u64cd\u4f5c\u5f02\u5e38---->" + ex.getMessage());
            }
        }
    }

    public static byte[] getFile(String fileId) {
        try {
            ResponseEntity responseEntity = restTemplate.exchange(SANDBOX_BASE_URL + "/file/{0}", HttpMethod.GET, null, byte[].class, new Object[]{fileId});
            return (byte[])responseEntity.getBody();
        }
        catch (RestClientResponseException ex) {
            log.error("\u5b89\u5168\u6c99\u7bb1\u5224\u9898\u7684\u83b7\u53d6\u5185\u5b58\u4e2d\u7684\u6587\u4ef6\u7f13\u5b58\u64cd\u4f5c\u5f02\u5e38---->" + ex.getMessage());
            return null;
        }
    }

    public static String uploadFile(InputStream inputStream) {
        try {
            HttpExecutorContext executorContext = new HttpExecutorContext();
            return HttpExecutor.inputStreamUpload((HttpExecutorContext)executorContext, (String)(SANDBOX_BASE_URL + "/file"), (InputStream)inputStream, (String)"file", (ContentType)ContentType.TEXT_PLAIN, (String)"hello.txt");
        }
        catch (IOException ex) {
            log.error("\u5b89\u5168\u6c99\u7bb1\u5224\u9898\u7684\u4e0a\u4f20\u6587\u4ef6\u7f13\u5b58\u64cd\u4f5c\u5f02\u5e38----> " + ex.getMessage());
            return null;
        }
    }

    public static JSONArray compile(Long maxCpuTime, Long maxRealTime, Long maxMemory, Long maxStack, String srcName, String exeName, String code, HashMap<String, String> extraFiles, Boolean needCopyOutCached, Boolean needCopyOutExe, String copyOutDir) throws SystemError {
        JSONObject cmd = new JSONObject();
        cmd.put((Object)"args", (Object)CollectionsOpt.createList((Object[])new String[]{COMPILE_CMD, "-DONLINE_JUDGE", "-w", "-fmax-errors=1", "-std=c++14", srcName, "-lm", "-o", exeName}));
        cmd.put((Object)"env", (Object)new JSONArray(new Object[]{"PATH=/usr/bin:/bin"}));
        cmd.put((Object)"files", (Object)COMPILE_FILES);
        cmd.put((Object)"cpuLimit", (Object)(maxCpuTime * 1000L * 1000L));
        cmd.put((Object)"clockLimit", (Object)(maxRealTime * 1000L * 1000L));
        cmd.put((Object)"memoryLimit", (Object)maxMemory);
        cmd.put((Object)"procLimit", (Object)128);
        cmd.put((Object)"stackLimit", (Object)maxStack);
        JSONObject fileContent = new JSONObject();
        fileContent.put((Object)"content", (Object)code);
        JSONObject copyIn = new JSONObject();
        copyIn.put((Object)srcName, (Object)fileContent);
        if (extraFiles != null) {
            for (Map.Entry<String, String> entry : extraFiles.entrySet()) {
                if (StringUtils.isBlank((CharSequence)entry.getKey()) || StringUtils.isBlank((CharSequence)entry.getValue())) continue;
                JSONObject content = new JSONObject();
                content.put((Object)"content", (Object)entry.getValue());
                copyIn.put((Object)entry.getKey(), (Object)content);
            }
        }
        cmd.put((Object)"copyIn", (Object)copyIn);
        cmd.put((Object)"copyOut", (Object)new JSONArray(new Object[]{"stdout", "stderr"}));
        if (needCopyOutCached.booleanValue()) {
            cmd.put((Object)"copyOutCached", (Object)new JSONArray(new Object[]{exeName}));
        }
        if (needCopyOutExe.booleanValue()) {
            cmd.put((Object)"copyOutDir", (Object)copyOutDir);
        }
        JSONObject param = new JSONObject();
        param.put((Object)"cmd", (Object)new JSONArray(new Object[]{cmd}));
        JSONArray result = instance.run("/run", param);
        assert (result != null);
        JSONObject compileRes = (JSONObject)result.get(0);
        compileRes.put((Object)"originalStatus", (Object)compileRes.getString("status"));
        compileRes.put((Object)"status", RESULT_MAP_STATUS.get(compileRes.getString("status")));
        return result;
    }

    public static JSONArray compile(Long maxCpuTime, Long maxRealTime, Long maxMemory, Long maxStack, String srcName, String exeName, String code) throws SystemError {
        return SandboxRun.compile((Long)maxCpuTime, (Long)maxRealTime, (Long)maxMemory, (Long)maxStack, (String)srcName, (String)exeName, (String)code, null, (Boolean)true, (Boolean)false, null);
    }

    public static JSONArray testCase(String testCasePath, String testCaseContent, Long maxTime, Long maxMemory, Long maxOutputSize, Integer maxStack, String exeName, String fileId, String fileContent, Boolean isFileIO, String ioReadFileName, String ioWriteFileName) throws SystemError {
        JSONObject cmd = new JSONObject();
        cmd.put((Object)"args", (Object)CollectionsOpt.createList((Object[])new String[]{exeName}));
        cmd.put((Object)"env", (Object)new JSONArray(new Object[]{"PATH=/usr/bin:/bin"}));
        JSONArray files = new JSONArray();
        JSONObject testCaseInput = new JSONObject();
        if (StringUtils.isBlank((CharSequence)testCasePath)) {
            testCaseInput.put((Object)"content", (Object)testCaseContent);
        } else {
            testCaseInput.put((Object)"src", (Object)testCasePath);
        }
        if (!BooleanBaseOpt.castObjectToBoolean((Object)isFileIO, (Boolean)false).booleanValue()) {
            JSONObject stdout = new JSONObject();
            stdout.put((Object)"name", (Object)"stdout");
            stdout.put((Object)"max", (Object)maxOutputSize);
            files.add((Object)testCaseInput);
            files.add((Object)stdout);
        }
        JSONObject stderr = new JSONObject();
        stderr.put((Object)"name", (Object)"stderr");
        stderr.put((Object)"max", (Object)0x1000000);
        files.add((Object)stderr);
        cmd.put((Object)"files", (Object)files);
        cmd.put((Object)"cpuLimit", (Object)(maxTime * 1000L * 1000L));
        cmd.put((Object)"clockLimit", (Object)(maxTime * 1000L * 1000L * 3L));
        cmd.put((Object)"memoryLimit", (Object)((maxMemory + 100L) * 1024L * 1024L));
        cmd.put((Object)"procLimit", (Object)128);
        cmd.put((Object)"stackLimit", (Object)((long)(maxStack * 1024) * 1024L));
        JSONObject exeFile = new JSONObject();
        if (!StringUtils.isBlank((CharSequence)fileId)) {
            exeFile.put((Object)"fileId", (Object)fileId);
        } else {
            exeFile.put((Object)"content", (Object)fileContent);
        }
        JSONObject copyIn = new JSONObject();
        copyIn.put((Object)exeName, (Object)exeFile);
        JSONArray copyOut = new JSONArray();
        copyOut.add((Object)"stderr");
        if (!BooleanBaseOpt.castObjectToBoolean((Object)isFileIO, (Boolean)false).booleanValue()) {
            copyOut.add((Object)"stdout");
        } else {
            copyIn.put((Object)ioReadFileName, (Object)testCaseInput);
            copyOut.add((Object)(ioWriteFileName + "?"));
        }
        cmd.put((Object)"copyIn", (Object)copyIn);
        cmd.put((Object)"copyOut", (Object)copyOut);
        JSONObject param = new JSONObject();
        param.put((Object)"cmd", (Object)new JSONArray(new Object[]{cmd}));
        JSONArray result = instance.run("/run", param);
        JSONObject testcaseRes = (JSONObject)result.get(0);
        testcaseRes.put((Object)"originalStatus", (Object)testcaseRes.getString("status"));
        testcaseRes.put((Object)"status", RESULT_MAP_STATUS.get(testcaseRes.getString("status")));
        return result;
    }

    public static JSONArray testCase(String testCaseContent, Long maxTime, Long maxMemory, Long maxOutputSize, Integer maxStack, String exeName, String fileId) throws SystemError {
        return SandboxRun.testCase(null, (String)testCaseContent, (Long)maxTime, (Long)maxMemory, (Long)maxOutputSize, (Integer)maxStack, (String)exeName, (String)fileId, null, (Boolean)false, null, null);
    }

    public static JSONArray testCaseInFile(String inputFileId, Long maxTime, Long maxMemory, Long maxOutputSize, Integer maxStack, String exeName, String fileId) throws SystemError {
        return SandboxRun.testCase((String)inputFileId, null, (Long)maxTime, (Long)maxMemory, (Long)maxOutputSize, (Integer)maxStack, (String)exeName, (String)fileId, null, (Boolean)false, null, null);
    }

    public static JSONArray spjCheckResult(List<String> args, List<String> envs, String userOutputFilePath, String userOutputFileName, String testCaseInputFilePath, String testCaseInputFileName, String testCaseOutputFilePath, String testCaseOutputFileName, String spjExeSrc, String spjExeName) throws SystemError {
        JSONObject cmd = new JSONObject();
        cmd.put((Object)"args", args);
        cmd.put((Object)"env", envs);
        JSONArray outFiles = new JSONArray();
        JSONObject content = new JSONObject();
        content.put((Object)"content", (Object)"");
        JSONObject outStdout = new JSONObject();
        outStdout.put((Object)"name", (Object)"stdout");
        outStdout.put((Object)"max", (Object)0x1000000);
        JSONObject outStderr = new JSONObject();
        outStderr.put((Object)"name", (Object)"stderr");
        outStderr.put((Object)"max", (Object)0x1000000);
        outFiles.add((Object)content);
        outFiles.add((Object)outStdout);
        outFiles.add((Object)outStderr);
        cmd.put((Object)"files", (Object)outFiles);
        cmd.put((Object)"cpuLimit", (Object)16000000000L);
        cmd.put((Object)"clockLimit", (Object)48000000000L);
        cmd.put((Object)"memoryLimit", (Object)0x20000000L);
        cmd.put((Object)"procLimit", (Object)128);
        cmd.put((Object)"stackLimit", (Object)0x8000000L);
        JSONObject spjExeFile = new JSONObject();
        spjExeFile.put((Object)"src", (Object)spjExeSrc);
        JSONObject useOutputFileSrc = new JSONObject();
        useOutputFileSrc.put((Object)"src", (Object)userOutputFilePath);
        JSONObject stdInputFileSrc = new JSONObject();
        stdInputFileSrc.put((Object)"src", (Object)testCaseInputFilePath);
        JSONObject stdOutFileSrc = new JSONObject();
        stdOutFileSrc.put((Object)"src", (Object)testCaseOutputFilePath);
        JSONObject spjCopyIn = new JSONObject();
        spjCopyIn.put((Object)spjExeName, (Object)spjExeFile);
        spjCopyIn.put((Object)userOutputFileName, (Object)useOutputFileSrc);
        spjCopyIn.put((Object)testCaseInputFileName, (Object)stdInputFileSrc);
        spjCopyIn.put((Object)testCaseOutputFileName, (Object)stdOutFileSrc);
        cmd.put((Object)"copyIn", (Object)spjCopyIn);
        cmd.put((Object)"copyOut", (Object)new JSONArray(new Object[]{"stdout", "stderr"}));
        JSONObject param = new JSONObject();
        param.put((Object)"cmd", (Object)new JSONArray(new Object[]{cmd}));
        JSONArray result = instance.run("/run", param);
        JSONObject spjRes = (JSONObject)result.get(0);
        spjRes.put((Object)"originalStatus", (Object)spjRes.getString("status"));
        spjRes.put((Object)"status", RESULT_MAP_STATUS.get(spjRes.getString("status")));
        return result;
    }

    public static JSONArray interactTestCase(List<String> args, List<String> envs, String userExeName, String userFileId, String userFileContent, Long userMaxTime, Long userMaxMemory, Integer userMaxStack, String testCaseInputPath, String testCaseInputFileName, String testCaseOutputFilePath, String testCaseOutputFileName, String userOutputFileName, List<String> interactArgs, List<String> interactEnvs, String interactExeSrc, String interactExeName) throws SystemError {
        JSONObject pipeInputCmd = new JSONObject();
        pipeInputCmd.put((Object)"args", args);
        pipeInputCmd.put((Object)"env", envs);
        JSONArray files = new JSONArray();
        JSONObject stderr = new JSONObject();
        stderr.put((Object)"name", (Object)"stderr");
        stderr.put((Object)"max", (Object)0x2000000);
        files.add((Object)new JSONObject());
        files.add((Object)new JSONObject());
        files.add((Object)stderr);
        String inTmp = files.toString().replace("{}", "null");
        pipeInputCmd.put((Object)"files", (Object)JSONArray.parseArray((String)inTmp, (JSONReader.Feature[])new JSONReader.Feature[0]));
        pipeInputCmd.put((Object)"cpuLimit", (Object)(userMaxTime * 1000L * 1000L));
        pipeInputCmd.put((Object)"clockLimit", (Object)(userMaxTime * 1000L * 1000L * 3L));
        pipeInputCmd.put((Object)"memoryLimit", (Object)((userMaxMemory + 100L) * 1024L * 1024L));
        pipeInputCmd.put((Object)"procLimit", (Object)128);
        pipeInputCmd.put((Object)"stackLimit", (Object)((long)(userMaxStack * 1024) * 1024L));
        JSONObject exeFile = new JSONObject();
        if (!StringUtils.isBlank((CharSequence)userFileId)) {
            exeFile.put((Object)"fileId", (Object)userFileId);
        } else {
            exeFile.put((Object)"content", (Object)userFileContent);
        }
        JSONObject copyIn = new JSONObject();
        copyIn.put((Object)userExeName, (Object)exeFile);
        pipeInputCmd.put((Object)"copyIn", (Object)copyIn);
        pipeInputCmd.put((Object)"copyOut", (Object)new JSONArray());
        JSONObject pipeOutputCmd = new JSONObject();
        pipeOutputCmd.put((Object)"args", interactArgs);
        pipeOutputCmd.put((Object)"env", interactEnvs);
        JSONArray outFiles = new JSONArray();
        JSONObject outStderr = new JSONObject();
        outStderr.put((Object)"name", (Object)"stderr");
        outStderr.put((Object)"max", (Object)0x2000000);
        outFiles.add((Object)new JSONObject());
        outFiles.add((Object)new JSONObject());
        outFiles.add((Object)outStderr);
        String outTmp = outFiles.toString().replace("{}", "null");
        pipeOutputCmd.put((Object)"files", (Object)JSONArray.parseArray((String)outTmp, (JSONReader.Feature[])new JSONReader.Feature[0]));
        pipeOutputCmd.put((Object)"cpuLimit", (Object)(userMaxTime * 1000L * 1000L * 2L));
        pipeOutputCmd.put((Object)"clockLimit", (Object)(userMaxTime * 1000L * 1000L * 3L * 2L));
        pipeOutputCmd.put((Object)"memoryLimit", (Object)((userMaxMemory + 100L) * 1024L * 1024L * 2L));
        pipeOutputCmd.put((Object)"procLimit", (Object)128);
        pipeOutputCmd.put((Object)"stackLimit", (Object)0x8000000L);
        JSONObject spjExeFile = new JSONObject();
        spjExeFile.put((Object)"src", (Object)interactExeSrc);
        JSONObject stdInputFileSrc = new JSONObject();
        stdInputFileSrc.put((Object)"src", (Object)testCaseInputPath);
        JSONObject stdOutFileSrc = new JSONObject();
        stdOutFileSrc.put((Object)"src", (Object)testCaseOutputFilePath);
        JSONObject interactiveCopyIn = new JSONObject();
        interactiveCopyIn.put((Object)interactExeName, (Object)spjExeFile);
        interactiveCopyIn.put((Object)testCaseInputFileName, (Object)stdInputFileSrc);
        interactiveCopyIn.put((Object)testCaseOutputFileName, (Object)stdOutFileSrc);
        pipeOutputCmd.put((Object)"copyIn", (Object)interactiveCopyIn);
        pipeOutputCmd.put((Object)"copyOut", (Object)new JSONArray(new Object[]{userOutputFileName}));
        JSONArray cmdList = new JSONArray();
        cmdList.add((Object)pipeInputCmd);
        cmdList.add((Object)pipeOutputCmd);
        JSONObject param = new JSONObject();
        param.put((Object)"cmd", (Object)cmdList);
        JSONArray pipeMapping = new JSONArray();
        JSONObject user = new JSONObject();
        JSONObject userIn = new JSONObject();
        userIn.put((Object)"index", (Object)0);
        userIn.put((Object)"fd", (Object)1);
        JSONObject userOut = new JSONObject();
        userOut.put((Object)"index", (Object)1);
        userOut.put((Object)"fd", (Object)0);
        user.put((Object)"in", (Object)userIn);
        user.put((Object)"out", (Object)userOut);
        user.put((Object)"max", (Object)0x2000000);
        user.put((Object)"proxy", (Object)true);
        user.put((Object)"name", (Object)"stdout");
        JSONObject judge = new JSONObject();
        JSONObject judgeIn = new JSONObject();
        judgeIn.put((Object)"index", (Object)1);
        judgeIn.put((Object)"fd", (Object)1);
        JSONObject judgeOut = new JSONObject();
        judgeOut.put((Object)"index", (Object)0);
        judgeOut.put((Object)"fd", (Object)0);
        judge.put((Object)"in", (Object)judgeIn);
        judge.put((Object)"out", (Object)judgeOut);
        judge.put((Object)"max", (Object)0x2000000);
        judge.put((Object)"proxy", (Object)true);
        judge.put((Object)"name", (Object)"stdout");
        pipeMapping.add((Object)user);
        pipeMapping.add((Object)judge);
        param.put((Object)"pipeMapping", (Object)pipeMapping);
        JSONArray result = instance.run("/run", param);
        JSONObject userRes = (JSONObject)result.get(0);
        JSONObject interactiveRes = (JSONObject)result.get(1);
        userRes.put((Object)"originalStatus", (Object)userRes.getString("status"));
        userRes.put((Object)"status", RESULT_MAP_STATUS.get(userRes.getString("status")));
        interactiveRes.put((Object)"originalStatus", (Object)interactiveRes.getString("status"));
        interactiveRes.put((Object)"status", RESULT_MAP_STATUS.get(interactiveRes.getString("status")));
        return result;
    }

    public static String fetchFileId(JSONArray jsonArray, String fileName) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        JSONObject fileIds = (JSONObject)((JSONObject)jsonArray.get(0)).get("fileIds");
        if (fileIds == null || fileIds.isEmpty()) {
            return null;
        }
        return fileIds.getString(fileName);
    }

    public static String fetchFileContent(JSONArray jsonArray, String fileName) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        JSONObject files = (JSONObject)((JSONObject)jsonArray.get(0)).get("files");
        if (files == null || files.isEmpty()) {
            return null;
        }
        return files.getString(fileName);
    }

    public static Map<String, Object> fetchAnsStatus(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        JSONObject ansJson = (JSONObject)jsonArray.get(0);
        if (ansJson == null || ansJson.isEmpty()) {
            return null;
        }
        HashMap<String, Object> ansStatus = new HashMap<String, Object>();
        ansStatus.put("status", ansJson.get("status"));
        ansStatus.put("exitStatus", ansJson.get("exitStatus"));
        ansStatus.put("time", ansJson.get("time"));
        ansStatus.put("memory", ansJson.get("memory"));
        ansStatus.put("runTime", ansJson.get("runTime"));
        ansStatus.put("originalStatus", ansJson.get("originalStatus"));
        return ansStatus;
    }

    static {
        instance = new SandboxRun();
        SANDBOX_BASE_URL = "http://192.168.134.250:30275";
        COMPILE_CMD = "/usr/bin/g++";
        RESULT_MAP_STATUS = new HashMap();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(20000);
        requestFactory.setReadTimeout(180000);
        restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        RESULT_MAP_STATUS.put("Time Limit Exceeded", Constants.Judge.STATUS_TIME_LIMIT_EXCEEDED.getStatus());
        RESULT_MAP_STATUS.put("Memory Limit Exceeded", Constants.Judge.STATUS_MEMORY_LIMIT_EXCEEDED.getStatus());
        RESULT_MAP_STATUS.put("Output Limit Exceeded", Constants.Judge.STATUS_RUNTIME_ERROR.getStatus());
        RESULT_MAP_STATUS.put("Accepted", Constants.Judge.STATUS_ACCEPTED.getStatus());
        RESULT_MAP_STATUS.put("Nonzero Exit Status", Constants.Judge.STATUS_RUNTIME_ERROR.getStatus());
        RESULT_MAP_STATUS.put("Internal Error", Constants.Judge.STATUS_SYSTEM_ERROR.getStatus());
        RESULT_MAP_STATUS.put("File Error", Constants.Judge.STATUS_SYSTEM_ERROR.getStatus());
        RESULT_MAP_STATUS.put("Signalled", Constants.Judge.STATUS_RUNTIME_ERROR.getStatus());
        signals = Arrays.asList("", "Hangup", "Interrupt", "Quit", "Illegal instruction", "Trace/breakpoint trap", "Aborted", "Bus error", "Floating point exception", "Killed", "User defined signal 1", "Segmentation fault", "User defined signal 2", "Broken pipe", "Alarm clock", "Terminated", "Stack fault", "Child exited", "Continued", "Stopped (signal)", "Stopped", "Stopped (tty input)", "Stopped (tty output)", "Urgent I/O condition", "CPU time limit exceeded", "File size limit exceeded", "Virtual timer expired", "Profiling timer expired", "Window changed", "I/O possible", "Power failure", "Bad system call");
        COMPILE_FILES = new JSONArray();
        JSONObject content = new JSONObject();
        content.put((Object)"content", (Object)"");
        JSONObject stdout = new JSONObject();
        stdout.put((Object)"name", (Object)"stdout");
        stdout.put((Object)"max", (Object)0x2000000);
        JSONObject stderr = new JSONObject();
        stderr.put((Object)"name", (Object)"stderr");
        stderr.put((Object)"max", (Object)0x2000000);
        COMPILE_FILES.add((Object)content);
        COMPILE_FILES.add((Object)stdout);
        COMPILE_FILES.add((Object)stderr);
    }
}

