/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.CaseTestUnit;
import com.codefans.training.module.CoursePlan;
import com.codefans.training.module.CourseWare;
import com.codefans.training.repository.CaseInfoDao;
import com.codefans.training.repository.CoursePlanDao;
import com.codefans.training.repository.CourseWareDao;
import com.codefans.training.service.CourseAssignManager;
import com.codefans.training.utils.OsFileStoreUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CourseAssignManagerImpl
implements CourseAssignManager {
    private static final Integer MAX_COURSE_SERIAL = 10000000;
    private static final long maxTestLengthInString = 2048L;
    @Autowired
    protected CoursePlanDao coursePlanDao;
    @Autowired
    protected CourseWareDao courseWareDao;
    @Autowired
    protected CaseInfoDao caseInfoDao;

    public List<CoursePlan> listCoursePlans(String planType, boolean isPublished) {
        if (StringUtils.equalsAny((CharSequence)planType, (CharSequence[])new CharSequence[]{"PRO", "EXT"})) {
            if (isPublished) {
                return this.coursePlanDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"planType", planType, "planStatus", "P"}));
            }
            return this.coursePlanDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"planType", planType}));
        }
        if (isPublished) {
            return this.coursePlanDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"planStatus", "P"}));
        }
        return this.coursePlanDao.listObjects();
    }

    public List<CourseWare> listPlanCourses(String planId) {
        return this.courseWareDao.listPlanCourses(planId);
    }

    public List<CaseInfo> listCourseCases(String courseId) {
        return this.caseInfoDao.listCourseCases(courseId, true);
    }

    public int countCourseCases(String courseId) {
        return this.caseInfoDao.countCourseCases(courseId);
    }

    public CoursePlan getCoursePlan(String planId) {
        return (CoursePlan)this.coursePlanDao.getObjectById((Object)planId);
    }

    public void createCoursePlan(CoursePlan coursePlan) {
        coursePlan.setPlanStatus("N");
        this.coursePlanDao.saveNewObject((Serializable)coursePlan);
    }

    public void updateCoursePlan(CoursePlan coursePlan) {
        coursePlan.setPlanStatus(null);
        this.coursePlanDao.updateObject((Serializable)coursePlan);
    }

    public void changePlanStatus(String planId, String status) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.coursePlanDao, (String)"update COURSE_PLAN set PLAN_STATUS=? where PLAN_ID=?", (Object[])new Object[]{status, planId});
    }

    public String addCourse(CourseWare courseWare) {
        if (StringUtils.isBlank((CharSequence)courseWare.getPlanId())) {
            throw new ObjectException(611, "\u8bfe\u7a0b\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.courseWareDao.isExistSerial(courseWare.getPlanId(), courseWare.getCourseSerial())) {
            this.courseWareDao.moveCourseSerial(courseWare.getPlanId(), courseWare.getCourseSerial(), MAX_COURSE_SERIAL);
        }
        courseWare.setCourseStatus("N");
        this.courseWareDao.saveNewObject((Serializable)courseWare);
        return courseWare.getCourseId();
    }

    public void moveCourse(String planId, Integer fromSerial, Integer toSerial) {
        if (fromSerial.equals(toSerial)) {
            return;
        }
        CourseWare courseWare = this.courseWareDao.getCourseBySerial(planId, fromSerial);
        this.courseWareDao.moveCourseSerial(planId, fromSerial, toSerial);
        this.courseWareDao.updateCourseSerial(courseWare.getCourseId(), toSerial);
    }

    public void changeCourseStatus(String courseId, String status) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.courseWareDao, (String)"update COURSE_WARE set COURSE_STATUS=? where COURSE_ID=?", (Object[])new Object[]{status, courseId});
    }

    public void updateCourse(CourseWare courseWare) {
        courseWare.setCourseStatus(null);
        this.courseWareDao.updateObject((Serializable)courseWare);
    }

    public void deleteCourse(String courseId) {
        this.courseWareDao.deleteObjectById((Object)courseId);
        List caseInfos = this.caseInfoDao.listCourseCases(courseId, true);
        for (CaseInfo caseInfo : caseInfos) {
            this.deleteCase(caseInfo.getCaseId());
        }
    }

    public CourseWare getCourseWare(String courseId) {
        return (CourseWare)this.courseWareDao.getObjectById((Object)courseId);
    }

    public String addCase(CaseInfo caseInfo) {
        if (StringUtils.isBlank((CharSequence)caseInfo.getCourseId())) {
            throw new ObjectException(611, "\u9898\u76ee\u5fc5\u987b\u5c5e\u4e8e\u4e00\u4e2a\u8bfe\u7a0b\uff01");
        }
        CourseWare courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)caseInfo.getCourseId());
        if (courseWare == null) {
            throw new ObjectException(611, "\u9898\u76ee\u5fc5\u987b\u5c5e\u4e8e\u4e00\u4e2a\u8bfe\u7a0b\uff01");
        }
        caseInfo.setPlanId(courseWare.getPlanId());
        this.caseInfoDao.saveNewObject((Serializable)caseInfo);
        if ("S".equals(caseInfo.getCaseCatalog())) {
            this.caseInfoDao.updateCompoundCaseScore(caseInfo.getPreCaseId());
        }
        this.courseWareDao.updateCourseTotalScore(caseInfo.getCourseId());
        return caseInfo.getCaseId();
    }

    public List<CaseInfo> pageQueryCases(Map<String, Object> filters, PageDesc pageDesc) {
        return this.caseInfoDao.listObjectsByProperties(filters, pageDesc);
    }

    public CaseInfo getCaseInfo(String caseId) {
        return (CaseInfo)this.caseInfoDao.getObjectById((Object)caseId);
    }

    public JSONObject fetchCaseInfo(String caseId, boolean removeAnswer) {
        JSONArray jsonArray;
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)caseId);
        if (caseInfo == null) {
            return null;
        }
        JSONObject json = JSONObject.from((Object)caseInfo);
        if ("C".equals(caseInfo.getCaseType()) && (jsonArray = this.caseInfoDao.listSubCases(caseId, removeAnswer)) != null) {
            json.put((Object)"subCases", (Object)jsonArray);
        }
        if (removeAnswer) {
            json.remove((Object)"standardAnswer");
        }
        return json;
    }

    public void updateCase(CaseInfo caseInfo) {
        this.caseInfoDao.updateObject((Serializable)caseInfo);
        if ("S".equals(caseInfo.getCaseCatalog())) {
            this.caseInfoDao.updateCompoundCaseScore(caseInfo.getPreCaseId());
        }
        this.courseWareDao.updateCourseTotalScore(caseInfo.getCourseId());
    }

    public void moveCaseBetweenCourse(CaseInfo caseInfo) {
        CaseInfo dbCaseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)caseInfo.getCaseId());
        if ("S".equals(caseInfo.getCaseCatalog())) {
            throw new ObjectException("\u5b50\u9898\u76ee\u4e0d\u80fd\u5728\u8bfe\u4ef6\u4e4b\u95f4\u8fc1\u79fb\uff0c\u5fc5\u987b\u548c\u6bcd\u9898\u4e00\u8d77\u8fc1\u79fb\u3002");
        }
        if (StringUtils.equals((CharSequence)dbCaseInfo.getCourseId(), (CharSequence)caseInfo.getCourseId())) {
            return;
        }
        this.caseInfoDao.updateObject((Collection)CollectionsOpt.createList((Object[])new String[]{"courseId"}), (Serializable)caseInfo);
        if ("C".equals(caseInfo.getCaseType())) {
            this.caseInfoDao.moveSubCaseCourse(caseInfo.getCaseId(), caseInfo.getCourseId());
        }
        this.courseWareDao.updateCourseTotalScore(dbCaseInfo.getCourseId());
        this.courseWareDao.updateCourseTotalScore(caseInfo.getCourseId());
    }

    public void moveCase(String courseId, Integer fromSerial, Integer toSerial) {
        if (fromSerial.equals(toSerial)) {
            return;
        }
        CaseInfo caseInfo = this.caseInfoDao.getCaseBySerial(courseId, fromSerial);
        if ("S".equals(caseInfo.getCaseCatalog())) {
            this.caseInfoDao.moveSubCaseSerial(caseInfo.getPreCaseId(), fromSerial, toSerial);
        } else {
            this.caseInfoDao.moveCaseSerial(courseId, fromSerial, toSerial);
        }
        this.caseInfoDao.updateCaseSerial(caseInfo.getCaseId(), toSerial);
    }

    public void deleteCase(String caseId) {
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)caseId);
        if (caseInfo == null) {
            return;
        }
        this.caseInfoDao.deleteObjectById((Object)caseId);
        if ("S".equals(caseInfo.getCaseCatalog())) {
            this.caseInfoDao.updateCompoundCaseScore(caseInfo.getPreCaseId());
        }
        this.courseWareDao.updateCourseTotalScore(caseInfo.getCourseId());
        String runtimeDir = OsFileStoreUtils.getRuntimePath((String)caseId);
        FileSystemOpt.deleteDirect((String)runtimeDir);
    }

    public void updateTestCase(CaseTestUnit testUnit) {
        try {
            CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)testUnit.getCaseId());
            if (caseInfo == null) {
                throw new ObjectException(611, "\u9898\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            }
            String runtimeDir = OsFileStoreUtils.getRuntimePath((String)testUnit.getCaseId());
            if (testUnit.isInputInFile()) {
                FileSystemOpt.fileCopy((String)OsFileStoreUtils.mapFileAbsolutePath((String)testUnit.getTestInputFileId()), (String)(runtimeDir + File.separatorChar + "input" + testUnit.getTestSerial() + ".txt"));
            } else {
                FileIOOpt.writeStringToFile((String)testUnit.getTestInput(), (String)(runtimeDir + File.separatorChar + "input" + testUnit.getTestSerial() + ".txt"));
            }
            if (testUnit.isOutputInFile()) {
                FileSystemOpt.fileCopy((String)OsFileStoreUtils.mapFileAbsolutePath((String)testUnit.getTestOutputFileId()), (String)(runtimeDir + File.separatorChar + "output" + testUnit.getTestSerial() + ".txt"));
            } else {
                FileIOOpt.writeStringToFile((String)testUnit.getTestOutput(), (String)(runtimeDir + File.separatorChar + "output" + testUnit.getTestSerial() + ".txt"));
            }
            if (caseInfo.getTestSum() <= testUnit.getTestSerial()) {
                this.caseInfoDao.updateCaseTestSum(caseInfo.getCaseId(), Integer.valueOf(testUnit.getTestSerial() + 1));
            }
        }
        catch (IOException e) {
            throw new ObjectException(800, e.getMessage(), (Throwable)e);
        }
    }

    public CaseTestUnit getTestCase(String caseId, Integer testSerial) {
        try {
            CaseTestUnit testUnit = new CaseTestUnit(caseId, testSerial);
            String runtimeDir = OsFileStoreUtils.getRuntimePath((String)testUnit.getCaseId());
            String inputPath = runtimeDir + File.separatorChar + "input" + testUnit.getTestSerial() + ".txt";
            String outputPath = runtimeDir + File.separatorChar + "output" + testUnit.getTestSerial() + ".txt";
            long inputLen = FileSystemOpt.fetchFileSize((String)inputPath);
            if (inputLen > 2048L) {
                testUnit.setTestInput(OsFileStoreUtils.readStringFromFile((String)inputPath, (long)2048L));
                testUnit.setInputInFile(true);
            } else {
                testUnit.setInputInFile(false);
                if (inputLen > 0L) {
                    testUnit.setTestInput(FileIOOpt.readStringFromFile((String)inputPath));
                }
            }
            long outputLen = FileSystemOpt.fetchFileSize((String)outputPath);
            if (outputLen > 2048L) {
                testUnit.setTestOutput(OsFileStoreUtils.readStringFromFile((String)outputPath, (long)2048L));
                testUnit.setOutputInFile(true);
            } else {
                testUnit.setOutputInFile(false);
                if (outputLen > 0L) {
                    testUnit.setTestOutput(FileIOOpt.readStringFromFile((String)outputPath));
                }
            }
            return testUnit;
        }
        catch (IOException e) {
            throw new ObjectException(800, e.getMessage(), (Throwable)e);
        }
    }

    private void renameTestCase(String caseId, Integer fromSerial, Integer toSerial) {
        String runtimeDir = OsFileStoreUtils.getRuntimePath((String)caseId);
        new File(runtimeDir + File.separatorChar + "input" + fromSerial + ".txt").renameTo(new File(runtimeDir + File.separatorChar + "input" + toSerial + ".txt"));
        new File(runtimeDir + File.separatorChar + "output" + fromSerial + ".txt").renameTo(new File(runtimeDir + File.separatorChar + "output" + toSerial + ".txt"));
    }

    public void deleteTestCase(String caseId, Integer testSerial) {
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)caseId);
        if (caseInfo == null) {
            throw new ObjectException(611, "\u9898\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String runtimeDir = OsFileStoreUtils.getRuntimePath((String)caseId);
        FileSystemOpt.deleteFile((String)(runtimeDir + File.separatorChar + "input" + testSerial + ".txt"));
        FileSystemOpt.deleteFile((String)(runtimeDir + File.separatorChar + "output" + testSerial + ".txt"));
        for (int i = testSerial + 1; i < caseInfo.getTestSum(); ++i) {
            this.renameTestCase(caseId, Integer.valueOf(i), Integer.valueOf(i - 1));
        }
        this.caseInfoDao.updateCaseTestSum(caseInfo.getCaseId(), Integer.valueOf(caseInfo.getTestSum() - 1));
    }

    public void moveTestCase(String caseId, Integer fromSerial, Integer toSerial) {
        if (fromSerial.equals(toSerial)) {
            return;
        }
        this.renameTestCase(caseId, fromSerial, MAX_COURSE_SERIAL);
        if (fromSerial < toSerial) {
            for (int i = fromSerial + 1; i <= toSerial; ++i) {
                this.renameTestCase(caseId, Integer.valueOf(i), Integer.valueOf(i - 1));
            }
        } else {
            for (int i = fromSerial - 1; i >= toSerial; --i) {
                this.renameTestCase(caseId, Integer.valueOf(i), Integer.valueOf(i + 1));
            }
        }
        this.renameTestCase(caseId, MAX_COURSE_SERIAL, toSerial);
    }
}

