/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.service.impl;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import com.codefans.training.config.ApplicationProperties;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.ProgramDto;
import com.codefans.training.module.UserProgram;
import com.codefans.training.sandbox.SandboxRun;
import com.codefans.training.service.CppRunttimeService;
import com.codefans.training.service.PracticeManager;
import com.codefans.training.utils.ComparisonResult;
import com.codefans.training.utils.CppRuntime;
import com.codefans.training.utils.OsFileStoreUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CppRunttimeServiceImpl
implements CppRunttimeService {
    @Autowired
    protected PracticeManager practiceManager;
    @Autowired
    private ApplicationProperties applicationProperties;

    public ResponseData runProgramLocal(ProgramDto programDto) throws IOException {
        String runDir = OsFileStoreUtils.getTempFileDirectory((String)programDto.getProgramId());
        FileSystemOpt.createDirect((String)runDir);
        String codePath = runDir + File.separatorChar + "testCode.cpp";
        String exePath = runDir + File.separatorChar + "testCode." + this.applicationProperties.getApp().getExeExtName();
        FileIOOpt.writeStringToFile((String)programDto.getProgramCode(), (String)codePath);
        ResponseData responseData = CppRuntime.buildExe((String)this.applicationProperties.getApp().getBuilder(), (String)codePath, (String)exePath);
        if (responseData.getCode() != 0) {
            FileSystemOpt.deleteDirect((String)runDir);
            this.practiceManager.saveProgramRunData(programDto, responseData.getMessage());
            return responseData;
        }
        String inputPath = runDir + File.separatorChar + "input.txt";
        String outputPath = runDir + File.separatorChar + "output.txt";
        if (StringUtils.isBlank((CharSequence)programDto.getInputData())) {
            programDto.setInputData("0");
        }
        FileIOOpt.writeStringToFile((String)programDto.getInputData(), (String)inputPath);
        ResponseMapData exeResponseData = CppRuntime.runExe((String)exePath, (String)inputPath, (String)outputPath, (long)5000L);
        String outputString = exeResponseData.getMessage();
        if (exeResponseData.getCode() == 0) {
            outputString = FileIOOpt.readStringFromFile((String)outputPath);
            exeResponseData.addResponseData("output", (Object)outputString);
        }
        FileSystemOpt.deleteDirect((String)runDir);
        this.practiceManager.saveProgramRunData(programDto, outputString);
        return exeResponseData;
    }

    public ResponseData runProgramRemote(ProgramDto programDto) {
        String exeFileName = programDto.getProgramId() + ".o";
        ResponseMapData responseData = CppRuntime.buildExeRemote((String)programDto.getProgramCode(), (String)exeFileName);
        if (responseData.getCode() != 0) {
            this.practiceManager.saveProgramRunData(programDto, responseData.getMessage());
            return responseData;
        }
        String exeFileId = StringBaseOpt.castObjectToString((Object)responseData.getResponseData("exeFileId"));
        if (StringUtils.isBlank((CharSequence)programDto.getInputData())) {
            programDto.setInputData("0");
        }
        ResponseMapData runResponseData = CppRuntime.runExeRemote((String)exeFileId, (String)exeFileName, (String)programDto.getInputData(), (long)200L, (long)5000L);
        SandboxRun.deleteFile((String)exeFileId);
        String outputString = StringBaseOpt.castObjectToString((Object)runResponseData.getResponseData("output"));
        this.practiceManager.saveProgramRunData(programDto, outputString);
        return runResponseData;
    }

    public ResponseData submitProgramLocal(UserProgram userProgram) throws IOException {
        String caseDir = OsFileStoreUtils.getRuntimePath((String)userProgram.getCaseId());
        String runDir = caseDir + File.separatorChar + userProgram.getProgramId();
        String codePath = runDir + File.separatorChar + "testCode.cpp";
        String exePath = runDir + File.separatorChar + "testCode." + this.applicationProperties.getApp().getExeExtName();
        FileSystemOpt.createDirect((String)runDir);
        FileIOOpt.writeStringToFile((String)userProgram.getProgramCode(), (String)codePath);
        ResponseData responseData = CppRuntime.buildExe((String)this.applicationProperties.getApp().getBuilder(), (String)codePath, (String)exePath);
        if (responseData.getCode() != 0) {
            FileSystemOpt.deleteDirect((String)runDir);
            ProgramDto programDto = new ProgramDto();
            programDto.setUserCode(userProgram.getUserCode());
            programDto.setProgramId(userProgram.getProgramId());
            programDto.setProgramCode(userProgram.getProgramCode());
            this.practiceManager.saveProgramRunData(programDto, responseData.getMessage());
            return responseData;
        }
        CaseInfo caseInfo = this.practiceManager.getCaseInfo(userProgram.getCaseId());
        int success = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < caseInfo.getTestSum(); ++i) {
            String inputPath = caseDir + File.separatorChar + "input" + i + ".txt";
            String outputPath = runDir + File.separatorChar + "output" + i + ".txt";
            String checkPath = caseDir + File.separatorChar + "output" + i + ".txt";
            ResponseMapData exeResponseData = CppRuntime.runExe((String)exePath, (String)inputPath, (String)outputPath, (long)caseInfo.getTimeLimit());
            stringBuilder.append("\u6d4b\u8bd5\u7528\u4f8b ").append(i + 1);
            if (exeResponseData.getCode() == 0) {
                if (ComparisonResult.checkCaseResult((CaseInfo)caseInfo, (String)inputPath, (String)outputPath, (String)checkPath)) {
                    stringBuilder.append(" \u901a\u8fc7\uff0c\u8fd0\u884c\u65f6\u95f4\uff1a");
                    ++success;
                } else {
                    stringBuilder.append(" \u7ed3\u679c\u9519\u8bef\uff0c\u8fd0\u884c\u65f6\u95f4\uff1a");
                }
                stringBuilder.append(exeResponseData.getResponseData("runTime")).append("MS");
            } else {
                stringBuilder.append(" \u8fd0\u884c\u5931\u8d25\uff0c").append(exeResponseData.getMessage());
            }
            stringBuilder.append("\r\n");
        }
        userProgram.setTestCaseSum(caseInfo.getTestSum());
        userProgram.setPassCaseSum(Integer.valueOf(success));
        userProgram.setRunInformation(stringBuilder.toString());
        FileSystemOpt.deleteDirect((String)runDir);
        return this.practiceManager.submitCaseProgram(userProgram);
    }

    public ResponseData submitProgramRemote(UserProgram userProgram) throws IOException {
        String exeFileName = userProgram.getProgramId() + ".o";
        ResponseMapData responseData = CppRuntime.buildExeRemote((String)userProgram.getProgramCode(), (String)exeFileName);
        if (responseData.getCode() != 0) {
            ProgramDto programDto = new ProgramDto();
            programDto.setUserCode(userProgram.getUserCode());
            programDto.setProgramId(userProgram.getProgramId());
            programDto.setProgramCode(userProgram.getProgramCode());
            this.practiceManager.saveProgramRunData(programDto, responseData.getMessage());
            return responseData;
        }
        String exeFileId = StringBaseOpt.castObjectToString((Object)responseData.getResponseData("exeFileId"));
        String caseDir = OsFileStoreUtils.getRuntimePath((String)userProgram.getCaseId());
        String runDir = OsFileStoreUtils.getTempFileDirectory((String)userProgram.getProgramId());
        FileSystemOpt.createDirect((String)runDir);
        CaseInfo caseInfo = this.practiceManager.getCaseInfo(userProgram.getCaseId());
        int success = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < caseInfo.getTestSum(); ++i) {
            String inputPath = caseDir + File.separatorChar + "input" + i + ".txt";
            String outputPath = runDir + File.separatorChar + "output" + i + ".txt";
            String checkPath = caseDir + File.separatorChar + "output" + i + ".txt";
            String inputData = FileIOOpt.readStringFromFile((String)inputPath);
            ResponseMapData runResponseData = CppRuntime.runExeRemote((String)exeFileId, (String)exeFileName, (String)inputData, (long)caseInfo.getSpaceLimit(), (long)caseInfo.getTimeLimit());
            stringBuilder.append("\u6d4b\u8bd5\u7528\u4f8b ").append(i + 1);
            if (runResponseData.getCode() == 0) {
                FileIOOpt.writeStringToFile((String)StringBaseOpt.castObjectToString((Object)runResponseData.getResponseData("output")), (String)outputPath);
                if (ComparisonResult.checkCaseResult((CaseInfo)caseInfo, (String)inputPath, (String)outputPath, (String)checkPath)) {
                    stringBuilder.append(" \u901a\u8fc7\uff0c\u8fd0\u884c\u65f6\u95f4\uff1a");
                    ++success;
                } else {
                    stringBuilder.append(" \u7ed3\u679c\u9519\u8bef\uff0c\u8fd0\u884c\u65f6\u95f4\uff1a");
                }
                stringBuilder.append(runResponseData.getResponseData("runTime")).append("MS");
            } else {
                stringBuilder.append(" \u8fd0\u884c\u5931\u8d25\uff0c").append(runResponseData.getMessage());
            }
            stringBuilder.append("\r\n");
        }
        userProgram.setTestCaseSum(caseInfo.getTestSum());
        userProgram.setPassCaseSum(Integer.valueOf(success));
        userProgram.setRunInformation(stringBuilder.toString());
        SandboxRun.deleteFile((String)exeFileId);
        FileSystemOpt.deleteDirect((String)runDir);
        return this.practiceManager.submitCaseProgram(userProgram);
    }
}

