/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.module.CaseInfo;
import com.codefans.training.module.CoursePlan;
import com.codefans.training.module.CourseWare;
import com.codefans.training.module.ProgramDto;
import com.codefans.training.module.UserCase;
import com.codefans.training.module.UserCourse;
import com.codefans.training.module.UserPlan;
import com.codefans.training.module.UserProgram;
import com.codefans.training.repository.CaseInfoDao;
import com.codefans.training.repository.CoursePlanDao;
import com.codefans.training.repository.CourseWareDao;
import com.codefans.training.repository.UserCaseDao;
import com.codefans.training.repository.UserCourseDao;
import com.codefans.training.repository.UserPlanDao;
import com.codefans.training.repository.UserProgramDao;
import com.codefans.training.service.PracticeManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PracticeManagerImpl
implements PracticeManager {
    @Autowired
    protected CoursePlanDao coursePlanDao;
    @Autowired
    protected CourseWareDao courseWareDao;
    @Autowired
    protected CaseInfoDao caseInfoDao;
    @Autowired
    protected UserPlanDao userPlanDao;
    @Autowired
    protected UserCourseDao userCourseDao;
    @Autowired
    protected UserCaseDao userCaseDao;
    @Autowired
    protected UserProgramDao userProgramDao;

    public JSONArray listUserPlans(String userCode, String planType) {
        String sqlSen = "select a.PLAN_ID, a.PLAN_NAME, a.logo_image, a.PLAN_STATUS, a.PLAN_TYPE, a.PLAN_LEVEL, b.USER_CODE, b.START_TIME, b.USER_PLAN_STATUS, b.COMPLETED_COURSES, a.COURSE_SUM, b.PLAN_SCORE, b.LAST_UPDATE_TIME  from COURSE_PLAN a left join (select * from USER_PLAN where USER_CODE= ? ) b  on a.PLAN_ID = b.PLAN_ID  where a.PLAN_STATUS='P'";
        if (StringUtils.equalsAny((CharSequence)planType, (CharSequence[])new CharSequence[]{"PRO", "EXT"})) {
            return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.userPlanDao, (String)(sqlSen + " and a.PLAN_TYPE=?"), (Object[])new Object[]{userCode, planType});
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.userPlanDao, (String)sqlSen, (Object[])new Object[]{userCode});
    }

    private void changeCoursePlan(String userCode, CoursePlan coursePlan, String joinType) {
        UserPlan userPlan = this.userPlanDao.getUserPlan(userCode, coursePlan.getPlanId());
        UserPlan currentPlan = this.userPlanDao.getUserCurrentPlan(userCode, coursePlan.getPlanType());
        if (userPlan != null && currentPlan != null && currentPlan.getPlanId().equals(userPlan.getPlanId())) {
            return;
        }
        if (userPlan == null) {
            userPlan = new UserPlan();
            userPlan.setUserCode(userCode);
            userPlan.setPlanId(coursePlan.getPlanId());
            userPlan.setJoinPlanType(joinType);
            userPlan.setUserPlanStatus("A");
            userPlan.setPlanScore(Integer.valueOf(0));
            userPlan.setCompletedCourses(Integer.valueOf(0));
            this.userPlanDao.saveNewObject((Serializable)userPlan);
        } else {
            this.userPlanDao.updateUserPlanStatus(userCode, coursePlan.getPlanId(), "A");
        }
        if (currentPlan != null) {
            this.userPlanDao.updateUserPlanStatus(userCode, currentPlan.getPlanId(), "S");
        }
    }

    public void subscribeCoursePlan(String userCode, String planId) {
        Date lastJoinTime;
        int lestPlanSum;
        CoursePlan coursePlan = (CoursePlan)this.coursePlanDao.getObjectById((Object)planId);
        if (coursePlan == null) {
            throw new ObjectException(611, "\u8bfe\u7a0b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\uff01");
        }
        if ("PRO".equals(coursePlan.getPlanType()) && (lestPlanSum = this.userPlanDao.countUnsubscribePlan(userCode, coursePlan.getPlanType()).intValue()) == 0 && (lastJoinTime = this.userPlanDao.fetchLastChangePlanTime(userCode, coursePlan.getPlanType())) != null && lastJoinTime.after(DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)-30))) {
            throw new ObjectException(611, "\u4e3a\u4e86\u57f9\u517b\u60a8\u7684\u8010\u5fc3\uff0c\u6bcf\u6708\u53ea\u80fd\u66f4\u6362\u8bfe\u7a0b\u4e00\u6b21\uff0c\u60a8\u53ef\u4ee5\u5b8c\u6210\u5f53\u524d\u8ba1\u5212\u7684\u6240\u6709\u8bfe\u7a0b\u81ea\u52a8\u8fdb\u5165\u4e0b\u4e00\u8ba1\u5212\uff01");
        }
        this.changeCoursePlan(userCode, coursePlan, "U");
    }

    public void unsubscribeCoursePlan(String userCode, String planId) {
        CoursePlan coursePlan = (CoursePlan)this.coursePlanDao.getObjectById((Object)planId);
        if (coursePlan == null) {
            throw new ObjectException(611, "\u8bfe\u7a0b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\uff01");
        }
        if ("PRO".equals(coursePlan.getPlanType())) {
            throw new ObjectException(611, "\u4e0d\u53ef\u4ee5\u53d6\u6d88\u4e3b\u5e72\u8bfe\u7a0b\u8ba1\u5212\uff0c\u5982\u679c\u60a8\u89c9\u5f97\u96be\u5ea6\u4e0d\u5408\u9002\u53ef\u4ee5\u8c03\u6574\u5176\u4ed6\u4e3b\u5e72\u8bfe\u7a0b\u8ba1\u5212\uff01");
        }
        this.userPlanDao.updateUserPlanStatus(userCode, planId, "S");
    }

    private UserCourse fetchUserCourse(String userCode, String planId) {
        Integer finishedCourse;
        CourseWare courseWare;
        UserCourse userCourse = this.userCourseDao.fetchUserCourse(userCode, planId);
        if (userCourse == null && (courseWare = this.courseWareDao.fetchNextCourses(planId, finishedCourse = this.userCourseDao.fetchUserCourseSerial(userCode, planId))) != null) {
            userCourse = new UserCourse();
            userCourse.setUserCode(userCode);
            userCourse.setPlanId(planId);
            userCourse.setCourseId(courseWare.getCourseId());
            userCourse.setCompletionStatus("A");
            userCourse.setCourseScore(Integer.valueOf(0));
            Date toDay = DatetimeOpt.currentUtilDate();
            userCourse.setStartTime(toDay);
            if ("Q".equals(courseWare.getCourseType())) {
                userCourse.setDeadlineTime(DatetimeOpt.addMinutes((Date)toDay, (int)courseWare.getEstimatedTime()));
            } else {
                userCourse.setDeadlineTime(DatetimeOpt.addDays((Date)toDay, (int)courseWare.getEstimatedTime()));
            }
            this.userCourseDao.saveNewObject((Serializable)userCourse);
        }
        return userCourse;
    }

    private JSONObject userCourseToJson(UserCourse userCourse) {
        JSONObject object = JSONObject.from((Object)userCourse);
        CourseWare courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)userCourse.getCourseId());
        JSONObject object2 = JSONObject.from((Object)courseWare);
        object2.putAll((Map)object);
        return object2;
    }

    public JSONArray listUserCourses(String userCode) {
        Integer maxLevel;
        CoursePlan nextPlan;
        CoursePlan proPlan = null;
        ArrayList<UserCourse> userCourses = new ArrayList<UserCourse>(8);
        List userPlans = this.coursePlanDao.listUserCurrentPlan(userCode);
        if (userPlans != null && !userPlans.isEmpty()) {
            for (CoursePlan coursePlan : userPlans) {
                if ("PRO".equals(coursePlan.getPlanType())) {
                    proPlan = coursePlan;
                    continue;
                }
                UserCourse userCourse = this.fetchUserCourse(userCode, coursePlan.getPlanId());
                if (userCourse == null) continue;
                userCourses.add(userCourse);
            }
        }
        UserCourse userCourse = null;
        if (proPlan == null) {
            proPlan = this.coursePlanDao.fetchFirstPlan("PRO");
        }
        if (proPlan != null && (userCourse = this.fetchUserCourse(userCode, proPlan.getPlanId())) == null && (nextPlan = this.coursePlanDao.fetchNextLevelPlan("PRO", maxLevel = this.userPlanDao.fetchUserPlanLevel(userCode, "PRO"))) != null) {
            this.changeCoursePlan(userCode, nextPlan, "A");
            userCourse = this.fetchUserCourse(userCode, nextPlan.getPlanId());
        }
        JSONArray jsonArray = new JSONArray();
        if (userCourse != null) {
            jsonArray.add((Object)this.userCourseToJson(userCourse));
        }
        for (UserCourse uc : userCourses) {
            jsonArray.add((Object)this.userCourseToJson(uc));
        }
        return jsonArray;
    }

    public JSONArray listUserCompletedCourses(String userCode, boolean onlySkip, boolean notFullMark, PageDesc pageDesc) {
        String sqlSen = "select b.USER_CODE, b.COURSE_ID, b.PLAN_ID, b.COURSE_SCORE, b.START_TIME, b.LAST_UPDATE_TIME, a.COURSE_TYPE, a.COURSE_TITLE, a.COURSE_DESC, a.COVER_IMAGE, a.TOTAL_SCORE from COURSE_WARE a join USER_COURSE b  on a.COURSE_ID = b.COURSE_ID where b.USER_CODE=? and b.COMPLETION_STATUS " + (onlySkip ? "='S' " : "!='A' ");
        if (notFullMark) {
            sqlSen = sqlSen + " and b.COURSE_SCORE < a.TOTAL_SCORE";
        }
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.userCourseDao, (String)(sqlSen + " order by b.START_TIME desc"), (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    private UserCase filterUserCase(List<UserCase> userCases, String caseId) {
        for (UserCase userCase : userCases) {
            if (!StringUtils.equals((CharSequence)caseId, (CharSequence)userCase.getCaseId())) continue;
            return userCase;
        }
        return null;
    }

    private JSONArray filterSubCase(List<CaseInfo> courseCases, List<UserCase> userCases, String preCaseId) {
        JSONArray subCases = new JSONArray();
        for (CaseInfo caseInfo : courseCases) {
            if (!StringUtils.equals((CharSequence)preCaseId, (CharSequence)caseInfo.getPreCaseId())) continue;
            JSONObject caseJson = JSONObject.from((Object)caseInfo);
            caseJson.remove((Object)"standardAnswer");
            UserCase userCase = this.filterUserCase(userCases, caseInfo.getCaseId());
            if (userCase != null) {
                caseJson.putAll((Map)JSONObject.from((Object)userCase));
            }
            subCases.add((Object)caseInfo);
        }
        return subCases;
    }

    public JSONObject fetchUserCaseInfo(String userCode, String caseId) {
        JSONArray jsonArray;
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)caseId);
        if (caseInfo == null) {
            return null;
        }
        JSONObject json = JSONObject.from((Object)caseInfo);
        List userCases = this.userCaseDao.listUserCaseWithSub(userCode, caseId);
        if ("C".equals(caseInfo.getCaseType()) && (jsonArray = this.caseInfoDao.listSubCases(caseId, true)) != null && !jsonArray.isEmpty()) {
            for (Object object : jsonArray) {
                UserCase userCase;
                String cid;
                if (!(object instanceof JSONObject) || (cid = ((JSONObject)object).getString("caseId")) == null || (userCase = this.filterUserCase(userCases, cid)) == null) continue;
                ((JSONObject)object).putAll((Map)JSONObject.from((Object)userCase));
            }
            json.put((Object)"subCases", (Object)jsonArray);
        }
        json.remove((Object)"standardAnswer");
        UserCase userCase = this.filterUserCase(userCases, caseInfo.getCaseId());
        if (userCase != null) {
            json.putAll((Map)JSONObject.from((Object)userCase));
        }
        return json;
    }

    public JSONObject fetchUserCourseDetail(String userCode, String courseId) {
        CourseWare courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)courseId);
        UserCourse userCourse = this.userCourseDao.getUserCourse(userCode, courseId);
        List courseCases = this.caseInfoDao.listCourseCases(courseId, true);
        List userCases = this.userCaseDao.listUserCourseCase(userCode, courseId);
        JSONObject json = JSONObject.from((Object)courseWare);
        json.putAll((Map)JSONObject.from((Object)userCourse));
        JSONArray caseList = new JSONArray();
        for (CaseInfo caseInfo : courseCases) {
            if ("S".equals(caseInfo.getCaseCatalog())) continue;
            JSONObject caseJson = JSONObject.from((Object)caseInfo);
            UserCase userCase = this.filterUserCase(userCases, caseInfo.getCaseId());
            if (userCase == null) {
                userCase = new UserCase();
                userCase.setUserCode(userCode);
                userCase.setCaseId(caseInfo.getCaseId());
                userCase.setTrainStatus("A");
                userCase.setUserScore(Integer.valueOf(0));
                if (StringUtils.equalsAny((CharSequence)caseInfo.getCaseType(), (CharSequence[])new CharSequence[]{"C", "P"})) {
                    this.userCaseDao.saveNewObject((Serializable)userCase);
                }
            }
            caseJson.putAll((Map)JSONObject.from((Object)userCase));
            if ("C".equals(caseInfo.getCaseType())) {
                caseJson.put((Object)"subCases", (Object)this.filterSubCase(courseCases, userCases, caseInfo.getCaseId()));
            } else if ("P".equals(caseInfo.getCaseType())) {
                ArrayList<UserProgram> programs = this.userProgramDao.listUserCaseProgram(userCode, caseInfo.getCaseId());
                if (programs == null || programs.isEmpty()) {
                    programs = new ArrayList<UserProgram>();
                    UserProgram program = new UserProgram();
                    program.setUserCode(userCode);
                    program.setCourseId(courseId);
                    program.setCaseId(caseInfo.getCaseId());
                    program.setProgramStatus("N");
                    program.setProgramScore(Integer.valueOf(0));
                    program.setProgramName("\u6211\u7684\u4ee3\u7801");
                    program.setProgramStatus("N");
                    program.setPassCaseSum(Integer.valueOf(0));
                    program.setTestCaseSum(caseInfo.getTestSum());
                    this.userProgramDao.saveNewObject((Serializable)program);
                    programs.add(program);
                }
                caseJson.put((Object)"programList", programs);
            }
            caseList.add((Object)caseJson);
        }
        json.put((Object)"caseList", (Object)caseList);
        return json;
    }

    public void completeCourse(String userCode, String courseId) {
        CourseWare courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)courseId);
        UserCourse userCourse = this.userCourseDao.getUserCourse(userCode, courseId);
        if (courseWare == null || userCourse == null) {
            throw new ObjectException(611, "\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u8bfe\u7a0b\uff1a" + courseId + "\uff0c\u63d0\u4ea4\u7684\u6570\u636e\u51fa\u9519\u4e86\uff01");
        }
        Date today = DatetimeOpt.currentUtilDate();
        String completionStatus = "C";
        if (courseWare.getCourseType().equals("T")) {
            if (userCourse.getCourseScore() < courseWare.getByStandard() && userCourse.getDeadlineTime().after(today)) {
                throw new ObjectException(611, "\u60a8\u8fd8\u6ca1\u6709\u5b8c\u6210\u672c\u8bfe\u7a0b\u7684\u5b66\u4e60\uff0c\u8bf7\u7ee7\u7eed\u5b66\u4e60\uff01");
            }
            if (userCourse.getCourseScore() < courseWare.getByStandard()) {
                completionStatus = "S";
            }
        }
        userCourse.setCompletionStatus(completionStatus);
        this.userCourseDao.updateObject(new String[]{"completionStatus"}, (Serializable)userCourse);
    }

    public JSONObject submitCaseAnswer(UserCase userCase) {
        JSONObject retJson = new JSONObject();
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)userCase.getCaseId());
        if (StringUtils.equals((CharSequence)caseInfo.getCaseType(), (CharSequence)"P")) {
            retJson.put((Object)"message", (Object)"\u7f16\u7a0b\u9898\u76ee\uff0c\u8bf7\u8c03\u7528 submitCaseProgram\u65b9\u6cd5\u3002");
            return retJson;
        }
        boolean hasChangeScore = false;
        Date today = DatetimeOpt.currentUtilDate();
        CourseWare courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)caseInfo.getCourseId());
        UserCourse userCourse = this.userCourseDao.getUserCourse(userCase.getUserCode(), caseInfo.getCourseId());
        if ("Q".equals(courseWare.getCourseType()) && userCourse.getDeadlineTime().before(today)) {
            throw new ObjectException(611, "\u6d4b\u8bd5\u65f6\u95f4\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u66f4\u6539\u7b54\u6848\uff0c\u53ea\u80fd\u67e5\u770b\u9898\u76ee\u548c\u8bc4\u6d4b\u7f16\u7a0b\u9898\uff01");
        }
        if (StringUtils.equalsAny((CharSequence)caseInfo.getCaseType(), (CharSequence[])new CharSequence[]{"J", "S", "M", "B"})) {
            if (StringUtils.equals((CharSequence)userCase.getCaseRecord(), (CharSequence)caseInfo.getStandardAnswer())) {
                userCase.setUserScore(caseInfo.getCaseScore());
                userCase.setPassTimes(Integer.valueOf(userCase.getPassTimes() + 1));
            } else {
                userCase.setUserScore(Integer.valueOf(0));
            }
            userCase.setTryTimes(Integer.valueOf(userCase.getTryTimes() + 1));
            hasChangeScore = true;
        } else if (StringUtils.equals((CharSequence)caseInfo.getCaseType(), (CharSequence)"T")) {
            if (userCase.getUserScore() == null) {
                userCase.setUserScore(caseInfo.getCaseScore());
            }
            hasChangeScore = true;
        } else if (StringUtils.equals((CharSequence)caseInfo.getCaseType(), (CharSequence)"R")) {
            userCase.setUserScore(caseInfo.getCaseScore());
            hasChangeScore = true;
        }
        userCase.setTrainStatus("C");
        userCase.setLastUpateTime(today);
        UserCase dbUserCase = this.userCaseDao.getUserCase(userCase.getUserCode(), userCase.getCaseId());
        if (dbUserCase == null) {
            this.userCaseDao.saveNewObject((Serializable)userCase);
        } else if ("C".equals(caseInfo.getCaseType())) {
            this.userCaseDao.updateObject((Collection)CollectionsOpt.createList((Object[])new String[]{"trainStatus", "lastUpateTime"}), (Serializable)userCase);
        } else {
            this.userCaseDao.updateObject((Serializable)userCase);
        }
        if (hasChangeScore) {
            if ("S".equals(caseInfo.getCaseCatalog())) {
                this.userCaseDao.updateCompoundCaseScore(userCase.getUserCode(), caseInfo.getPreCaseId());
            }
            this.userCourseDao.updateCourseScore(userCase.getUserCode(), caseInfo.getCourseId());
        }
        if ("Q".equals(courseWare.getCourseType())) {
            retJson.put((Object)"message", (Object)"\u7b54\u6848\u5df2\u4fdd\u5b58\u3002");
        } else if ("C".equals(caseInfo.getCaseType())) {
            retJson.put((Object)"message", (Object)"\u9898\u76ee\u72b6\u6001\u5df2\u66f4\u65b0\u3002");
        } else {
            retJson.put((Object)"userScore", (Object)userCase.getUserScore());
            if (userCase.getUserScore() == null || userCase.getUserScore() == 0) {
                retJson.put((Object)"message", (Object)"\u7b54\u6848\u9519\u8bef\uff01");
            } else {
                retJson.put((Object)"message", (Object)"\u7b54\u6848\u6b63\u786e\uff01");
            }
            retJson.put((Object)"explicate", (Object)caseInfo.getProgramTemplate());
        }
        return retJson;
    }

    public void addCaseProgram(UserProgram userProgram) {
        int pc = this.userProgramDao.countUserCaseProgram(userProgram.getUserCode(), userProgram.getCaseId());
        if (pc >= 5) {
            throw new ObjectException(611, "\u4e00\u4e2a\u7f16\u7a0b\u9898\u76ee\u6700\u6709\u53ef\u4ee5\u521b\u5efa5\u4e2a\u89e3\u51b3\u65b9\u6848\uff01");
        }
        userProgram.setProgramStatus("N");
        this.userProgramDao.saveNewObject((Serializable)userProgram);
    }

    public void updateProgramName(String programId, String programName) {
        this.userProgramDao.updateProgramName(programId, programName);
    }

    public ResponseData submitCaseProgram(UserProgram userProgram) {
        Date today = DatetimeOpt.currentUtilDate();
        CaseInfo caseInfo = (CaseInfo)this.caseInfoDao.getObjectById((Object)userProgram.getCaseId());
        boolean isPiazzaCase = StringUtils.isBlank((CharSequence)caseInfo.getCourseId()) || "piazza".equals(caseInfo.getCourseId());
        CourseWare courseWare = null;
        if (!isPiazzaCase) {
            courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)caseInfo.getCourseId());
            UserCourse userCourse = this.userCourseDao.getUserCourse(userProgram.getUserCode(), caseInfo.getCourseId());
            if ("Q".equals(courseWare.getCourseType()) && userCourse.getDeadlineTime().before(today)) {
                return ResponseData.makeErrorMessageWithData((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"output", userProgram.getRunInformation()}), (int)0, (String)"\u6d4b\u8bd5\u65f6\u95f4\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u66f4\u6539\u7b54\u6848\uff0c\u4f46\u8ba4\u53ef\u8fd0\u884c\uff01");
            }
        }
        this.userProgramDao.updateObject((Serializable)userProgram);
        String caseStatus = "C";
        int caseScore = 0;
        int hasSoreCases = 0;
        List programs = this.userProgramDao.listUserCaseProgram(userProgram.getUserCode(), userProgram.getCaseId());
        for (UserProgram program : programs) {
            if (program.getPassCaseSum() == null || program.getTestCaseSum() == null || program.getTestCaseSum() <= 0) continue;
            int thisSore = caseInfo.getCaseScore() * program.getPassCaseSum() / program.getTestCaseSum();
            if (caseScore < thisSore) {
                caseScore = thisSore;
            }
            if (thisSore <= 0) continue;
            ++hasSoreCases;
        }
        if (caseScore >= caseInfo.getCaseScore()) {
            caseScore = caseInfo.getCaseScore();
            caseStatus = hasSoreCases > 1 ? "E" : "P";
        }
        this.userCaseDao.updateCaseScore(userProgram.getUserCode(), userProgram.getCaseId(), caseStatus, Integer.valueOf(caseScore), userProgram.getPassCaseSum().equals(userProgram.getTestCaseSum()));
        if (isPiazzaCase) {
            return ResponseData.makeResponseData((Map)CollectionsOpt.createHashMap((Object[])new Object[]{"output", userProgram.getRunInformation()}));
        }
        this.userCourseDao.updateCourseScore(userProgram.getUserCode(), caseInfo.getCourseId());
        if ("Q".equals(courseWare.getCourseType())) {
            return ResponseData.makeResponseData((Map)CollectionsOpt.createHashMap((Object[])new Object[]{"output", "\u7ed3\u679c\u5df2\u7ecf\u6210\u529f\u4fdd\u5b58!"}));
        }
        return ResponseData.makeResponseData((Map)CollectionsOpt.createHashMap((Object[])new Object[]{"output", userProgram.getRunInformation()}));
    }

    public void deleteCaseProgram(String programId) {
        UserProgram userProgram = (UserProgram)this.userProgramDao.getObjectById((Object)programId);
        int pc = this.userProgramDao.countUserCaseProgram(userProgram.getUserCode(), userProgram.getCaseId());
        if (pc <= 1) {
            throw new ObjectException(611, "\u6bcf\u4e2a\u9898\u76ee\u81f3\u5c11\u9700\u8981\u4fdd\u7559\u4e00\u4e2a\u89e3\u51b3\u65b9\u6848\uff01");
        }
        this.userProgramDao.deleteObject((Serializable)userProgram);
    }

    public void saveProgramRunData(ProgramDto programDto, String output) {
        UserProgram userProgram = (UserProgram)this.userProgramDao.getObjectById((Object)programDto.getProgramId());
        if (userProgram == null || !StringUtils.equals((CharSequence)programDto.getUserCode(), (CharSequence)userProgram.getUserCode())) {
            return;
        }
        Date today = DatetimeOpt.currentUtilDate();
        CourseWare courseWare = (CourseWare)this.courseWareDao.getObjectById((Object)userProgram.getCourseId());
        UserCourse userCourse = this.userCourseDao.getUserCourse(userProgram.getUserCode(), userProgram.getCourseId());
        if ("Q".equals(courseWare.getCourseType()) && userCourse.getDeadlineTime().before(today)) {
            return;
        }
        userProgram.setProgramCode(programDto.getProgramCode());
        userProgram.setRunInformation(output);
        userProgram.setLastUpdateTime(today);
        this.userProgramDao.updateObject(new String[]{"programCode", "runInformation", "lastUpdateTime"}, (Serializable)userProgram);
    }

    public CaseInfo getCaseInfo(String caseId) {
        return (CaseInfo)this.caseInfoDao.getObjectById((Object)caseId);
    }
}

