/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.utils;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.file.FileIOOpt;
import com.codefans.training.framework.common.ResponseData;
import com.codefans.training.framework.common.ResponseMapData;
import com.codefans.training.sandbox.SandboxRun;
import com.codefans.training.sandbox.SystemError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class CppRuntime {
    public static final int EXECUTE_SUCCESS = 0;
    public static final int COMPILE_ERROR = 713;
    public static final int EXECUTE_TIME_OUT = 711;
    public static final int EXECUTE_MEMORY_OUT = 712;
    public static final int EXECUTE_EXCEPTION = 704;

    public static ResponseData buildExe(String gccPath, String sourcePah, String outPath) throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{gccPath, sourcePah, "-o", outPath, "-g"});
        String message = FileIOOpt.readStringFromInputStream((InputStream)process.getErrorStream());
        if (StringUtils.isBlank((CharSequence)message)) {
            return ResponseData.makeSuccessResponse();
        }
        return ResponseData.makeErrorMessage((int)713, (String)message);
    }

    public static ResponseMapData runExe(String exePath, String inputPath, String outputPath, long timeLimitInMillis) throws IOException {
        ResponseMapData responseData = new ResponseMapData();
        ProcessBuilder processBuilder = new ProcessBuilder(exePath);
        processBuilder.redirectInput(new File(inputPath)).redirectOutput(new File(outputPath));
        Process process = processBuilder.start();
        long beginRunTimestamp = System.currentTimeMillis();
        Thread thread = new Thread(() -> {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                responseData.setCode(704);
                responseData.setMessage(e.getMessage());
            }
        });
        thread.start();
        boolean isTimeout = false;
        try {
            thread.join(timeLimitInMillis);
        }
        catch (InterruptedException e) {
            responseData.setCode(704);
            responseData.setMessage(e.getMessage());
        }
        if (thread.isAlive()) {
            isTimeout = true;
            process.destroy();
        }
        responseData.addResponseData("runTime", (Object)(System.currentTimeMillis() - beginRunTimestamp));
        if (isTimeout) {
            responseData.setCode(711);
            responseData.setMessage("\u8fd0\u884c\u8d85\u65f6\uff1a" + timeLimitInMillis + "MS");
        } else {
            String message = FileIOOpt.readStringFromInputStream((InputStream)process.getErrorStream());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                responseData.setCode(704);
                responseData.setMessage(message);
            }
        }
        return responseData;
    }

    public static ResponseMapData buildExeRemote(String code, String exeFileName) {
        try {
            JSONArray jsonAns = SandboxRun.compile((Long)20000L, (Long)20000L, (Long)0x6400000L, (Long)0x6400000L, (String)"test.cpp", (String)exeFileName, (String)code);
            JSONObject compileRes = (JSONObject)jsonAns.get(0);
            String status = compileRes.getString("originalStatus");
            ResponseMapData responseData = new ResponseMapData();
            if ("Accepted".equals(status)) {
                String exeFileId = compileRes.getJSONObject("fileIds").getString(exeFileName);
                responseData.addResponseData("exeFileName", (Object)exeFileName);
                responseData.addResponseData("exeFileId", (Object)exeFileId);
            } else {
                responseData.setCode(500);
                responseData.setData(SandboxRun.fetchAnsStatus((JSONArray)jsonAns));
                JSONObject files = compileRes.getJSONObject("files");
                responseData.setMessage("Compile Error\uff1a" + files.getString("stderr"));
                responseData.addResponseData("output", (Object)files.getString("stdout"));
            }
            return responseData;
        }
        catch (SystemError e) {
            return e.toResponseData();
        }
    }

    public static ResponseMapData runExeRemote(String exeFileId, String exeFileName, String input, long spaceLimitInMB, long timeLimitInMillis) {
        try {
            JSONArray jsonAns = SandboxRun.testCase((String)input, (Long)timeLimitInMillis, (Long)(spaceLimitInMB * 1024L * 1024L), (Long)0xA00000L, (Integer)0x6400000, (String)exeFileName, (String)exeFileId);
            Map statusMap = SandboxRun.fetchAnsStatus((JSONArray)jsonAns);
            ResponseMapData responseData = ResponseMapData.makeResponseData((Map)statusMap);
            responseData.addResponseData("output", (Object)SandboxRun.fetchFileContent((JSONArray)jsonAns, (String)"stdout"));
            if (!"Accepted".equals(statusMap.get("originalStatus"))) {
                responseData.setCode(500);
            }
            return responseData;
        }
        catch (SystemError e) {
            return e.toResponseData();
        }
    }
}

