/*
 * Decompiled with CFR 0.152.
 */
package com.codefans.training.utils;

import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class OsFileStoreUtils {
    private static String fileStoreRoot = ".";
    private static String TEMP_FILE_DIRECTORY = ".";
    private static String runtimePath = ".";
    private static Logger logger = LoggerFactory.getLogger(OsFileStoreUtils.class);

    public static synchronized void setFileStoreRoot(String appHome, boolean useSystemTempDir) {
        if (appHome.endsWith("/") || appHome.endsWith("\\")) {
            fileStoreRoot = appHome + "upload";
            runtimePath = appHome + "runtime";
            TEMP_FILE_DIRECTORY = appHome + "temp";
        } else {
            fileStoreRoot = appHome + File.separatorChar + "upload";
            runtimePath = appHome + File.separatorChar + "runtime";
            TEMP_FILE_DIRECTORY = appHome + File.separatorChar + "temp";
        }
        if (useSystemTempDir) {
            TEMP_FILE_DIRECTORY = System.getProperty("java.io.tmpdir");
        }
        FileSystemOpt.createDirect((String)fileStoreRoot);
        FileSystemOpt.createDirect((String)TEMP_FILE_DIRECTORY);
        FileSystemOpt.createDirect((String)runtimePath);
    }

    public static String getTempFilePath(String fileMd5) {
        return TEMP_FILE_DIRECTORY + File.separatorChar + fileMd5 + ".tmp";
    }

    public static String getTempFileDirectory(String directory) {
        return TEMP_FILE_DIRECTORY + File.separatorChar + directory;
    }

    public static String getRandomTempFilePath() {
        return TEMP_FILE_DIRECTORY + File.separatorChar + UuidOpt.getUuidAsString32() + ".tmp";
    }

    public static String getRuntimePath(String caseId) {
        String pathname = runtimePath + File.separatorChar + caseId.charAt(0) + File.separatorChar + caseId.charAt(1) + File.separatorChar + caseId;
        FileSystemOpt.createDirect((String)pathname);
        return pathname;
    }

    public static long checkFileSize(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            return 0L;
        }
        return f.length();
    }

    public static String calcFilePath(String fileStoreUrl) {
        if (fileStoreUrl.startsWith("/") || fileStoreUrl.indexOf(58) > 0) {
            return fileStoreUrl;
        }
        return fileStoreRoot + File.separatorChar + fileStoreUrl;
    }

    public static String matchFileStoreUrl(String fileMd5) {
        String pathname = String.valueOf(fileMd5.charAt(0)) + File.separatorChar + fileMd5.charAt(1) + File.separatorChar + fileMd5.charAt(2);
        FileSystemOpt.createDirect((String)OsFileStoreUtils.calcFilePath((String)pathname));
        return pathname + File.separatorChar + fileMd5 + ".dat";
    }

    public static String mapFileAbsolutePath(String fileMd5) {
        return OsFileStoreUtils.calcFilePath((String)OsFileStoreUtils.matchFileStoreUrl((String)fileMd5));
    }

    public static String saveFile(String fileMd5, InputStream is) throws IOException {
        String fileStroeUrl = OsFileStoreUtils.matchFileStoreUrl((String)fileMd5);
        String filePath = OsFileStoreUtils.calcFilePath((String)fileStroeUrl);
        FileSystemOpt.createDirect((String)new File(filePath).getParent());
        FileIOOpt.writeInputStreamToFile((InputStream)is, (String)filePath);
        return fileStroeUrl;
    }

    public static String moveFileToLibrary(String sourFilePath, String fileMd5) throws IOException {
        String filePath = OsFileStoreUtils.matchFileStoreUrl((String)fileMd5);
        String fileAbsPath = OsFileStoreUtils.calcFilePath((String)filePath);
        File destFile = new File(fileAbsPath);
        FileSystemOpt.createDirect((String)destFile.getParent());
        boolean succes = new File(sourFilePath).renameTo(destFile);
        return succes ? filePath : sourFilePath;
    }

    public static boolean checkFile(String fileStoreUrl) {
        return FileSystemOpt.existFile((String)OsFileStoreUtils.calcFilePath((String)fileStoreUrl));
    }

    public static long getFileSize(String fileStoreUrl) throws IOException {
        File f = new File(OsFileStoreUtils.calcFilePath((String)fileStoreUrl));
        return f.length();
    }

    public static InputStream loadFileStream(String fileStoreUrl) throws IOException {
        if (FileSystemOpt.existFile((String)OsFileStoreUtils.calcFilePath((String)fileStoreUrl))) {
            return new FileInputStream(new File(OsFileStoreUtils.calcFilePath((String)fileStoreUrl)));
        }
        throw new ObjectException(OsFileStoreUtils.calcFilePath((String)fileStoreUrl) + "\u65e0\u6b64\u6587\u4ef6");
    }

    public static File getFile(String fileStoreUrl) throws IOException {
        return new File(OsFileStoreUtils.calcFilePath((String)fileStoreUrl));
    }

    public static boolean deleteFile(String fileUrl) throws IOException {
        return FileSystemOpt.deleteFile((String)OsFileStoreUtils.calcFilePath((String)fileUrl));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readStringFromFile(String fileName, long maxLength) {
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(fileName));){
            String string;
            try (StringWriter writer = new StringWriter();){
                int len;
                char[] buf = new char[1024];
                int lenRead = 0;
                while ((len = reader.read(buf)) != -1) {
                    writer.write(buf, 0, len);
                    if ((long)(lenRead += len) < maxLength) continue;
                }
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            logger.error("readStringFromFile\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

