/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.handler;

import com.codingapi.txlcn.common.util.id.RandomUtils;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.listener.RpcConnectionListener;
import com.codingapi.txlcn.txmsg.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.txmsg.netty.bean.SocketManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class SocketManagerInitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SocketManagerInitHandler.class);
    private RpcCmd heartCmd;
    @Autowired
    private RpcConnectionListener rpcConnectionListener;

    public SocketManagerInitHandler() {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("heartCheck");
        this.heartCmd = new NettyRpcCmd();
        this.heartCmd.setMsg(messageDto);
        this.heartCmd.setKey(RandomUtils.simpleKey());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.rpcConnectionListener.connect(ctx.channel().remoteAddress().toString());
        SocketManager.getInstance().addChannel(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        String removeKey = ctx.channel().remoteAddress().toString();
        String appName = SocketManager.getInstance().getModuleName(removeKey);
        this.rpcConnectionListener.disconnect(removeKey, appName);
        SocketManager.getInstance().removeChannel(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && (event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            ctx.writeAndFlush((Object)this.heartCmd);
        }
    }
}

