/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.impl;

import com.codingapi.txlcn.txmsg.RpcClientInitializer;
import com.codingapi.txlcn.txmsg.RpcConfig;
import com.codingapi.txlcn.txmsg.dto.TxManagerHost;
import com.codingapi.txlcn.txmsg.listener.ClientInitCallBack;
import com.codingapi.txlcn.txmsg.netty.bean.SocketManager;
import com.codingapi.txlcn.txmsg.netty.em.NettyType;
import com.codingapi.txlcn.txmsg.netty.handler.init.NettyRpcClientChannelInitializer;
import com.codingapi.txlcn.txmsg.netty.impl.NettyContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NettyRpcClientInitializer
implements RpcClientInitializer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcClientInitializer.class);
    private static NettyRpcClientInitializer INSTANCE;
    private final NettyRpcClientChannelInitializer nettyRpcClientChannelInitializer;
    private final RpcConfig rpcConfig;
    private final ClientInitCallBack clientInitCallBack;
    private EventLoopGroup workerGroup;

    @Autowired
    public NettyRpcClientInitializer(NettyRpcClientChannelInitializer nettyRpcClientChannelInitializer, RpcConfig rpcConfig, ClientInitCallBack clientInitCallBack) {
        this.nettyRpcClientChannelInitializer = nettyRpcClientChannelInitializer;
        this.rpcConfig = rpcConfig;
        this.clientInitCallBack = clientInitCallBack;
        INSTANCE = this;
    }

    public static void reConnect(SocketAddress socketAddress) {
        Objects.requireNonNull(socketAddress, "non support!");
        INSTANCE.connect(socketAddress);
    }

    public void init(List<TxManagerHost> hosts, boolean sync) {
        NettyContext.type = NettyType.client;
        NettyContext.params = hosts;
        this.workerGroup = new NioEventLoopGroup();
        for (TxManagerHost host : hosts) {
            Optional<Future> future = this.connect(new InetSocketAddress(host.getHost(), host.getPort()));
            if (!sync || !future.isPresent()) continue;
            try {
                future.get().get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized Optional<Future> connect(SocketAddress socketAddress) {
        for (int i = 0; i < this.rpcConfig.getReconnectCount(); ++i) {
            if (SocketManager.getInstance().noConnect(socketAddress)) {
                try {
                    log.info("Try connect socket({}) - count {}", (Object)socketAddress, (Object)(i + 1));
                    Bootstrap b = new Bootstrap();
                    b.group(this.workerGroup);
                    b.channel(NioSocketChannel.class);
                    b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
                    b.handler((ChannelHandler)this.nettyRpcClientChannelInitializer);
                    return Optional.of(b.connect(socketAddress).syncUninterruptibly());
                }
                catch (Exception e) {
                    log.warn("Connect socket({}) fail. {}ms latter try again.", (Object)socketAddress, (Object)this.rpcConfig.getReconnectDelay());
                    try {
                        Thread.sleep(this.rpcConfig.getReconnectDelay());
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
            }
            return Optional.empty();
        }
        log.warn("Finally, netty connection fail , socket is {}", (Object)socketAddress);
        this.clientInitCallBack.connectFail(socketAddress.toString());
        return Optional.empty();
    }

    public void destroy() {
        this.workerGroup.shutdownGracefully();
        log.info("RPC client was down.");
    }
}

