/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.conn;

import com.github.tobato.fastdfs.domain.conn.Connection;
import com.github.tobato.fastdfs.domain.conn.FdfsConnectionPool;
import com.github.tobato.fastdfs.domain.proto.FdfsCommand;
import com.github.tobato.fastdfs.exception.FdfsException;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectionManager {
    @Autowired
    private FdfsConnectionPool pool;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);

    public ConnectionManager() {
    }

    public ConnectionManager(FdfsConnectionPool pool) {
        this.pool = pool;
    }

    public <T> T executeFdfsCmd(InetSocketAddress address, FdfsCommand<T> command) {
        Connection conn = this.getConnection(address);
        return this.execute(address, conn, command);
    }

    protected <T> T execute(InetSocketAddress address, Connection conn, FdfsCommand<T> command) {
        try {
            LOGGER.debug("\u5bf9\u5730\u5740{}\u53d1\u51fa\u4ea4\u6613\u8bf7\u6c42{}", (Object)address, (Object)command.getClass().getSimpleName());
            T t = command.execute(conn);
            return t;
        }
        catch (FdfsException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("execute fdfs command error", (Throwable)e);
            throw new RuntimeException("execute fdfs command error", e);
        }
        finally {
            try {
                if (null != conn) {
                    this.pool.returnObject(address, conn);
                }
            }
            catch (Exception e) {
                LOGGER.error("return pooled connection error", (Throwable)e);
            }
        }
    }

    protected Connection getConnection(InetSocketAddress address) {
        Connection conn = null;
        try {
            conn = (Connection)this.pool.borrowObject(address);
        }
        catch (FdfsException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unable to borrow buffer from pool", (Throwable)e);
            throw new RuntimeException("Unable to borrow buffer from pool", e);
        }
        return conn;
    }

    public FdfsConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(FdfsConnectionPool pool) {
        this.pool = pool;
    }

    public void dumpPoolInfo(InetSocketAddress address) {
        LOGGER.debug("==============Begin Dump Pool Info==========");
        LOGGER.debug("\u6d3b\u52a8\u8fde\u63a5{}", (Object)this.pool.getNumActive(address));
        LOGGER.debug("\u7a7a\u95f2\u8fde\u63a5{}", (Object)this.pool.getNumIdle(address));
        LOGGER.debug("\u8fde\u63a5\u83b7\u53d6\u603b\u6570\u7edf\u8ba1{}", (Object)this.pool.getBorrowedCount());
        LOGGER.debug("\u8fde\u63a5\u8fd4\u56de\u603b\u6570\u7edf\u8ba1{}", (Object)this.pool.getReturnedCount());
        LOGGER.debug("\u8fde\u63a5\u9500\u6bc1\u603b\u6570\u7edf\u8ba1{}", (Object)this.pool.getDestroyedCount());
        LOGGER.debug("==============END Dump Pool ================");
    }
}

