/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import com.github.tomakehurst.wiremock.verification.diff.SectionDelimiter;
import com.github.tomakehurst.wiremock.verification.diff.SpacerLine;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Diff {
    private final String stubMappingName;
    private final RequestPattern requestPattern;
    private final Request request;

    public Diff(RequestPattern expected, Request actual) {
        this.requestPattern = expected;
        this.request = actual;
        this.stubMappingName = null;
    }

    public Diff(StubMapping expected, Request actual) {
        this.requestPattern = expected.getRequest();
        this.request = actual;
        this.stubMappingName = expected.getName();
    }

    public String toString() {
        return new JUnitStyleDiffRenderer().render(this);
    }

    public List<DiffLine<?>> getLines() {
        ImmutableList.Builder builder = ImmutableList.builder();
        DiffLine<RequestMethod> methodSection = new DiffLine<RequestMethod>("HTTP method", this.requestPattern.getMethod(), this.request.getMethod(), this.requestPattern.getMethod().getName());
        builder.add(methodSection);
        UrlPattern urlPattern = (UrlPattern)MoreObjects.firstNonNull((Object)this.requestPattern.getUrlMatcher(), (Object)WireMock.anyUrl());
        DiffLine<String> urlSection = new DiffLine<String>("URL", urlPattern, this.request.getUrl(), urlPattern.getExpected());
        builder.add(urlSection);
        builder.add((Object)SpacerLine.SPACER);
        this.addHeaderSection(this.requestPattern.combineBasicAuthAndOtherHeaders(), this.request.getHeaders(), builder);
        boolean anyQueryParams = false;
        if (this.requestPattern.getQueryParameters() != null) {
            Map<String, QueryParameter> requestQueryParams = Urls.splitQuery(URI.create(this.request.getUrl()));
            for (Map.Entry<String, MultiValuePattern> entry : this.requestPattern.getQueryParameters().entrySet()) {
                String key = entry.getKey();
                MultiValuePattern multiValuePattern = entry.getValue();
                QueryParameter queryParameter = (QueryParameter)MoreObjects.firstNonNull((Object)requestQueryParams.get(key), (Object)QueryParameter.absent(key));
                String operator = this.generateOperatorString(multiValuePattern.getValuePattern(), " = ");
                DiffLine<QueryParameter> section = new DiffLine<QueryParameter>("Query", multiValuePattern, queryParameter, "Query: " + key + operator + (String)multiValuePattern.getValuePattern().getValue());
                builder.add(section);
                anyQueryParams = true;
            }
        }
        if (anyQueryParams) {
            builder.add((Object)SpacerLine.SPACER);
        }
        boolean anyCookieSections = false;
        if (this.requestPattern.getCookies() != null) {
            Map cookies = (Map)MoreObjects.firstNonNull(this.request.getCookies(), Collections.emptyMap());
            for (Map.Entry<String, StringValuePattern> entry : this.requestPattern.getCookies().entrySet()) {
                String string = entry.getKey();
                StringValuePattern pattern = entry.getValue();
                Cookie cookie = (Cookie)MoreObjects.firstNonNull(cookies.get(string), (Object)Cookie.absent());
                String operator = this.generateOperatorString(pattern, "=");
                DiffLine<String> section = new DiffLine<String>("Cookie", pattern, cookie.isPresent() ? cookie.getValue() : "", "Cookie: " + string + operator + (String)pattern.getValue());
                builder.add(section);
                anyCookieSections = true;
            }
        }
        if (anyCookieSections) {
            builder.add((Object)SpacerLine.SPACER);
        }
        List<ContentPattern<?>> bodyPatterns = this.requestPattern.getBodyPatterns();
        this.addBodySection(bodyPatterns, new Body(this.request.getBody()), builder);
        List<MultipartValuePattern> multipartPatterns = this.requestPattern.getMultipartPatterns();
        if (multipartPatterns != null && !multipartPatterns.isEmpty()) {
            for (MultipartValuePattern multipartValuePattern : multipartPatterns) {
                if (!this.request.isMultipart()) {
                    builder.add((Object)new SectionDelimiter("[Multipart request body]", ""));
                    continue;
                }
                if (multipartValuePattern.match(this.request).isExactMatch()) continue;
                for (Request.Part part : this.request.getParts()) {
                    builder.add((Object)SpacerLine.SPACER);
                    String patternPartName = multipartValuePattern.getName() == null ? "" : ": " + multipartValuePattern.getName();
                    String partName = part.getName() == null ? "" : part.getName();
                    builder.add((Object)new SectionDelimiter("[Multipart" + patternPartName + "]", "[" + partName + "]"));
                    builder.add((Object)SpacerLine.SPACER);
                    if (!multipartValuePattern.match(part).isExactMatch()) {
                        this.addHeaderSection(multipartValuePattern.getHeaders(), part.getHeaders(), builder);
                        this.addBodySection(multipartValuePattern.getBodyPatterns(), part.getBody(), builder);
                        builder.add((Object)SpacerLine.SPACER);
                    }
                    builder.add((Object)new SectionDelimiter("[/Multipart]", "[/" + partName + "]"));
                    builder.add((Object)SpacerLine.SPACER);
                }
            }
        }
        return builder.build();
    }

    private void addHeaderSection(Map<String, MultiValuePattern> headerPatterns, HttpHeaders headers, ImmutableList.Builder<DiffLine<?>> builder) {
        boolean anyHeaderSections = false;
        if (headerPatterns != null && !headerPatterns.isEmpty()) {
            anyHeaderSections = true;
            for (String key : headerPatterns.keySet()) {
                HttpHeader header = headers.getHeader(key);
                MultiValuePattern headerPattern = headerPatterns.get(header.key());
                String operator = this.generateOperatorString(headerPattern.getValuePattern(), "");
                String printedPatternValue = header.key() + operator + ": " + headerPattern.getExpected();
                DiffLine<HttpHeader> section = new DiffLine<HttpHeader>("Header", headerPattern, header, printedPatternValue);
                builder.add(section);
            }
        }
        if (anyHeaderSections) {
            builder.add((Object)SpacerLine.SPACER);
        }
    }

    private void addBodySection(List<ContentPattern<?>> bodyPatterns, Body body, ImmutableList.Builder<DiffLine<?>> builder) {
        if (bodyPatterns != null && !bodyPatterns.isEmpty()) {
            for (ContentPattern<?> pattern : bodyPatterns) {
                String formattedBody = Diff.formatIfJsonOrXml(pattern, body);
                if (StringValuePattern.class.isAssignableFrom(pattern.getClass())) {
                    StringValuePattern stringValuePattern = (StringValuePattern)pattern;
                    builder.add(new DiffLine<String>("Body", stringValuePattern, formattedBody, pattern.getExpected()));
                    continue;
                }
                BinaryEqualToPattern nonStringPattern = (BinaryEqualToPattern)pattern;
                builder.add(new DiffLine<byte[]>("Body", nonStringPattern, formattedBody.getBytes(), pattern.getExpected()));
            }
        }
    }

    private String generateOperatorString(ContentPattern<?> pattern, String defaultValue) {
        return Diff.isAnEqualToPattern(pattern) ? defaultValue : " [" + pattern.getName() + "] ";
    }

    public String getStubMappingName() {
        return this.stubMappingName;
    }

    private static String formatIfJsonOrXml(ContentPattern<?> pattern, Body body) {
        if (body == null || body.isAbsent()) {
            return "";
        }
        try {
            return pattern.getClass().equals(EqualToJsonPattern.class) ? Json.prettyPrint(body.asString()) : (pattern.getClass().equals(EqualToXmlPattern.class) ? Xml.prettyPrint(body.asString()) : (pattern.getClass().equals(BinaryEqualToPattern.class) ? body.asBase64() : body.asString()));
        }
        catch (Exception e) {
            return body.asString();
        }
    }

    private static boolean isAnEqualToPattern(ContentPattern<?> pattern) {
        return pattern instanceof EqualToPattern || pattern instanceof EqualToJsonPattern || pattern instanceof EqualToXmlPattern || pattern instanceof BinaryEqualToPattern;
    }

    public boolean hasCustomMatcher() {
        return this.requestPattern.hasCustomMatcher();
    }
}

