/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.alloydb.ConnectorConfig;
import com.google.cloud.alloydb.v1alpha.AlloyDBAdminClient;
import com.google.cloud.alloydb.v1alpha.AlloyDBAdminSettings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;

class AlloyDBAdminClientFactory {
    private static final String DEFAULT_ENDPOINT = "alloydb.googleapis.com:443";

    AlloyDBAdminClientFactory() {
    }

    static AlloyDBAdminClient create(FixedCredentialsProvider credentialsProvider, ConnectorConfig config, String userAgents) throws IOException {
        AlloyDBAdminSettings.Builder settingsBuilder = AlloyDBAdminSettings.newBuilder();
        String endpoint = config.getAdminServiceEndpoint();
        if (endpoint == null || endpoint.isEmpty()) {
            endpoint = DEFAULT_ENDPOINT;
        }
        ImmutableMap headers = ImmutableMap.builder().put((Object)"user-agent", (Object)userAgents).build();
        ((AlloyDBAdminSettings.Builder)((AlloyDBAdminSettings.Builder)settingsBuilder.setEndpoint(endpoint)).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)headers))).setCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (config.getQuotaProject() != null) {
            settingsBuilder.setQuotaProjectId(config.getQuotaProject());
        }
        return AlloyDBAdminClient.create((AlloyDBAdminSettings)settingsBuilder.build());
    }
}

