/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.ConnectionInfo;
import com.google.cloud.alloydb.ConnectionInfoCache;
import com.google.cloud.alloydb.ConnectionInfoRepository;
import com.google.cloud.alloydb.RefreshCalculator;
import com.google.cloud.alloydb.TerminalException;
import com.google.cloud.alloydb.v1alpha.InstanceName;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.security.KeyPair;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyConnectionInfoCache
implements ConnectionInfoCache {
    public static final int CLIENT_TIMEOUT_SECONDS = 30;
    private final Logger logger = LoggerFactory.getLogger(LazyConnectionInfoCache.class);
    private final ConnectionInfoRepository connectionInfoRepo;
    private final InstanceName instanceURI;
    private final KeyPair clientConnectorKeyPair;
    private final Object connectionInfoGuard = new Object();
    @GuardedBy(value="connectionInfoGuard")
    private ConnectionInfo connectionInfo;
    @GuardedBy(value="connectionInfoGuard")
    private boolean closed;

    public LazyConnectionInfoCache(ConnectionInfoRepository connectionInfoRepo, InstanceName instanceURI, KeyPair clientConnectorKeyPair) {
        this.connectionInfoRepo = connectionInfoRepo;
        this.instanceURI = instanceURI;
        this.clientConnectorKeyPair = clientConnectorKeyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo getConnectionInfo() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("[%s] Lazy Refresh: Named connection closed.", this.instanceURI));
            }
            if (this.connectionInfo == null || this.needsRefresh(this.connectionInfo.getExpiration())) {
                this.logger.debug(String.format("[%s] Lazy Refresh Operation: Client certificate needs refresh. Starting next refresh operation...", this.instanceURI));
                try {
                    ListenableFuture<ConnectionInfo> infoFuture = this.connectionInfoRepo.getConnectionInfo(this.instanceURI, this.clientConnectorKeyPair);
                    this.connectionInfo = (ConnectionInfo)infoFuture.get(30L, TimeUnit.SECONDS);
                }
                catch (TerminalException e) {
                    this.logger.debug(String.format("[%s] Lazy Refresh Operation: Failed with a terminal error.", this.instanceURI), (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("[%s] Refresh Operation: Failed!", this.instanceURI), e);
                }
            }
            this.logger.debug(String.format("[%s] Lazy Refresh Operation: Completed refresh with new certificate expiration at %s.", this.instanceURI, this.connectionInfo.getExpiration().toString()));
            return this.connectionInfo;
        }
    }

    private boolean needsRefresh(Instant expiration) {
        return Instant.now().isAfter(expiration.minus(RefreshCalculator.DEFAULT_REFRESH_BUFFER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRefresh() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("[%s] Lazy Refresh: Named connection closed.", this.instanceURI));
            }
            this.connectionInfo = null;
            this.logger.debug(String.format("[%s] Lazy Refresh Operation: Forced refresh.", this.instanceURI));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshIfExpired() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("[%s] Lazy Refresh: Named connection closed.", this.instanceURI));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.connectionInfoGuard;
        synchronized (object) {
            this.closed = true;
            this.logger.debug(String.format("[%s] Lazy Refresh Operation: Connector closed.", this.instanceURI));
        }
    }
}

