/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.SearchRequest;
import com.google.cloud.discoveryengine.v1beta.SearchResponse;
import com.google.cloud.discoveryengine.v1beta.SearchServiceClient;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonSearchServiceCallableFactory;
import com.google.cloud.discoveryengine.v1beta.stub.SearchServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SearchServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSearchServiceStub
extends SearchServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<SearchRequest, SearchResponse> searchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SearchService/Search").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{servingConfig=projects/*/locations/*/dataStores/*/servingConfigs/*}:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "servingConfig", (Object)request.getServingConfig());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{servingConfig=projects/*/locations/*/collections/*/dataStores/*/servingConfigs/*}:search", "/v1beta/{servingConfig=projects/*/locations/*/collections/*/engines/*/servingConfigs/*}:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearServingConfig().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchRequest, SearchResponse> searchLiteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.SearchService/SearchLite").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{servingConfig=projects/*/locations/*/dataStores/*/servingConfigs/*}:searchLite", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "servingConfig", (Object)request.getServingConfig());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{servingConfig=projects/*/locations/*/collections/*/dataStores/*/servingConfigs/*}:searchLite", "/v1beta/{servingConfig=projects/*/locations/*/collections/*/engines/*/servingConfigs/*}:searchLite"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearServingConfig().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<SearchRequest, SearchResponse> searchCallable;
    private final UnaryCallable<SearchRequest, SearchServiceClient.SearchPagedResponse> searchPagedCallable;
    private final UnaryCallable<SearchRequest, SearchResponse> searchLiteCallable;
    private final UnaryCallable<SearchRequest, SearchServiceClient.SearchLitePagedResponse> searchLitePagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSearchServiceStub create(SearchServiceStubSettings settings) throws IOException {
        return new HttpJsonSearchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSearchServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSearchServiceStub(SearchServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSearchServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSearchServiceStub(SearchServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSearchServiceStub(SearchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSearchServiceCallableFactory());
    }

    protected HttpJsonSearchServiceStub(SearchServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings searchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config", String.valueOf(request.getServingConfig()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchLiteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchLiteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config", String.valueOf(request.getServingConfig()));
            return builder.build();
        }).build();
        this.searchCallable = callableFactory.createUnaryCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchPagedCallable = callableFactory.createPagedCallable(searchTransportSettings, settings.searchSettings(), clientContext);
        this.searchLiteCallable = callableFactory.createUnaryCallable(searchLiteTransportSettings, settings.searchLiteSettings(), clientContext);
        this.searchLitePagedCallable = callableFactory.createPagedCallable(searchLiteTransportSettings, settings.searchLiteSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(searchMethodDescriptor);
        methodDescriptors.add(searchLiteMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchResponse> searchCallable() {
        return this.searchCallable;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchServiceClient.SearchPagedResponse> searchPagedCallable() {
        return this.searchPagedCallable;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchResponse> searchLiteCallable() {
        return this.searchLiteCallable;
    }

    @Override
    public UnaryCallable<SearchRequest, SearchServiceClient.SearchLitePagedResponse> searchLitePagedCallable() {
        return this.searchLitePagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

