/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public record AssistantMessage(String role, String content, String name, String refusal, List<ToolCall> toolCalls) implements ChatMessage
{
    public static final String ROLE = "assistant";

    public AssistantMessage {
        role = ROLE;
        if (Objects.isNull(content) && Objects.isNull(toolCalls)) {
            throw new NullPointerException("Either content or toolCalls must be specified");
        }
    }

    public AssistantMessage(String content, String name, String refusal, List<ToolCall> toolCalls) {
        this(ROLE, content, name, refusal, toolCalls);
    }

    public static AssistantMessage text(String content) {
        return AssistantMessage.text(content, null);
    }

    public static AssistantMessage text(String content, String name) {
        return new AssistantMessage(ROLE, content, name, null, null);
    }

    public static AssistantMessage tools(ToolCall ... toolCalls) {
        return AssistantMessage.tools(Arrays.asList(toolCalls));
    }

    public static AssistantMessage tools(List<ToolCall> toolCalls) {
        return AssistantMessage.tools(null, toolCalls);
    }

    public static AssistantMessage tools(String name, List<ToolCall> toolCalls) {
        return new AssistantMessage(ROLE, null, name, null, toolCalls);
    }
}

