/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface JsonSchema {
    public static ObjectSchema.Builder builder() {
        return ObjectSchema.of();
    }

    public record ObjectSchema(Object type, Map<String, JsonSchema> properties, List<String> required) implements JsonSchema
    {
        private final Object type;

        public Object type() {
            return "object";
        }

        public static Builder of() {
            return new Builder();
        }

        public static class Builder {
            private Map<String, JsonSchema> properties = new LinkedHashMap<String, JsonSchema>();
            private List<String> required;

            private Builder() {
            }

            public Builder addStringProperty(String name) {
                return this.addStringProperty(name, null);
            }

            public Builder addNullableStringProperty(String name) {
                return this.addNullableStringProperty(name, null);
            }

            public Builder addStringProperty(String name, String description) {
                return this.addStringProperty(name, description, false);
            }

            public Builder addNullableStringProperty(String name, String description) {
                return this.addStringProperty(name, description, true);
            }

            public Builder addStringProperty(String name, String description, boolean nullable) {
                if (Objects.nonNull(description)) {
                    StringSchema schema = nullable ? StringSchema.ofNullable(description) : StringSchema.of(description);
                    return this.addProperty(name, schema);
                }
                return this.addProperty(name, nullable ? StringSchema.ofNullable() : StringSchema.of());
            }

            public Builder addIntegerProperty(String name) {
                return this.addIntegerProperty(name, null);
            }

            public Builder addNullableIntegerProperty(String name) {
                return this.addNullableIntegerProperty(name, null);
            }

            public Builder addIntegerProperty(String name, String description) {
                return this.addIntegerProperty(name, description, false);
            }

            public Builder addNullableIntegerProperty(String name, String description) {
                return this.addIntegerProperty(name, description, true);
            }

            public Builder addIntegerProperty(String name, String description, boolean nullable) {
                if (Objects.nonNull(description)) {
                    IntegerSchema schema = nullable ? IntegerSchema.ofNullable(description) : IntegerSchema.of(description);
                    return this.addProperty(name, schema);
                }
                return this.addProperty(name, nullable ? IntegerSchema.ofNullable() : IntegerSchema.of());
            }

            public Builder addNumberProperty(String name) {
                return this.addNumberProperty(name, null);
            }

            public Builder addNullableNumberProperty(String name) {
                return this.addNullableNumberProperty(name, null);
            }

            public Builder addNumberProperty(String name, String description) {
                return this.addNumberProperty(name, description, false);
            }

            public Builder addNullableNumberProperty(String name, String description) {
                return this.addNumberProperty(name, description, true);
            }

            public Builder addNumberProperty(String name, String description, boolean nullable) {
                if (Objects.nonNull(description)) {
                    NumberSchema schema = nullable ? NumberSchema.ofNullable(description) : NumberSchema.of(description);
                    return this.addProperty(name, schema);
                }
                return this.addProperty(name, nullable ? NumberSchema.ofNullable() : NumberSchema.of());
            }

            public Builder addBooleanProperty(String name) {
                return this.addBooleanProperty(name, null);
            }

            public Builder addNullableBooleanProperty(String name) {
                return this.addNullableBooleanProperty(name, null);
            }

            public Builder addBooleanProperty(String name, String description) {
                return this.addBooleanProperty(name, description, false);
            }

            public Builder addNullableBooleanProperty(String name, String description) {
                return this.addBooleanProperty(name, description, true);
            }

            public Builder addBooleanProperty(String name, String description, boolean nullable) {
                if (Objects.nonNull(description)) {
                    BooleanSchema schema = nullable ? BooleanSchema.ofNullable(description) : BooleanSchema.of(description);
                    return this.addProperty(name, schema);
                }
                return this.addProperty(name, nullable ? BooleanSchema.ofNullable() : BooleanSchema.of());
            }

            public Builder addArrayProperty(String name, Builder schema) {
                Objects.requireNonNull(schema);
                return this.addProperty(name, ArraySchema.of(schema.build()));
            }

            public Builder addArrayProperty(String name, JsonSchema schema) {
                return this.addProperty(name, ArraySchema.of(schema));
            }

            public Builder addEnumProperty(String name, Object ... values) {
                return this.addProperty(name, EnumSchema.of(values));
            }

            public Builder addObjectProperty(String name, JsonSchema schema) {
                return this.addProperty(name, schema);
            }

            public Builder addProperty(String name, JsonSchema schema) {
                Objects.requireNonNull(name);
                Objects.requireNonNull(schema);
                this.properties.put(name, schema);
                return this;
            }

            public Builder required(List<String> required) {
                this.required = required;
                return this;
            }

            public Builder required(String ... required) {
                return this.required(Arrays.asList(required));
            }

            public ObjectSchema build() {
                return new ObjectSchema("object", this.properties, this.required);
            }
        }
    }

    public record EnumSchema<T>(List<T> enumValues) implements JsonSchema
    {
        public EnumSchema {
            enumValues = Objects.requireNonNull(enumValues);
        }

        @SafeVarargs
        public static <T> EnumSchema<T> of(T ... values) {
            return new EnumSchema<T>(Arrays.asList(values));
        }
    }

    public record ArraySchema(String type, JsonSchema items) implements JsonSchema
    {
        public ArraySchema {
            type = "array";
            items = Objects.requireNonNull(items);
        }

        public static ArraySchema of(JsonSchema schema) {
            return new ArraySchema("array", schema);
        }
    }

    public record BooleanSchema(Object type, String description) implements JsonSchema
    {
        public static BooleanSchema ofNullable() {
            return BooleanSchema.ofNullable(null);
        }

        public static BooleanSchema ofNullable(String description) {
            return new BooleanSchema(List.of("boolean", "null"), description);
        }

        public static BooleanSchema of() {
            return BooleanSchema.of(null);
        }

        public static BooleanSchema of(String description) {
            return new BooleanSchema("boolean", description);
        }
    }

    public record IntegerSchema(Object type, String description) implements JsonSchema
    {
        public static IntegerSchema ofNullable() {
            return IntegerSchema.ofNullable(null);
        }

        public static IntegerSchema ofNullable(String description) {
            return new IntegerSchema(List.of("integer", "null"), description);
        }

        public static IntegerSchema of() {
            return IntegerSchema.of(null);
        }

        public static IntegerSchema of(String description) {
            return new IntegerSchema("integer", description);
        }
    }

    public record NumberSchema(Object type, String description) implements JsonSchema
    {
        public static NumberSchema ofNullable() {
            return NumberSchema.ofNullable(null);
        }

        public static NumberSchema ofNullable(String description) {
            return new NumberSchema(List.of("number", "null"), description);
        }

        public static NumberSchema of() {
            return NumberSchema.of(null);
        }

        public static NumberSchema of(String description) {
            return new NumberSchema("number", description);
        }
    }

    public record StringSchema(Object type, String description) implements JsonSchema
    {
        public static StringSchema ofNullable() {
            return StringSchema.ofNullable(null);
        }

        public static StringSchema ofNullable(String description) {
            return new StringSchema(List.of("string", "null"), description);
        }

        public static StringSchema of() {
            return StringSchema.of(null);
        }

        public static StringSchema of(String description) {
            return new StringSchema("string", description);
        }
    }
}

