/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import com.ibm.watsonx.ai.timeseries.TimeSeriesProvider;
import com.ibm.watsonx.ai.timeseries.TimeSeriesRequest;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeSeriesService
extends WatsonxService.ModelService
implements TimeSeriesProvider {
    public static final Logger logger = LoggerFactory.getLogger(TimeSeriesService.class);

    protected TimeSeriesService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    @Override
    public ForecastResponse forecast(TimeSeriesRequest request) {
        if (Objects.nonNull(request.getDeploymentId())) {
            logger.info("The deploymentId parameter can not be used with the TimeSeriesService. Use the DeploymentService instead");
        }
        InputSchema inputSchema = request.getInputSchema();
        ForecastData data = request.getData();
        TimeSeriesParameters parameters = request.getParameters();
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        ForecastRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toParameters();
        }
        ForecastRequest forecastRequest = new ForecastRequest(modelId, spaceId, projectId, data.asMap(), inputSchema, null, requestParameters);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/time_series/forecast?version=%s".formatted("/ml/v1", this.version))).header("Content-Type", "application/json").header("Accept", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)forecastRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ForecastResponse)Json.fromJson((String)((String)httpReponse.body()), ForecastResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ForecastResponse forecast(InputSchema inputSchema, ForecastData data) {
        return this.forecast(inputSchema, data, null);
    }

    public ForecastResponse forecast(InputSchema inputSchema, ForecastData data, TimeSeriesParameters parameters) {
        return this.forecast(TimeSeriesRequest.builder().inputSchema(inputSchema).data(data).parameters(parameters).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public TimeSeriesService build() {
            return new TimeSeriesService(this);
        }
    }
}

