/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.tool.ToolParameters;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.UtilityTool;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public final class ToolService
extends WatsonxService {
    private static final String API_PATH = "/v1-beta/utility_agent_tools";

    public ToolService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    public Resources getAll() {
        return this.getAll(ToolParameters.builder().build());
    }

    public Resources getAll(ToolParameters parameters) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString().concat(API_PATH))).header("Accept", "application/json").timeout(this.timeout).GET();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (Resources)Json.fromJson((String)((String)httpReponse.body()), Resources.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public UtilityTool getByName(String name) {
        return this.getByName(name, ToolParameters.builder().build());
    }

    public UtilityTool getByName(String name, ToolParameters parameters) {
        Objects.requireNonNull(name, "The name of the tool must be provided");
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/%s".formatted(API_PATH, name))).header("Accept", "application/json").timeout(this.timeout).GET();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (UtilityTool)Json.fromJson((String)((String)httpReponse.body()), UtilityTool.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String run(ToolRequest toolRequest) {
        return this.run(toolRequest, ToolParameters.builder().build());
    }

    public String run(ToolRequest toolRequest, ToolParameters parameters) {
        Objects.requireNonNull(toolRequest, "The tool run request must be provided");
        Objects.requireNonNull(toolRequest.toolName(), "The name of the tool must be provided");
        Objects.requireNonNull(toolRequest.input(), "The input of the tool must be provided");
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/run".formatted(API_PATH))).header("Accept", "application/json").header("Content-Type", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)toolRequest)));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            Map result = (Map)Json.fromJson((String)((String)httpReponse.body()), Map.class);
            return (String)result.get("output");
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.Builder<Builder> {
        private Builder() {
        }

        @Override
        public Builder url(CloudRegion url) {
            return (Builder)super.url(url.getWxEndpoint());
        }

        public ToolService build() {
            return new ToolService(this);
        }
    }

    public record Resources(List<UtilityTool> resources) {
    }
}

