// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.approval.v4.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ManageableInstanceNode {
    /**
     * 审批实例 code
     * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
     */
    @SerializedName("code")
    private String code;
    /**
     * 审批实例发起人id
     * <p> 示例值：lwiu098wj
     */
    @SerializedName("start_user_id")
    private String startUserId;
    /**
     * 当前处理人id
     * <p> 示例值：lwiu098wj
     */
    @SerializedName("current_user_ids")
    private String[] currentUserIds;
    /**
     * 审批实例所属部门id
     * <p> 示例值：od-8ec33ffec336c3a39a278bc25e931676
     */
    @SerializedName("department_id")
    private String departmentId;
    /**
     * 当前处理节点名称
     * <p> 示例值：审批节点1
     */
    @SerializedName("node_name")
    private String nodeName;
    /**
     * json字符串，控件值
     * <p> 示例值：[{\"id\": \"widget1\",\"custom_id\": \"user_info\",\"name\": \"Item application\",\"type\": \"textarea\"},\"value\":\"aaaa\"]
     */
    @SerializedName("form")
    private String form;
    /**
     * 审批实例对应的审批定义版本
     * <p> 示例值：7129705107930742803
     */
    @SerializedName("version")
    private String version;
    /**
     * 审批实例发起时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("start_time")
    private String startTime;
    /**
     * 审批实例结束时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("end_time")
    private String endTime;
    /**
     * 审批实例状态
     * <p> 示例值：PENDING
     */
    @SerializedName("status")
    private String status;
    /**
     * 审批流水号
     * <p> 示例值：201902020001
     */
    @SerializedName("serial_id")
    private String serialId;
    /**
     * 审批状态展示值
     * <p> 示例值："已通过"
     */
    @SerializedName("status_display")
    private String statusDisplay;

    // builder 开始
    public ManageableInstanceNode() {
    }

    public ManageableInstanceNode(Builder builder) {
        /**
         * 审批实例 code
         * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
         */
        this.code = builder.code;
        /**
         * 审批实例发起人id
         * <p> 示例值：lwiu098wj
         */
        this.startUserId = builder.startUserId;
        /**
         * 当前处理人id
         * <p> 示例值：lwiu098wj
         */
        this.currentUserIds = builder.currentUserIds;
        /**
         * 审批实例所属部门id
         * <p> 示例值：od-8ec33ffec336c3a39a278bc25e931676
         */
        this.departmentId = builder.departmentId;
        /**
         * 当前处理节点名称
         * <p> 示例值：审批节点1
         */
        this.nodeName = builder.nodeName;
        /**
         * json字符串，控件值
         * <p> 示例值：[{\"id\": \"widget1\",\"custom_id\": \"user_info\",\"name\": \"Item application\",\"type\": \"textarea\"},\"value\":\"aaaa\"]
         */
        this.form = builder.form;
        /**
         * 审批实例对应的审批定义版本
         * <p> 示例值：7129705107930742803
         */
        this.version = builder.version;
        /**
         * 审批实例发起时间
         * <p> 示例值：1547654251506
         */
        this.startTime = builder.startTime;
        /**
         * 审批实例结束时间
         * <p> 示例值：1547654251506
         */
        this.endTime = builder.endTime;
        /**
         * 审批实例状态
         * <p> 示例值：PENDING
         */
        this.status = builder.status;
        /**
         * 审批流水号
         * <p> 示例值：201902020001
         */
        this.serialId = builder.serialId;
        /**
         * 审批状态展示值
         * <p> 示例值："已通过"
         */
        this.statusDisplay = builder.statusDisplay;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public String[] getCurrentUserIds() {
        return this.currentUserIds;
    }

    public void setCurrentUserIds(String[] currentUserIds) {
        this.currentUserIds = currentUserIds;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public String getStatusDisplay() {
        return this.statusDisplay;
    }

    public void setStatusDisplay(String statusDisplay) {
        this.statusDisplay = statusDisplay;
    }

    public static class Builder {
        /**
         * 审批实例 code
         * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
         */
        private String code;
        /**
         * 审批实例发起人id
         * <p> 示例值：lwiu098wj
         */
        private String startUserId;
        /**
         * 当前处理人id
         * <p> 示例值：lwiu098wj
         */
        private String[] currentUserIds;
        /**
         * 审批实例所属部门id
         * <p> 示例值：od-8ec33ffec336c3a39a278bc25e931676
         */
        private String departmentId;
        /**
         * 当前处理节点名称
         * <p> 示例值：审批节点1
         */
        private String nodeName;
        /**
         * json字符串，控件值
         * <p> 示例值：[{\"id\": \"widget1\",\"custom_id\": \"user_info\",\"name\": \"Item application\",\"type\": \"textarea\"},\"value\":\"aaaa\"]
         */
        private String form;
        /**
         * 审批实例对应的审批定义版本
         * <p> 示例值：7129705107930742803
         */
        private String version;
        /**
         * 审批实例发起时间
         * <p> 示例值：1547654251506
         */
        private String startTime;
        /**
         * 审批实例结束时间
         * <p> 示例值：1547654251506
         */
        private String endTime;
        /**
         * 审批实例状态
         * <p> 示例值：PENDING
         */
        private String status;
        /**
         * 审批流水号
         * <p> 示例值：201902020001
         */
        private String serialId;
        /**
         * 审批状态展示值
         * <p> 示例值："已通过"
         */
        private String statusDisplay;

        /**
         * 审批实例 code
         * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 审批实例发起人id
         * <p> 示例值：lwiu098wj
         *
         * @param startUserId
         * @return
         */
        public Builder startUserId(String startUserId) {
            this.startUserId = startUserId;
            return this;
        }


        /**
         * 当前处理人id
         * <p> 示例值：lwiu098wj
         *
         * @param currentUserIds
         * @return
         */
        public Builder currentUserIds(String[] currentUserIds) {
            this.currentUserIds = currentUserIds;
            return this;
        }


        /**
         * 审批实例所属部门id
         * <p> 示例值：od-8ec33ffec336c3a39a278bc25e931676
         *
         * @param departmentId
         * @return
         */
        public Builder departmentId(String departmentId) {
            this.departmentId = departmentId;
            return this;
        }


        /**
         * 当前处理节点名称
         * <p> 示例值：审批节点1
         *
         * @param nodeName
         * @return
         */
        public Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }


        /**
         * json字符串，控件值
         * <p> 示例值：[{\"id\": \"widget1\",\"custom_id\": \"user_info\",\"name\": \"Item application\",\"type\": \"textarea\"},\"value\":\"aaaa\"]
         *
         * @param form
         * @return
         */
        public Builder form(String form) {
            this.form = form;
            return this;
        }


        /**
         * 审批实例对应的审批定义版本
         * <p> 示例值：7129705107930742803
         *
         * @param version
         * @return
         */
        public Builder version(String version) {
            this.version = version;
            return this;
        }


        /**
         * 审批实例发起时间
         * <p> 示例值：1547654251506
         *
         * @param startTime
         * @return
         */
        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }


        /**
         * 审批实例结束时间
         * <p> 示例值：1547654251506
         *
         * @param endTime
         * @return
         */
        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }


        /**
         * 审批实例状态
         * <p> 示例值：PENDING
         *
         * @param status
         * @return
         */
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        /**
         * 审批实例状态
         * <p> 示例值：PENDING
         *
         * @param status {@link com.lark.oapi.service.approval.v4.enums.ManageableInstanceNodeStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.approval.v4.enums.ManageableInstanceNodeStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        /**
         * 审批流水号
         * <p> 示例值：201902020001
         *
         * @param serialId
         * @return
         */
        public Builder serialId(String serialId) {
            this.serialId = serialId;
            return this;
        }


        /**
         * 审批状态展示值
         * <p> 示例值："已通过"
         *
         * @param statusDisplay
         * @return
         */
        public Builder statusDisplay(String statusDisplay) {
            this.statusDisplay = statusDisplay;
            return this;
        }


        public ManageableInstanceNode build() {
            return new ManageableInstanceNode(this);
        }
    }
}
