// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.board.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Connector {
    /**
     * 连线连接的起点图形
     * <p> 示例值：
     */
    @SerializedName("start_object")
    private ConnectorAttachedObject startObject;
    /**
     * 连线连接的终点图形
     * <p> 示例值：
     */
    @SerializedName("end_object")
    private ConnectorAttachedObject endObject;
    /**
     * 连线文本
     * <p> 示例值：
     */
    @SerializedName("captions")
    private ConnectorCaption captions;

    // builder 开始
    public Connector() {
    }

    public Connector(Builder builder) {
        /**
         * 连线连接的起点图形
         * <p> 示例值：
         */
        this.startObject = builder.startObject;
        /**
         * 连线连接的终点图形
         * <p> 示例值：
         */
        this.endObject = builder.endObject;
        /**
         * 连线文本
         * <p> 示例值：
         */
        this.captions = builder.captions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ConnectorAttachedObject getStartObject() {
        return this.startObject;
    }

    public void setStartObject(ConnectorAttachedObject startObject) {
        this.startObject = startObject;
    }

    public ConnectorAttachedObject getEndObject() {
        return this.endObject;
    }

    public void setEndObject(ConnectorAttachedObject endObject) {
        this.endObject = endObject;
    }

    public ConnectorCaption getCaptions() {
        return this.captions;
    }

    public void setCaptions(ConnectorCaption captions) {
        this.captions = captions;
    }

    public static class Builder {
        /**
         * 连线连接的起点图形
         * <p> 示例值：
         */
        private ConnectorAttachedObject startObject;
        /**
         * 连线连接的终点图形
         * <p> 示例值：
         */
        private ConnectorAttachedObject endObject;
        /**
         * 连线文本
         * <p> 示例值：
         */
        private ConnectorCaption captions;

        /**
         * 连线连接的起点图形
         * <p> 示例值：
         *
         * @param startObject
         * @return
         */
        public Builder startObject(ConnectorAttachedObject startObject) {
            this.startObject = startObject;
            return this;
        }


        /**
         * 连线连接的终点图形
         * <p> 示例值：
         *
         * @param endObject
         * @return
         */
        public Builder endObject(ConnectorAttachedObject endObject) {
            this.endObject = endObject;
            return this;
        }


        /**
         * 连线文本
         * <p> 示例值：
         *
         * @param captions
         * @return
         */
        public Builder captions(ConnectorCaption captions) {
            this.captions = captions;
            return this;
        }


        public Connector build() {
            return new Connector(this);
        }
    }
}
