// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ResidentTaxForUpdate {
    /**
     * 国家 / 地区ID
     * <p> 示例值：6862995757234914824
     */
    @SerializedName("tax_country_region")
    private String taxCountryRegion;
    /**
     * 居民身份
     * <p> 示例值：tax_residence
     */
    @SerializedName("resident_status")
    private String residentStatus;
    /**
     * 纳税地址
     * <p> 示例值：
     */
    @SerializedName("tax_address")
    private AddressForUpdate taxAddress;
    /**
     * 居民纳税身份说明
     * <p> 示例值：xxx
     */
    @SerializedName("resident_status_specification")
    private String residentStatusSpecification;
    /**
     * 年度
     * <p> 示例值：2006-01-01
     */
    @SerializedName("year_resident_tax")
    private String yearResidentTax;

    // builder 开始
    public ResidentTaxForUpdate() {
    }

    public ResidentTaxForUpdate(Builder builder) {
        /**
         * 国家 / 地区ID
         * <p> 示例值：6862995757234914824
         */
        this.taxCountryRegion = builder.taxCountryRegion;
        /**
         * 居民身份
         * <p> 示例值：tax_residence
         */
        this.residentStatus = builder.residentStatus;
        /**
         * 纳税地址
         * <p> 示例值：
         */
        this.taxAddress = builder.taxAddress;
        /**
         * 居民纳税身份说明
         * <p> 示例值：xxx
         */
        this.residentStatusSpecification = builder.residentStatusSpecification;
        /**
         * 年度
         * <p> 示例值：2006-01-01
         */
        this.yearResidentTax = builder.yearResidentTax;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTaxCountryRegion() {
        return this.taxCountryRegion;
    }

    public void setTaxCountryRegion(String taxCountryRegion) {
        this.taxCountryRegion = taxCountryRegion;
    }

    public String getResidentStatus() {
        return this.residentStatus;
    }

    public void setResidentStatus(String residentStatus) {
        this.residentStatus = residentStatus;
    }

    public AddressForUpdate getTaxAddress() {
        return this.taxAddress;
    }

    public void setTaxAddress(AddressForUpdate taxAddress) {
        this.taxAddress = taxAddress;
    }

    public String getResidentStatusSpecification() {
        return this.residentStatusSpecification;
    }

    public void setResidentStatusSpecification(String residentStatusSpecification) {
        this.residentStatusSpecification = residentStatusSpecification;
    }

    public String getYearResidentTax() {
        return this.yearResidentTax;
    }

    public void setYearResidentTax(String yearResidentTax) {
        this.yearResidentTax = yearResidentTax;
    }

    public static class Builder {
        /**
         * 国家 / 地区ID
         * <p> 示例值：6862995757234914824
         */
        private String taxCountryRegion;
        /**
         * 居民身份
         * <p> 示例值：tax_residence
         */
        private String residentStatus;
        /**
         * 纳税地址
         * <p> 示例值：
         */
        private AddressForUpdate taxAddress;
        /**
         * 居民纳税身份说明
         * <p> 示例值：xxx
         */
        private String residentStatusSpecification;
        /**
         * 年度
         * <p> 示例值：2006-01-01
         */
        private String yearResidentTax;

        /**
         * 国家 / 地区ID
         * <p> 示例值：6862995757234914824
         *
         * @param taxCountryRegion
         * @return
         */
        public Builder taxCountryRegion(String taxCountryRegion) {
            this.taxCountryRegion = taxCountryRegion;
            return this;
        }


        /**
         * 居民身份
         * <p> 示例值：tax_residence
         *
         * @param residentStatus
         * @return
         */
        public Builder residentStatus(String residentStatus) {
            this.residentStatus = residentStatus;
            return this;
        }


        /**
         * 纳税地址
         * <p> 示例值：
         *
         * @param taxAddress
         * @return
         */
        public Builder taxAddress(AddressForUpdate taxAddress) {
            this.taxAddress = taxAddress;
            return this;
        }


        /**
         * 居民纳税身份说明
         * <p> 示例值：xxx
         *
         * @param residentStatusSpecification
         * @return
         */
        public Builder residentStatusSpecification(String residentStatusSpecification) {
            this.residentStatusSpecification = residentStatusSpecification;
            return this;
        }


        /**
         * 年度
         * <p> 示例值：2006-01-01
         *
         * @param yearResidentTax
         * @return
         */
        public Builder yearResidentTax(String yearResidentTax) {
            this.yearResidentTax = yearResidentTax;
            return this;
        }


        public ResidentTaxForUpdate build() {
            return new ResidentTaxForUpdate(this);
        }
    }
}
