// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SignatureTemplateIdWithSystemAndCustomField {
    /**
     * 电子签模板id
     * <p> 示例值：1231241
     */
    @SerializedName("id")
    private String id;
    /**
     * 该电子签模板对应的系统字段
     * <p> 示例值：
     */
    @SerializedName("system_field_info")
    private SignatureFileSystemField systemFieldInfo;
    /**
     * 该电子签模板对应的自定义字段 v1版本, 不支持多语类型
     * <p> 示例值：
     */
    @SerializedName("custom_field_info")
    private SignatureCustomFieldV1 customFieldInfo;
    /**
     * 该电子签模板对应的自定义字段 v2 版本, 支持多语类型
     * <p> 示例值：
     */
    @SerializedName("custom_field_info_v2")
    private SignatureCustomFieldV2 customFieldInfoV2;

    // builder 开始
    public SignatureTemplateIdWithSystemAndCustomField() {
    }

    public SignatureTemplateIdWithSystemAndCustomField(Builder builder) {
        /**
         * 电子签模板id
         * <p> 示例值：1231241
         */
        this.id = builder.id;
        /**
         * 该电子签模板对应的系统字段
         * <p> 示例值：
         */
        this.systemFieldInfo = builder.systemFieldInfo;
        /**
         * 该电子签模板对应的自定义字段 v1版本, 不支持多语类型
         * <p> 示例值：
         */
        this.customFieldInfo = builder.customFieldInfo;
        /**
         * 该电子签模板对应的自定义字段 v2 版本, 支持多语类型
         * <p> 示例值：
         */
        this.customFieldInfoV2 = builder.customFieldInfoV2;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SignatureFileSystemField getSystemFieldInfo() {
        return this.systemFieldInfo;
    }

    public void setSystemFieldInfo(SignatureFileSystemField systemFieldInfo) {
        this.systemFieldInfo = systemFieldInfo;
    }

    public SignatureCustomFieldV1 getCustomFieldInfo() {
        return this.customFieldInfo;
    }

    public void setCustomFieldInfo(SignatureCustomFieldV1 customFieldInfo) {
        this.customFieldInfo = customFieldInfo;
    }

    public SignatureCustomFieldV2 getCustomFieldInfoV2() {
        return this.customFieldInfoV2;
    }

    public void setCustomFieldInfoV2(SignatureCustomFieldV2 customFieldInfoV2) {
        this.customFieldInfoV2 = customFieldInfoV2;
    }

    public static class Builder {
        /**
         * 电子签模板id
         * <p> 示例值：1231241
         */
        private String id;
        /**
         * 该电子签模板对应的系统字段
         * <p> 示例值：
         */
        private SignatureFileSystemField systemFieldInfo;
        /**
         * 该电子签模板对应的自定义字段 v1版本, 不支持多语类型
         * <p> 示例值：
         */
        private SignatureCustomFieldV1 customFieldInfo;
        /**
         * 该电子签模板对应的自定义字段 v2 版本, 支持多语类型
         * <p> 示例值：
         */
        private SignatureCustomFieldV2 customFieldInfoV2;

        /**
         * 电子签模板id
         * <p> 示例值：1231241
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 该电子签模板对应的系统字段
         * <p> 示例值：
         *
         * @param systemFieldInfo
         * @return
         */
        public Builder systemFieldInfo(SignatureFileSystemField systemFieldInfo) {
            this.systemFieldInfo = systemFieldInfo;
            return this;
        }


        /**
         * 该电子签模板对应的自定义字段 v1版本, 不支持多语类型
         * <p> 示例值：
         *
         * @param customFieldInfo
         * @return
         */
        public Builder customFieldInfo(SignatureCustomFieldV1 customFieldInfo) {
            this.customFieldInfo = customFieldInfo;
            return this;
        }


        /**
         * 该电子签模板对应的自定义字段 v2 版本, 支持多语类型
         * <p> 示例值：
         *
         * @param customFieldInfoV2
         * @return
         */
        public Builder customFieldInfoV2(SignatureCustomFieldV2 customFieldInfoV2) {
            this.customFieldInfoV2 = customFieldInfoV2;
            return this;
        }


        public SignatureTemplateIdWithSystemAndCustomField build() {
            return new SignatureTemplateIdWithSystemAndCustomField(this);
        }
    }
}
