// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.drive.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class FileSearch {
    /**
     * 文档token
     * <p> 示例值：doxbcxcAgzUTcPI5xR7c6nGJDGc
     */
    @SerializedName("docs_token")
    private String docsToken;
    /**
     * 文档类型
     * <p> 示例值：sheet
     */
    @SerializedName("docs_type")
    private String docsType;
    /**
     * 标题
     * <p> 示例值：标题
     */
    @SerializedName("title")
    private String title;
    /**
     * 文件所有者
     * <p> 示例值：ou_6e92f20bb8842c89c0f7e4090b13d57a
     */
    @SerializedName("owner_id")
    private String ownerId;

    // builder 开始
    public FileSearch() {
    }

    public FileSearch(Builder builder) {
        /**
         * 文档token
         * <p> 示例值：doxbcxcAgzUTcPI5xR7c6nGJDGc
         */
        this.docsToken = builder.docsToken;
        /**
         * 文档类型
         * <p> 示例值：sheet
         */
        this.docsType = builder.docsType;
        /**
         * 标题
         * <p> 示例值：标题
         */
        this.title = builder.title;
        /**
         * 文件所有者
         * <p> 示例值：ou_6e92f20bb8842c89c0f7e4090b13d57a
         */
        this.ownerId = builder.ownerId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDocsToken() {
        return this.docsToken;
    }

    public void setDocsToken(String docsToken) {
        this.docsToken = docsToken;
    }

    public String getDocsType() {
        return this.docsType;
    }

    public void setDocsType(String docsType) {
        this.docsType = docsType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public static class Builder {
        /**
         * 文档token
         * <p> 示例值：doxbcxcAgzUTcPI5xR7c6nGJDGc
         */
        private String docsToken;
        /**
         * 文档类型
         * <p> 示例值：sheet
         */
        private String docsType;
        /**
         * 标题
         * <p> 示例值：标题
         */
        private String title;
        /**
         * 文件所有者
         * <p> 示例值：ou_6e92f20bb8842c89c0f7e4090b13d57a
         */
        private String ownerId;

        /**
         * 文档token
         * <p> 示例值：doxbcxcAgzUTcPI5xR7c6nGJDGc
         *
         * @param docsToken
         * @return
         */
        public Builder docsToken(String docsToken) {
            this.docsToken = docsToken;
            return this;
        }


        /**
         * 文档类型
         * <p> 示例值：sheet
         *
         * @param docsType
         * @return
         */
        public Builder docsType(String docsType) {
            this.docsType = docsType;
            return this;
        }

        /**
         * 文档类型
         * <p> 示例值：sheet
         *
         * @param docsType {@link com.lark.oapi.service.drive.v1.enums.FileSearchDocsTypeEnum}
         * @return
         */
        public Builder docsType(com.lark.oapi.service.drive.v1.enums.FileSearchDocsTypeEnum docsType) {
            this.docsType = docsType.getValue();
            return this;
        }


        /**
         * 标题
         * <p> 示例值：标题
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 文件所有者
         * <p> 示例值：ou_6e92f20bb8842c89c0f7e4090b13d57a
         *
         * @param ownerId
         * @return
         */
        public Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }


        public FileSearch build() {
            return new FileSearch(this);
        }
    }
}
