// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class OfferEmailInfo {
    /**
     * 邮件发送地址
     * <p> 示例值：no-reply@hire.mail.feishu.cn
     */
    @SerializedName("sender_email")
    private String senderEmail;
    /**
     * 抄送人邮件列表
     * <p> 示例值：
     */
    @SerializedName("cc_email_list")
    private String[] ccEmailList;
    /**
     * 接收人邮件列表
     * <p> 示例值：
     */
    @SerializedName("receiver_email_list")
    private String[] receiverEmailList;
    /**
     * 邮件内容
     * <p> 示例值：This is a test email.
     */
    @SerializedName("content")
    private String content;

    // builder 开始
    public OfferEmailInfo() {
    }

    public OfferEmailInfo(Builder builder) {
        /**
         * 邮件发送地址
         * <p> 示例值：no-reply@hire.mail.feishu.cn
         */
        this.senderEmail = builder.senderEmail;
        /**
         * 抄送人邮件列表
         * <p> 示例值：
         */
        this.ccEmailList = builder.ccEmailList;
        /**
         * 接收人邮件列表
         * <p> 示例值：
         */
        this.receiverEmailList = builder.receiverEmailList;
        /**
         * 邮件内容
         * <p> 示例值：This is a test email.
         */
        this.content = builder.content;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSenderEmail() {
        return this.senderEmail;
    }

    public void setSenderEmail(String senderEmail) {
        this.senderEmail = senderEmail;
    }

    public String[] getCcEmailList() {
        return this.ccEmailList;
    }

    public void setCcEmailList(String[] ccEmailList) {
        this.ccEmailList = ccEmailList;
    }

    public String[] getReceiverEmailList() {
        return this.receiverEmailList;
    }

    public void setReceiverEmailList(String[] receiverEmailList) {
        this.receiverEmailList = receiverEmailList;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static class Builder {
        /**
         * 邮件发送地址
         * <p> 示例值：no-reply@hire.mail.feishu.cn
         */
        private String senderEmail;
        /**
         * 抄送人邮件列表
         * <p> 示例值：
         */
        private String[] ccEmailList;
        /**
         * 接收人邮件列表
         * <p> 示例值：
         */
        private String[] receiverEmailList;
        /**
         * 邮件内容
         * <p> 示例值：This is a test email.
         */
        private String content;

        /**
         * 邮件发送地址
         * <p> 示例值：no-reply@hire.mail.feishu.cn
         *
         * @param senderEmail
         * @return
         */
        public Builder senderEmail(String senderEmail) {
            this.senderEmail = senderEmail;
            return this;
        }


        /**
         * 抄送人邮件列表
         * <p> 示例值：
         *
         * @param ccEmailList
         * @return
         */
        public Builder ccEmailList(String[] ccEmailList) {
            this.ccEmailList = ccEmailList;
            return this;
        }


        /**
         * 接收人邮件列表
         * <p> 示例值：
         *
         * @param receiverEmailList
         * @return
         */
        public Builder receiverEmailList(String[] receiverEmailList) {
            this.receiverEmailList = receiverEmailList;
            return this;
        }


        /**
         * 邮件内容
         * <p> 示例值：This is a test email.
         *
         * @param content
         * @return
         */
        public Builder content(String content) {
            this.content = content;
            return this;
        }


        public OfferEmailInfo build() {
            return new OfferEmailInfo(this);
        }
    }
}
