// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class TalentPool {
    /**
     * 人才库ID
     * <p> 示例值：6930815272790114324
     */
    @SerializedName("id")
    private String id;
    /**
     * 人才库名称
     * <p> 示例值：
     */
    @SerializedName("i18n_name")
    private I18n i18nName;
    /**
     * 人才库描述
     * <p> 示例值：
     */
    @SerializedName("i18n_description")
    private I18n i18nDescription;
    /**
     * 父级人才库ID
     * <p> 示例值：6930815272790114324
     */
    @SerializedName("parent_id")
    private String parentId;
    /**
     * 是否「仅部分用户可见」
     * <p> 示例值：1
     */
    @SerializedName("is_private")
    private Integer isPrivate;
    /**
     * 创建时间，毫秒时间戳
     * <p> 示例值：1679300424000
     */
    @SerializedName("create_time")
    private String createTime;
    /**
     * 修改时间，毫秒时间戳
     * <p> 示例值：1679300424000
     */
    @SerializedName("modify_time")
    private String modifyTime;

    // builder 开始
    public TalentPool() {
    }

    public TalentPool(Builder builder) {
        /**
         * 人才库ID
         * <p> 示例值：6930815272790114324
         */
        this.id = builder.id;
        /**
         * 人才库名称
         * <p> 示例值：
         */
        this.i18nName = builder.i18nName;
        /**
         * 人才库描述
         * <p> 示例值：
         */
        this.i18nDescription = builder.i18nDescription;
        /**
         * 父级人才库ID
         * <p> 示例值：6930815272790114324
         */
        this.parentId = builder.parentId;
        /**
         * 是否「仅部分用户可见」
         * <p> 示例值：1
         */
        this.isPrivate = builder.isPrivate;
        /**
         * 创建时间，毫秒时间戳
         * <p> 示例值：1679300424000
         */
        this.createTime = builder.createTime;
        /**
         * 修改时间，毫秒时间戳
         * <p> 示例值：1679300424000
         */
        this.modifyTime = builder.modifyTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public I18n getI18nName() {
        return this.i18nName;
    }

    public void setI18nName(I18n i18nName) {
        this.i18nName = i18nName;
    }

    public I18n getI18nDescription() {
        return this.i18nDescription;
    }

    public void setI18nDescription(I18n i18nDescription) {
        this.i18nDescription = i18nDescription;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getIsPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(Integer isPrivate) {
        this.isPrivate = isPrivate;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    public static class Builder {
        /**
         * 人才库ID
         * <p> 示例值：6930815272790114324
         */
        private String id;
        /**
         * 人才库名称
         * <p> 示例值：
         */
        private I18n i18nName;
        /**
         * 人才库描述
         * <p> 示例值：
         */
        private I18n i18nDescription;
        /**
         * 父级人才库ID
         * <p> 示例值：6930815272790114324
         */
        private String parentId;
        /**
         * 是否「仅部分用户可见」
         * <p> 示例值：1
         */
        private Integer isPrivate;
        /**
         * 创建时间，毫秒时间戳
         * <p> 示例值：1679300424000
         */
        private String createTime;
        /**
         * 修改时间，毫秒时间戳
         * <p> 示例值：1679300424000
         */
        private String modifyTime;

        /**
         * 人才库ID
         * <p> 示例值：6930815272790114324
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 人才库名称
         * <p> 示例值：
         *
         * @param i18nName
         * @return
         */
        public Builder i18nName(I18n i18nName) {
            this.i18nName = i18nName;
            return this;
        }


        /**
         * 人才库描述
         * <p> 示例值：
         *
         * @param i18nDescription
         * @return
         */
        public Builder i18nDescription(I18n i18nDescription) {
            this.i18nDescription = i18nDescription;
            return this;
        }


        /**
         * 父级人才库ID
         * <p> 示例值：6930815272790114324
         *
         * @param parentId
         * @return
         */
        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }


        /**
         * 是否「仅部分用户可见」
         * <p> 示例值：1
         *
         * @param isPrivate
         * @return
         */
        public Builder isPrivate(Integer isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }


        /**
         * 创建时间，毫秒时间戳
         * <p> 示例值：1679300424000
         *
         * @param createTime
         * @return
         */
        public Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }


        /**
         * 修改时间，毫秒时间戳
         * <p> 示例值：1679300424000
         *
         * @param modifyTime
         * @return
         */
        public Builder modifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }


        public TalentPool build() {
            return new TalentPool(this);
        }
    }
}
