// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.lingo.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.lingo.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SearchEntityReqBody {
    /**
     * 搜索关键词
     * <p> 示例值：飞书词典
     */
    @SerializedName("query")
    private String query;
    /**
     * 分类筛选
     * <p> 示例值：
     */
    @SerializedName("classification_filter")
    private ClassificationFilter classificationFilter;
    /**
     * 词条的创建来源，1：用户主动创建，2：批量导入，3：官方词，4：OpenAPI 创建
     * <p> 示例值：
     */
    @SerializedName("sources")
    private Integer[] sources;
    /**
     * 创建者
     * <p> 示例值：ou_30b07b63089ea46518789914dac63d36
     */
    @SerializedName("creators")
    private String[] creators;

    // builder 开始
    public SearchEntityReqBody() {
    }

    public SearchEntityReqBody(Builder builder) {
        /**
         * 搜索关键词
         * <p> 示例值：飞书词典
         */
        this.query = builder.query;
        /**
         * 分类筛选
         * <p> 示例值：
         */
        this.classificationFilter = builder.classificationFilter;
        /**
         * 词条的创建来源，1：用户主动创建，2：批量导入，3：官方词，4：OpenAPI 创建
         * <p> 示例值：
         */
        this.sources = builder.sources;
        /**
         * 创建者
         * <p> 示例值：ou_30b07b63089ea46518789914dac63d36
         */
        this.creators = builder.creators;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ClassificationFilter getClassificationFilter() {
        return this.classificationFilter;
    }

    public void setClassificationFilter(ClassificationFilter classificationFilter) {
        this.classificationFilter = classificationFilter;
    }

    public Integer[] getSources() {
        return this.sources;
    }

    public void setSources(Integer[] sources) {
        this.sources = sources;
    }

    public String[] getCreators() {
        return this.creators;
    }

    public void setCreators(String[] creators) {
        this.creators = creators;
    }

    public static class Builder {
        /**
         * 搜索关键词
         * <p> 示例值：飞书词典
         */
        private String query;
        /**
         * 分类筛选
         * <p> 示例值：
         */
        private ClassificationFilter classificationFilter;
        /**
         * 词条的创建来源，1：用户主动创建，2：批量导入，3：官方词，4：OpenAPI 创建
         * <p> 示例值：
         */
        private Integer[] sources;
        /**
         * 创建者
         * <p> 示例值：ou_30b07b63089ea46518789914dac63d36
         */
        private String[] creators;

        /**
         * 搜索关键词
         * <p> 示例值：飞书词典
         *
         * @param query
         * @return
         */
        public Builder query(String query) {
            this.query = query;
            return this;
        }


        /**
         * 分类筛选
         * <p> 示例值：
         *
         * @param classificationFilter
         * @return
         */
        public Builder classificationFilter(ClassificationFilter classificationFilter) {
            this.classificationFilter = classificationFilter;
            return this;
        }


        /**
         * 词条的创建来源，1：用户主动创建，2：批量导入，3：官方词，4：OpenAPI 创建
         * <p> 示例值：
         *
         * @param sources
         * @return
         */
        public Builder sources(Integer[] sources) {
            this.sources = sources;
            return this;
        }


        /**
         * 创建者
         * <p> 示例值：ou_30b07b63089ea46518789914dac63d36
         *
         * @param creators
         * @return
         */
        public Builder creators(String[] creators) {
            this.creators = creators;
            return this;
        }


        public SearchEntityReqBody build() {
            return new SearchEntityReqBody(this);
        }
    }
}
