// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.okr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Kr {
    /**
     * KeyResult ID
     * <p> 示例值：
     */
    @SerializedName("id")
    private String id;
    /**
     * KeyResult 在所属 Objective 中的排序
     * <p> 示例值：
     */
    @SerializedName("pos")
    private String pos;
    /**
     * KeyResult 评分，返回值为百分制分数，需要除以 100 以获得 OKR 页面上显示的 1 分制分数
     * <p> 示例值：
     */
    @SerializedName("score")
    private String score;
    /**
     * KeyResult 的权重
     * <p> 示例值：
     */
    @SerializedName("weight")
    private String weight;
    /**
     * KeyResult 对应的 Content 详细内容
     * <p> 示例值：
     */
    @SerializedName("content")
    private KrContent content;
    /**
     * KeyResult 的创建时间 毫秒
     * <p> 示例值：
     */
    @SerializedName("create_time")
    private Integer createTime;
    /**
     * KeyResult 的最后修改时间 毫秒
     * <p> 示例值：
     */
    @SerializedName("modify_time")
    private Integer modifyTime;

    // builder 开始
    public Kr() {
    }

    public Kr(Builder builder) {
        /**
         * KeyResult ID
         * <p> 示例值：
         */
        this.id = builder.id;
        /**
         * KeyResult 在所属 Objective 中的排序
         * <p> 示例值：
         */
        this.pos = builder.pos;
        /**
         * KeyResult 评分，返回值为百分制分数，需要除以 100 以获得 OKR 页面上显示的 1 分制分数
         * <p> 示例值：
         */
        this.score = builder.score;
        /**
         * KeyResult 的权重
         * <p> 示例值：
         */
        this.weight = builder.weight;
        /**
         * KeyResult 对应的 Content 详细内容
         * <p> 示例值：
         */
        this.content = builder.content;
        /**
         * KeyResult 的创建时间 毫秒
         * <p> 示例值：
         */
        this.createTime = builder.createTime;
        /**
         * KeyResult 的最后修改时间 毫秒
         * <p> 示例值：
         */
        this.modifyTime = builder.modifyTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public String getScore() {
        return this.score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public KrContent getContent() {
        return this.content;
    }

    public void setContent(KrContent content) {
        this.content = content;
    }

    public Integer getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Integer createTime) {
        this.createTime = createTime;
    }

    public Integer getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Integer modifyTime) {
        this.modifyTime = modifyTime;
    }

    public static class Builder {
        /**
         * KeyResult ID
         * <p> 示例值：
         */
        private String id;
        /**
         * KeyResult 在所属 Objective 中的排序
         * <p> 示例值：
         */
        private String pos;
        /**
         * KeyResult 评分，返回值为百分制分数，需要除以 100 以获得 OKR 页面上显示的 1 分制分数
         * <p> 示例值：
         */
        private String score;
        /**
         * KeyResult 的权重
         * <p> 示例值：
         */
        private String weight;
        /**
         * KeyResult 对应的 Content 详细内容
         * <p> 示例值：
         */
        private KrContent content;
        /**
         * KeyResult 的创建时间 毫秒
         * <p> 示例值：
         */
        private Integer createTime;
        /**
         * KeyResult 的最后修改时间 毫秒
         * <p> 示例值：
         */
        private Integer modifyTime;

        /**
         * KeyResult ID
         * <p> 示例值：
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * KeyResult 在所属 Objective 中的排序
         * <p> 示例值：
         *
         * @param pos
         * @return
         */
        public Builder pos(String pos) {
            this.pos = pos;
            return this;
        }


        /**
         * KeyResult 评分，返回值为百分制分数，需要除以 100 以获得 OKR 页面上显示的 1 分制分数
         * <p> 示例值：
         *
         * @param score
         * @return
         */
        public Builder score(String score) {
            this.score = score;
            return this;
        }


        /**
         * KeyResult 的权重
         * <p> 示例值：
         *
         * @param weight
         * @return
         */
        public Builder weight(String weight) {
            this.weight = weight;
            return this;
        }


        /**
         * KeyResult 对应的 Content 详细内容
         * <p> 示例值：
         *
         * @param content
         * @return
         */
        public Builder content(KrContent content) {
            this.content = content;
            return this;
        }


        /**
         * KeyResult 的创建时间 毫秒
         * <p> 示例值：
         *
         * @param createTime
         * @return
         */
        public Builder createTime(Integer createTime) {
            this.createTime = createTime;
            return this;
        }


        /**
         * KeyResult 的最后修改时间 毫秒
         * <p> 示例值：
         *
         * @param modifyTime
         * @return
         */
        public Builder modifyTime(Integer modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }


        public Kr build() {
            return new Kr(this);
        }
    }
}
