/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.async;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ClientOptions;
import com.openai.core.JsonValue;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.http.HttpClient;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.FileDeleteParams;
import com.openai.models.FileDeleted;
import com.openai.models.FileListPageAsync;
import com.openai.models.FileListParams;
import com.openai.models.FileObject;
import com.openai.models.FileRetrieveParams;
import com.openai.services.async.FileServiceAsync;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/openai/services/async/FileServiceAsyncImpl;", "Lcom/openai/services/async/FileServiceAsync;", "clientOptions", "Lcom/openai/core/ClientOptions;", "(Lcom/openai/core/ClientOptions;)V", "deleteHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/models/FileDeleted;", "errorHandler", "Lcom/openai/errors/OpenAIError;", "listHandler", "Lcom/openai/models/FileListPageAsync$Response;", "retrieveHandler", "Lcom/openai/models/FileObject;", "delete", "Ljava/util/concurrent/CompletableFuture;", "params", "Lcom/openai/models/FileDeleteParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "list", "Lcom/openai/models/FileListPageAsync;", "Lcom/openai/models/FileListParams;", "retrieve", "Lcom/openai/models/FileRetrieveParams;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nFileServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileServiceAsyncImpl.kt\ncom/openai/services/async/FileServiceAsyncImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n13#2,9:116\n13#2,9:125\n13#2,9:134\n1#3:143\n*S KotlinDebug\n*F\n+ 1 FileServiceAsyncImpl.kt\ncom/openai/services/async/FileServiceAsyncImpl\n*L\n32#1:116,9\n59#1:125,9\n88#1:134,9\n*E\n"})
public final class FileServiceAsyncImpl
implements FileServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<FileObject> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<FileListPageAsync.Response> listHandler;
    @NotNull
    private final HttpResponse.Handler<FileDeleted> deleteHandler;

    public FileServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileObject>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileObject handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileObject>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileListPageAsync.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileListPageAsync.Response handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileListPageAsync.Response>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileDeleted>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileDeleted handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileDeleted>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    @Override
    @NotNull
    public CompletableFuture<FileObject> retrieve(@NotNull FileRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files", params.getPathParam(0)};
        CompletableFuture request2 = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request2.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.retrieve$lambda$0((Function1)new Function1<HttpRequest, CompletionStage<HttpResponse>>(this, requestOptions){
            final /* synthetic */ FileServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            public final CompletionStage<HttpResponse> invoke(HttpRequest it) {
                HttpClient httpClient = FileServiceAsyncImpl.access$getClientOptions$p(this.this$0).httpClient();
                Intrinsics.checkNotNull((Object)it);
                return httpClient.executeAsync(it, this.$requestOptions);
            }
        }, arg_0))).thenApply(arg_0 -> FileServiceAsyncImpl.retrieve$lambda$1((Function1)new Function1<HttpResponse, FileObject>(this, requestOptions){
            final /* synthetic */ FileServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final FileObject invoke(HttpResponse response) {
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    Object it = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = FileServiceAsyncImpl.access$getRetrieveHandler$p((FileServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it);
                    it = (FileObject)handler.handle((HttpResponse)it);
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                }
                object = it;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : FileServiceAsyncImpl.access$getClientOptions$p((FileServiceAsyncImpl)object3).responseValidation()) {
                    ((FileObject)$this$invoke_u24lambda_u241).validate();
                }
                return object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FileListPageAsync> list(@NotNull FileListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files"};
        CompletableFuture request2 = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request2.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.list$lambda$2((Function1)new Function1<HttpRequest, CompletionStage<HttpResponse>>(this, requestOptions){
            final /* synthetic */ FileServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            public final CompletionStage<HttpResponse> invoke(HttpRequest it) {
                HttpClient httpClient = FileServiceAsyncImpl.access$getClientOptions$p(this.this$0).httpClient();
                Intrinsics.checkNotNull((Object)it);
                return httpClient.executeAsync(it, this.$requestOptions);
            }
        }, arg_0))).thenApply(arg_0 -> FileServiceAsyncImpl.list$lambda$3((Function1)new Function1<HttpResponse, FileListPageAsync>(this, requestOptions, params){
            final /* synthetic */ FileServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            final /* synthetic */ FileListParams $params;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                this.$params = $params;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final FileListPageAsync invoke(HttpResponse response) {
                Object it2;
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    it2 = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = FileServiceAsyncImpl.access$getListHandler$p((FileServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it2);
                    it2 = (FileListPageAsync.Response)handler.handle((HttpResponse)it2);
                }
                catch (Throwable it2) {
                    object3 = it2;
                    throw it2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                }
                object = it2;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : FileServiceAsyncImpl.access$getClientOptions$p((FileServiceAsyncImpl)object3).responseValidation()) {
                    ((FileListPageAsync.Response)$this$invoke_u24lambda_u241).validate();
                }
                object2 = this.this$0;
                object3 = this.$params;
                it2 = object;
                boolean bl3 = false;
                return FileListPageAsync.Companion.of((FileServiceAsync)object2, (FileListParams)object3, (FileListPageAsync.Response)it2);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FileDeleted> delete(@NotNull FileDeleteParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"files", params.getPathParam(0)};
        Object $this$delete_u24lambda_u245 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
        boolean bl = false;
        params._body$openai_java_core().ifPresent(arg_0 -> FileServiceAsyncImpl.delete$lambda$5$lambda$4((Function1)new Function1<Map<String, ? extends JsonValue>, Unit>((HttpRequest.Builder)$this$delete_u24lambda_u245, this){
            final /* synthetic */ HttpRequest.Builder $this_apply;
            final /* synthetic */ FileServiceAsyncImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Map<String, ? extends JsonValue> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsonMapper jsonMapper$iv = FileServiceAsyncImpl.access$getClientOptions$p(this.this$0).jsonMapper();
                boolean $i$f$json = false;
                this.$this_apply.body(new HttpRequestBody(jsonMapper$iv, it){
                    @Nullable
                    private byte[] cachedBytes;
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ T $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                    }

                    private final byte[] serialize() {
                        if (this.cachedBytes != null) {
                            Intrinsics.checkNotNull((Object)this.cachedBytes);
                            return this.cachedBytes;
                        }
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        try {
                            this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                            this.cachedBytes = buffer.toByteArray();
                            Intrinsics.checkNotNull((Object)this.cachedBytes);
                            return this.cachedBytes;
                        }
                        catch (Exception e) {
                            throw new OpenAIException("Error writing request", e);
                        }
                    }

                    public void writeTo(@NotNull OutputStream outputStream) {
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        outputStream.write(this.serialize());
                    }

                    @NotNull
                    public String contentType() {
                        return "application/json";
                    }

                    public long contentLength() {
                        return this.serialize().length;
                    }

                    public boolean repeatable() {
                        return true;
                    }

                    public void close() {
                    }
                });
            }
        }, arg_0));
        CompletableFuture request2 = PrepareRequest.prepareAsync(((HttpRequest.Builder)object).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request2.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.delete$lambda$6((Function1)new Function1<HttpRequest, CompletionStage<HttpResponse>>(this, requestOptions){
            final /* synthetic */ FileServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            public final CompletionStage<HttpResponse> invoke(HttpRequest it) {
                HttpClient httpClient = FileServiceAsyncImpl.access$getClientOptions$p(this.this$0).httpClient();
                Intrinsics.checkNotNull((Object)it);
                return httpClient.executeAsync(it, this.$requestOptions);
            }
        }, arg_0))).thenApply(arg_0 -> FileServiceAsyncImpl.delete$lambda$7((Function1)new Function1<HttpResponse, FileDeleted>(this, requestOptions){
            final /* synthetic */ FileServiceAsyncImpl this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final FileDeleted invoke(HttpResponse response) {
                Object object = response;
                Object object2 = this.this$0;
                Object object3 = null;
                try {
                    Object it = (HttpResponse)object;
                    boolean bl = false;
                    HttpResponse.Handler handler = FileServiceAsyncImpl.access$getDeleteHandler$p((FileServiceAsyncImpl)object2);
                    Intrinsics.checkNotNull((Object)it);
                    it = (FileDeleted)handler.handle((HttpResponse)it);
                }
                catch (Throwable it) {
                    object3 = it;
                    throw it;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                }
                object = it;
                object2 = this.$requestOptions;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                if (bl2 != null ? bl2.booleanValue() : FileServiceAsyncImpl.access$getClientOptions$p((FileServiceAsyncImpl)object3).responseValidation()) {
                    ((FileDeleted)$this$invoke_u24lambda_u241).validate();
                }
                return object;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final CompletionStage retrieve$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final FileObject retrieve$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileObject)$tmp0.invoke(p0);
    }

    private static final CompletionStage list$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final FileListPageAsync list$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileListPageAsync)$tmp0.invoke(p0);
    }

    private static final void delete$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final CompletionStage delete$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final FileDeleted delete$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileDeleted)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(FileServiceAsyncImpl $this) {
        return $this.clientOptions;
    }

    public static final /* synthetic */ HttpResponse.Handler access$getRetrieveHandler$p(FileServiceAsyncImpl $this) {
        return $this.retrieveHandler;
    }

    public static final /* synthetic */ HttpResponse.Handler access$getListHandler$p(FileServiceAsyncImpl $this) {
        return $this.listHandler;
    }

    public static final /* synthetic */ HttpResponse.Handler access$getDeleteHandler$p(FileServiceAsyncImpl $this) {
        return $this.deleteHandler;
    }
}

