/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcRequest;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;

public class Proxy
implements Runnable {
    private ProxyConfig proxyConfig;
    private final Map<String, ClientContext> contexts = new HashMap<String, ClientContext>();
    private final Map<String, Long> subscriptions = new HashMap<String, Long>();
    private long subscriptionId = 0L;
    private ONS ons;
    private Publisher publisher;
    private static final String TENANT_ID_PROPERTY_NAME = "tenant_id";
    private static final String ONS_PROXY = "ONSProxy";
    private static final String ORACLE_CONFIG_HOME = "ORACLE_CONFIG_HOME";
    private static final String ORACLE_HOME = "ORACLE_HOME";
    private static final String ProxyHomeErr = "ORACLE_HOME must be set";
    private static final String ProxyUsage = "Usage: Proxy [<config-file>]";
    private static final Logger logger = Logger.getLogger(Proxy.class.getName());
    private ConsoleHandler consoleHandler;
    private FileHandler fileHandler;
    private File logPath;
    private final SimpleDateFormat stampFormatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final int LogFileSize = 0x1400000;
    private static final int LogFileNumber = 10;
    private String oracleHome;
    private String configPath;
    private String onsctliPath;
    private boolean newConfigFile = false;
    private boolean needSubWaits = false;
    private volatile List<ONSConfiguration> netConfigs = new ArrayList<ONSConfiguration>();
    private RpcServer rpcServer;
    private Date proxyStart = null;
    private Date lastReloadSuccess = null;
    private Date lastReloadFail = null;
    private Date lastPingSuccess = null;
    private Date lastPingFail = null;
    private volatile RpcRequest reloadRequest = null;
    private volatile RpcRequest debugRequest = null;
    private volatile boolean proxyRun = true;
    private volatile boolean notified = false;
    private Object lock = new Object();
    private Object confLock = new Object();
    private Object requestLock = new Object();

    public static void main(String[] args) {
        String configFile = null;
        if (args.length == 0) {
            configFile = Proxy.setDefaultConfigFile();
        } else if (args.length == 1) {
            configFile = args[0];
        } else {
            throw new RuntimeException(ProxyUsage);
        }
        new Proxy(configFile).run();
    }

    private static String setDefaultConfigFile() {
        String configFile = null;
        String home = System.getenv(ORACLE_CONFIG_HOME);
        if (home != null) {
            configFile = Proxy.checkDefaultConfigFile(home);
        }
        if (configFile == null) {
            home = System.getenv(ORACLE_HOME);
            if (home == null) {
                throw new RuntimeException(ProxyHomeErr);
            }
            configFile = Proxy.checkDefaultConfigFile(home);
            if (configFile == null) {
                throw new RuntimeException("No default configuration file -- Usage: Proxy [<config-file>]");
            }
        }
        return configFile;
    }

    private static String checkDefaultConfigFile(String home) {
        String fileName = home + File.separatorChar + "opmn" + File.separatorChar + "conf" + File.separatorChar + "onsproxy.properties";
        File path = new File(fileName);
        if (path.exists() && path.isFile()) {
            return fileName;
        }
        return null;
    }

    public Proxy(String configPath) {
        this.configPath = configPath;
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(this.consoleHandler);
        logger.setUseParentHandlers(false);
        this.oracleHome = System.getenv(ORACLE_HOME);
        if (this.oracleHome == null) {
            throw new RuntimeException(ProxyHomeErr);
        }
        this.proxyConfig = new ProxyConfig(configPath);
        this.setDefaultConfigHome();
        this.setOnsctli();
        this.validateProxyConfig(this.proxyConfig);
        this.checkOnsRunning();
        if (this.proxyConfig.debugLog) {
            this.setDebugLog();
        }
        this.updateProxyConfig(this.proxyConfig);
    }

    private void setDefaultConfigHome() {
        String home = this.proxyConfig.configHome;
        if (home == null && (home = System.getenv(ORACLE_CONFIG_HOME)) == null) {
            home = this.oracleHome;
            logger.log(Level.WARNING, "ORACLE_CONFIG_HOME is not set or configured -- using ORACLE_HOME");
        }
        logger.log(Level.INFO, "ORACLE_CONFIG_HOME set to " + home);
        File path = new File(home);
        if (path.exists() && path.isDirectory()) {
            this.proxyConfig.configHome = home;
            path = this.buildPath(home, "opmn", "logs");
            if (!path.exists()) {
                try {
                    path.mkdir();
                }
                catch (SecurityException ex) {
                    throw new RuntimeException(path.getAbsolutePath() + ": failed to create log directory -- invalid " + ORACLE_CONFIG_HOME);
                }
            }
            if (!path.isDirectory()) {
                throw new RuntimeException(path.getAbsolutePath() + ": is not a directory -- invalid " + ORACLE_CONFIG_HOME);
            }
        } else {
            throw new RuntimeException("ORACLE_CONFIG_HOME: " + home + ": does not exist or is not a directory");
        }
        this.logPath = path;
    }

    private void setOnsctli() {
        this.onsctliPath = this.buildOnsctli(this.proxyConfig.configHome);
        if (this.onsctliPath == null) {
            this.onsctliPath = this.buildOnsctli(this.oracleHome);
            if (this.onsctliPath == null) {
                throw new RuntimeException(this.onsctliPath + ": script does not exist -- invalid " + ORACLE_CONFIG_HOME + ": " + this.proxyConfig.configHome + " or invalid " + ORACLE_HOME + ": " + this.oracleHome);
            }
            logger.log(Level.FINE, "onsctli set to " + this.onsctliPath);
        }
    }

    private String buildOnsctli(String home) {
        File sFile;
        String path = null;
        String scriptName = "onsctli";
        if (File.separatorChar == '\\') {
            scriptName = scriptName + ".bat";
        }
        if ((sFile = this.buildPath(home, "opmn", "bin", scriptName)).exists() && sFile.isFile()) {
            path = sFile.getAbsolutePath();
        }
        return path;
    }

    private void validateProxyConfig(ProxyConfig newConfig) throws RuntimeException {
        if (newConfig.configHome != null && !newConfig.configHome.equals(this.proxyConfig.configHome)) {
            throw new RuntimeException("ConfigHome cannot be changed via dynamic reload: current=" + this.proxyConfig.configHome + " -- new=" + newConfig.configHome);
        }
        logger.log(Level.INFO, "Validating configuration");
        this.validateOnsConfig(newConfig);
    }

    private void validateOnsConfig(ProxyConfig newConfig) throws RuntimeException {
        String newPort;
        if (newConfig.configFile.isEmpty()) {
            throw new RuntimeException(newConfig.configPath + ": no ONS server configuration");
        }
        if (!newConfig.configFile.containsKey("localport") || !newConfig.configFile.containsKey("remoteport")) {
            throw new RuntimeException(newConfig.configPath + ": ONS server configuration must include 'localport' and 'remoteport'");
        }
        String oldPort = this.proxyConfig.configFile.get("localport");
        if (!oldPort.equals(newPort = newConfig.configFile.get("localport"))) {
            throw new RuntimeException(newConfig.configPath + ": ONS server configuration: 'localport' cannot not be changed dynamically (" + oldPort + "==>" + newPort + ")");
        }
        File stampFile = this.buildStampedConfigPath();
        try {
            this.createConfigFile(stampFile, newConfig);
        }
        catch (Exception ex) {
            stampFile.delete();
            throw new RuntimeException(stampFile.getAbsolutePath() + ": failed to create ONS configuration file: " + ex);
        }
        int status = 2;
        try {
            status = this.runOnsctli(true, "validate", stampFile.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new RuntimeException(newConfig.configPath + ": failed to validate ONS configuration: " + ex);
        }
        finally {
            stampFile.delete();
        }
        if (status != 0) {
            throw new RuntimeException(newConfig.configPath + ": ONS configuration validation failed");
        }
    }

    private int pingOnsServer(boolean healthCheck) {
        int status = 2;
        try {
            status = this.runOnsctli(!healthCheck, "ping");
        }
        catch (Exception ex) {
            status = 2;
        }
        if (healthCheck) {
            if (status == 0) {
                this.lastPingSuccess = new Date();
            } else {
                this.lastPingFail = new Date();
            }
        }
        return status;
    }

    private void checkOnsRunning() {
        int status = this.pingOnsServer(false);
        if (status == 0) {
            try {
                status = this.runOnsctli(true, "proxy", "ping");
            }
            catch (Exception ex) {
                status = 2;
            }
            if (status == 0) {
                throw new RuntimeException("ONS proxy is already running for " + this.proxyConfig.configHome);
            }
            logger.log(Level.WARNING, "ONS server is already running for " + this.proxyConfig.configHome + " -- attempting to stop...");
            try {
                status = this.runOnsctli(true, "shutdown");
            }
            catch (Exception ex) {
                status = 2;
            }
            if (status != 0) {
                throw new RuntimeException("Failed to stop ONS server for " + this.proxyConfig.configHome);
            }
            logger.log(Level.INFO, "ONS server stopped");
        }
    }

    private void updateProxyConfig(ProxyConfig newConfig) {
        logger.log(Level.INFO, "Updating configuration");
        if (this.proxyConfig.debugLog != newConfig.debugLog) {
            logger.log(Level.FINE, newConfig.configPath + ": updating debug");
            if (newConfig.debugLog) {
                this.setDebugLog();
            } else {
                this.clearDebugLog();
            }
        }
        this.updateSubscriptions(newConfig.subscriptions);
        this.updateContexts(newConfig.internalConfigs, newConfig.runtimeNetworkSubscription);
        this.updateRuntimeNetworkSub(newConfig.runtimeNetworkSubscription);
        this.updateConfigFile(newConfig.configFile);
    }

    private void updateSubscriptions(List<String> newSubs) {
        logger.log(Level.FINE, "Updating subscriptions");
        logger.log(Level.FINER, "Checking for removed subscriptions");
        Iterator<Map.Entry<String, Long>> it = this.subscriptions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            if (newSubs.contains(entry.getKey())) continue;
            this.contextsRemoveSubscription(entry.getValue());
            it.remove();
        }
        logger.log(Level.FINER, "Checking for new subscriptions");
        for (String sString : newSubs) {
            if (this.subscriptions.containsKey(sString)) continue;
            ++this.subscriptionId;
            this.subscriptions.put(sString, this.subscriptionId);
        }
    }

    private void updateContexts(Map<String, ONSConfiguration> newConfigs, String rtNetSub) {
        logger.log(Level.FINE, "Updating networks");
        logger.log(Level.FINER, "Checking for removed networks");
        Iterator<Map.Entry<String, ClientContext>> it = this.contexts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ClientContext> entry = it.next();
            String key = entry.getKey();
            if (newConfigs.containsKey(key)) continue;
            ClientContext context = entry.getValue();
            if (context.discovered && !rtNetSub.isEmpty() && this.proxyConfig.runtimeNetworkSubscription.equals(rtNetSub)) continue;
            context.close();
            it.remove();
        }
        logger.log(Level.FINER, "Checking for new networks");
        for (Map.Entry<String, ONSConfiguration> entry : newConfigs.entrySet()) {
            String key = entry.getKey();
            if (this.contexts.containsKey(key)) continue;
            this.contexts.put(key, new ClientContext(entry.getValue(), false));
        }
    }

    private void updateRuntimeNetworkSub(String rtNetSub) {
        if (!this.proxyConfig.runtimeNetworkSubscription.equals(rtNetSub)) {
            logger.log(Level.FINE, "Updating run time network subscription");
            this.proxyConfig.runtimeNetworkSubscription = rtNetSub;
            for (Map.Entry<String, ClientContext> cEntry : this.contexts.entrySet()) {
                ClientContext context = cEntry.getValue();
                context.addRtNetSubcriber(rtNetSub);
            }
        }
    }

    private void updateConfigFile(Map<String, String> newFile) {
        if (!this.proxyConfig.configFile.equals(newFile)) {
            logger.log(Level.FINE, "Updating ONS server config file");
            this.newConfigFile = true;
            this.proxyConfig.configFile.clear();
            for (Map.Entry<String, String> entry : newFile.entrySet()) {
                this.proxyConfig.configFile.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.newConfigFile = false;
        }
    }

    private void contextsRemoveSubscription(long sId) {
        for (Map.Entry<String, ClientContext> entry : this.contexts.entrySet()) {
            ClientContext context = entry.getValue();
            context.removeSubscriber(sId);
        }
    }

    private void contextsAddSubscriptions() {
        for (Map.Entry<String, ClientContext> cEntry : this.contexts.entrySet()) {
            ClientContext context = cEntry.getValue();
            if (!this.proxyConfig.runtimeNetworkSubscription.isEmpty()) {
                context.addRtNetSubcriber(this.proxyConfig.runtimeNetworkSubscription);
            }
            for (Map.Entry<String, Long> sEntry : this.subscriptions.entrySet()) {
                String subscription = sEntry.getKey();
                long sId = sEntry.getValue();
                context.addSubscriber(sId, subscription);
            }
        }
        this.contextsWaitSubscriptions();
    }

    private void contextsWaitSubscriptions() {
        this.needSubWaits = false;
        for (Map.Entry<String, ClientContext> cEntry : this.contexts.entrySet()) {
            ClientContext context = cEntry.getValue();
            if (context.waitSubscriber(0L, this.proxyConfig.runtimeNetworkSubscription)) {
                this.needSubWaits = true;
            }
            for (Map.Entry<String, Long> sEntry : this.subscriptions.entrySet()) {
                long sId = sEntry.getValue();
                boolean needWait = context.waitSubscriber(sId, sEntry.getKey());
                if (!needWait) continue;
                this.needSubWaits = true;
            }
        }
    }

    private void setDebugLog() {
        logger.setLevel(Level.FINEST);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(Level.FINEST);
        }
    }

    private void clearDebugLog() {
        logger.setLevel(Level.INFO);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(Level.INFO);
        }
    }

    private void cleanup() {
        logger.log(Level.FINE, "Closing networks");
        for (Map.Entry<String, ClientContext> cEntry : this.contexts.entrySet()) {
            ClientContext context = cEntry.getValue();
            context.close();
        }
        logger.log(Level.FINE, "Shutting down ONS server");
        int status = 2;
        try {
            status = this.runOnsctli(true, "shutdown");
        }
        catch (Exception ex) {
            status = 2;
        }
        if (status != 0) {
            logger.log(Level.SEVERE, "Failed to shutdown ONS server for " + this.proxyConfig.configHome);
        }
        logger.log(Level.FINE, "Closing ONS client");
        this.publisher.close();
        this.ons.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runOnsctli(boolean logCmd, String ... arguments) {
        String cmdLine = "";
        ArrayList<String> args = new ArrayList<String>();
        if (File.separatorChar == '\\') {
            args.add("cmd.exe");
            args.add("/c");
            cmdLine = cmdLine + "cmd.exe /c ";
        }
        args.add(this.onsctliPath);
        cmdLine = cmdLine + this.onsctliPath;
        if (!logCmd) {
            args.add("quiet");
            cmdLine = cmdLine + " quiet";
        }
        for (String arg : arguments) {
            args.add(arg);
            cmdLine = cmdLine + " " + arg;
        }
        logger.log(Level.FINEST, "Invoking: " + cmdLine);
        ProcessBuilder pb = new ProcessBuilder(args);
        File outFile = new File(this.logPath, "proxy_ons.out");
        pb.redirectError(ProcessBuilder.Redirect.appendTo(outFile));
        pb.redirectOutput(ProcessBuilder.Redirect.appendTo(outFile));
        pb.environment().put(ORACLE_CONFIG_HOME, this.proxyConfig.configHome);
        if (logCmd) {
            FileWriter stampWriter = null;
            try {
                stampWriter = new FileWriter(outFile, true);
                String stamp = this.getDateStamp(new Date());
                stampWriter.write(stamp + ": " + cmdLine + "\n");
                stampWriter.flush();
            }
            catch (Exception ex) {
                ex.getMessage();
            }
            finally {
                if (stampWriter != null) {
                    try {
                        stampWriter.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        int returnCode = 2;
        try {
            returnCode = pb.start().waitFor();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return returnCode;
    }

    private void createServerConfigFile() throws RuntimeException {
        logger.log(Level.FINE, "Creating ONS server configuration file");
        File onsConfig = this.buildOnsConfigPath();
        try {
            this.createConfigFile(onsConfig, this.proxyConfig);
        }
        catch (Exception ex) {
            throw new RuntimeException(onsConfig.getAbsolutePath() + ": failed to create ONS configuration file: " + ex);
        }
    }

    private void putConfigFile(ProxyConfig config, String name, String value) {
        if (!config.configFile.containsKey(name)) {
            config.configFile.put(name, value);
        }
    }

    private void createConfigFile(File cf, ProxyConfig config) throws IOException {
        this.putConfigFile(config, "extendedsecuritymode", "strict");
        this.putConfigFile(config, "extendedsecurityheader", TENANT_ID_PROPERTY_NAME);
        this.putConfigFile(config, "allowunsecuresubscriber", "false");
        this.putConfigFile(config, "allowpublish", "127.0.0.1,::1");
        try (FileOutputStream f = new FileOutputStream(cf);){
            f.write("# Generated by ONS Proxy\n".getBytes());
            f.write(this.buildConfigFile(new StringBuilder(), config).toString().getBytes());
        }
    }

    private StringBuilder buildConfigFile(StringBuilder w, ProxyConfig config) {
        for (Map.Entry<String, String> entry : config.configFile.entrySet()) {
            w.append(entry.getKey().toLowerCase()).append("=").append(entry.getValue()).append('\n');
        }
        return w;
    }

    private File buildStampedConfigPath() {
        File confFile = this.buildOnsConfigPath();
        String confBase = confFile.getAbsolutePath() + "." + String.valueOf(System.currentTimeMillis());
        int version = 0;
        confFile = new File(confBase);
        while (confFile.exists()) {
            String confName = confBase = confBase + "." + String.valueOf(version);
            ++version;
            confFile = new File(confName);
        }
        return confFile;
    }

    private File buildOnsConfigPath() {
        String configFileName = "ons.config";
        if (this.proxyConfig.configFile.containsKey("usesharedinstall") && this.proxyConfig.configFile.get("usesharedinstall").equals("true")) {
            configFileName = configFileName + "." + ONSConfiguration.getHostname();
        }
        return this.buildPath(this.proxyConfig.configHome, "opmn", "conf", configFileName);
    }

    private File buildPath(String base, String ... path) {
        File result = new File(base);
        for (String x : path) {
            result = new File(result, x);
        }
        return result;
    }

    private void initProxy() {
        ONSConfiguration localConfig;
        logger.log(Level.INFO, "Initializing");
        this.createServerConfigFile();
        logger.log(Level.FINE, "Starting ONS server");
        int status = 2;
        try {
            status = this.runOnsctli(true, "start");
        }
        catch (Exception ex) {
            status = 2;
        }
        if (status != 0) {
            this.lastPingFail = new Date();
            throw new RuntimeException("Failed to start ONS server for " + this.proxyConfig.configHome);
        }
        this.lastPingSuccess = new Date();
        logger.log(Level.FINE, "Creating client for ONS server");
        try {
            localConfig = ONSConfiguration.getLocalConfigFromFile(this.proxyConfig.configHome, null, null);
        }
        catch (ONSException ex) {
            throw new RuntimeException("Failed to initialize ONS client for " + this.proxyConfig.configHome);
        }
        this.ons = new ONS(localConfig);
        this.publisher = new Publisher(this.ons.config, "public");
        logger.log(Level.FINE, "Adding network subscribers");
        this.contextsAddSubscriptions();
        if (!this.proxyConfig.runtimeNetworkSubscription.isEmpty()) {
            String rtNetSub = this.proxyConfig.runtimeNetworkSubscription;
            this.proxyConfig.runtimeNetworkSubscription = "";
            this.updateRuntimeNetworkSub(rtNetSub);
        }
        logger.log(Level.FINE, "Initializing RPC");
        this.initRPC();
        String logFile = this.logPath.getAbsolutePath() + File.separatorChar + "proxy.log";
        logger.log(Level.FINE, "Setting log directory: " + this.logPath.getAbsolutePath());
        try {
            this.fileHandler = new FileHandler(logFile, 0x1400000, 10, true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize log file: " + ex);
        }
        this.fileHandler.setFormatter(new SimpleFormatter());
        if (this.proxyConfig.debugLog) {
            this.fileHandler.setLevel(Level.FINEST);
        }
        logger.removeHandler(this.consoleHandler);
        logger.addHandler(this.fileHandler);
        logger.setUseParentHandlers(false);
        this.consoleHandler.close();
        this.consoleHandler = null;
        logger.log(Level.INFO, "Proxy starting. Build: ONS_21.0.0.0.0_LINUX.X64_210527.1 2021/6/29 9:11:21 UTC");
    }

    private void initRPC() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ONS_PROXY, "proxy");
        this.rpcServer = this.ons.createRpcServer("ONSProxyServer", ONS_PROXY, props, CallBackMode.SERIAL, true);
        this.rpcServer.addRequestListener("ping", new PingRequest());
        this.rpcServer.addRequestListener("shutdown", new ShutdownRequest());
        this.rpcServer.addRequestListener("debug", new DebugRequest());
        this.rpcServer.addRequestListener("reload", new ReloadRequest());
        try {
            this.rpcServer.launch();
        }
        catch (RpcServerException ex) {
            throw new RuntimeException("Failed to start RPC server: " + ex);
        }
    }

    private void proxyReload() {
        ProxyConfig newConfig;
        String logMsg = "Reloading configuration";
        logger.log(Level.INFO, logMsg);
        this.rpcReply(this.reloadRequest, logMsg);
        try {
            newConfig = new ProxyConfig(this.configPath);
            this.rpcReply(this.reloadRequest, "Validating configuration");
            this.validateProxyConfig(newConfig);
        }
        catch (RuntimeException ex) {
            String errMsg = "Configuration validation failed -- reload aborted: " + ex.getMessage();
            logger.log(Level.SEVERE, errMsg);
            this.lastReloadFail = new Date();
            this.rpcReply(this.reloadRequest, errMsg, true, false);
            return;
        }
        this.rpcReply(this.reloadRequest, "Updating configuration");
        this.updateProxyConfig(newConfig);
        this.contextsAddSubscriptions();
        if (this.newConfigFile) {
            String errMsg;
            logMsg = "Updating ONS server configuration";
            logger.log(Level.FINE, logMsg);
            this.rpcReply(this.reloadRequest, logMsg);
            this.newConfigFile = false;
            File stampFile = null;
            File origFile = this.buildOnsConfigPath();
            if (origFile.exists()) {
                stampFile = this.buildStampedConfigPath();
                logger.log(Level.FINE, "Renaming existing ONS server configuration file: " + stampFile.getAbsolutePath());
                try {
                    origFile.renameTo(stampFile);
                }
                catch (Exception ex) {
                    errMsg = "Failed to rename ONS configuration file (" + origFile.getAbsolutePath() + " to " + stampFile.getAbsolutePath() + "): " + ex.getMessage();
                    logger.log(Level.SEVERE, errMsg);
                    this.lastReloadFail = new Date();
                    this.rpcReply(this.reloadRequest, errMsg, true, false);
                }
            }
            logger.log(Level.FINE, "Creating ONS server configuration file: " + origFile.getAbsolutePath());
            try {
                this.createServerConfigFile();
            }
            catch (RuntimeException ex) {
                errMsg = "Failed to update the ONS configuration file (" + origFile.getAbsolutePath() + "): " + ex.getMessage();
                logger.log(Level.SEVERE, errMsg);
                this.lastReloadFail = new Date();
                this.rpcReply(this.reloadRequest, errMsg, true, false);
                if (stampFile != null) {
                    try {
                        stampFile.renameTo(origFile);
                    }
                    catch (Exception exp) {
                        logger.log(Level.SEVERE, "Failed to restore the ONS configuration file (" + origFile.getAbsolutePath() + "): " + exp.getMessage());
                    }
                }
                return;
            }
            logger.log(Level.FINE, "Reloading the ONS server");
            this.rpcReply(this.reloadRequest, "Reloading ONS server", true, true);
            this.proxySleep(100);
            int status = 2;
            try {
                status = this.runOnsctli(true, "reload");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to reload ONS server for " + this.proxyConfig.configHome + " : " + ex.getMessage());
                this.lastReloadFail = new Date();
                status = 2;
            }
            if (status != 0) {
                this.lastReloadFail = this.lastPingFail = new Date();
                logger.log(Level.SEVERE, "Failed to reload ONS server for " + this.proxyConfig.configHome);
            } else {
                this.lastReloadSuccess = this.lastPingSuccess = new Date();
            }
        } else {
            this.rpcReply(this.reloadRequest, "Reload succeeded", true, true);
            this.lastReloadSuccess = new Date();
        }
    }

    private void proxyDebug() {
        byte[] argBytes = this.debugRequest.getArgBytes();
        this.rpcReply(this.debugRequest, "ONS Proxy ONS_21.0.0.0.0_LINUX.X64_210527.1 2021/6/29 9:11:21 UTC\n\nRequest time: " + this.getDateStamp(new Date()));
        this.rpcReply(this.debugRequest, "\nProxy start: " + this.getDateStamp(this.proxyStart) + "\nLast successful proxy reload: " + this.getDateStamp(this.lastReloadSuccess) + "\nLast failed proxy reload: " + this.getDateStamp(this.lastReloadFail));
        int count = 0;
        this.rpcReply(this.debugRequest, "\nSubscriptions:");
        if (!this.proxyConfig.runtimeNetworkSubscription.isEmpty()) {
            ++count;
            this.rpcReply(this.debugRequest, "  0  " + this.proxyConfig.runtimeNetworkSubscription);
        }
        for (Map.Entry<String, Long> sEntry : this.subscriptions.entrySet()) {
            ++count;
            String subscription = sEntry.getKey();
            long sId = sEntry.getValue();
            this.rpcReply(this.debugRequest, "  " + sId + "  " + subscription);
        }
        this.rpcReply(this.debugRequest, "Total number of subscriptions: " + count);
        this.rpcReply(this.debugRequest, "\nNetwork Contexts:");
        int rTotal = 0;
        count = 0;
        for (Map.Entry<String, ClientContext> cEntry : this.contexts.entrySet()) {
            ++count;
            ClientContext context = cEntry.getValue();
            String type = context.discovered ? "discovered" : "configured";
            long received = context.getNotificationsReceived();
            rTotal = (int)((long)rTotal + received);
            this.rpcReply(this.debugRequest, context.config + "\n    Type: '" + type + "'  Subscribers: " + context.countSubscribers() + "  Waiting: " + context.countWaiters() + "\n    Notifications received: " + received + "  RTN received: " + context.getRtNetReceived());
        }
        this.rpcReply(this.debugRequest, "Total number of network contexts: " + count + "\nTotal notifications received: " + rTotal);
        this.rpcReply(this.debugRequest, "\nLast successful ONS server ping: " + this.getDateStamp(this.lastPingSuccess) + "\nLast failed ONS server ping: " + this.getDateStamp(this.lastPingFail), true, true);
    }

    private String getDateStamp(Date date) {
        String stamp = "none";
        if (date != null) {
            stamp = this.dateFormatter.format(date);
        }
        return stamp;
    }

    private void setStartState() {
        String tmpFileName = System.getenv("ORACLE_ONS_PROXY_TMPFILE");
        if (tmpFileName != null) {
            boolean created = false;
            String errMsg = "unknown error";
            File tmpFile = new File(tmpFileName);
            try {
                created = tmpFile.createNewFile();
            }
            catch (Exception ex) {
                created = false;
                errMsg = ex.getMessage();
            }
            if (!created) {
                logger.log(Level.WARNING, "Failed to create start state file: " + tmpFileName + " : " + errMsg);
            }
        }
    }

    private void proxySleep(int mSecs) {
        try {
            Thread.sleep(mSecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeMain() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.notified) {
                this.notified = true;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean updateContexts = false;
        this.initProxy();
        long onsLastPing = System.currentTimeMillis();
        long onsPingInterval = 60000L;
        int onsPingFails = 0;
        logger.log(Level.INFO, "Proxy started");
        this.proxyStart = new Date();
        this.setStartState();
        while (this.proxyRun) {
            long tick;
            Object object = this.lock;
            synchronized (object) {
                if (!this.notified) {
                    int waitTime = 60000;
                    if (this.needSubWaits || onsPingFails != 0) {
                        waitTime = 5000;
                    }
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.notified = false;
            }
            object = this.confLock;
            synchronized (object) {
                while (this.netConfigs.size() != 0) {
                    ONSConfiguration newConfig = this.netConfigs.remove(0);
                    String key = newConfig.toString();
                    if (this.contexts.containsKey(key)) continue;
                    this.contexts.put(key, new ClientContext(newConfig, true));
                    updateContexts = true;
                }
            }
            if (updateContexts) {
                this.contextsAddSubscriptions();
                updateContexts = false;
            }
            object = this.requestLock;
            synchronized (object) {
                if (this.reloadRequest != null) {
                    this.proxyReload();
                    this.reloadRequest = null;
                    this.requestLock.notify();
                }
                if (this.debugRequest != null) {
                    this.proxyDebug();
                    this.debugRequest = null;
                    this.requestLock.notify();
                }
            }
            if (this.needSubWaits) {
                this.contextsWaitSubscriptions();
            }
            if ((tick = System.currentTimeMillis()) - onsLastPing < onsPingInterval) continue;
            onsLastPing = tick;
            int status = this.pingOnsServer(true);
            if (status != 0) {
                if (++onsPingFails == 3) {
                    logger.log(Level.SEVERE, "ONS server ping failed " + onsPingFails + " consecutive times -- aborting");
                    this.proxyRun = false;
                    continue;
                }
                logger.log(Level.WARNING, "ONS server ping failed");
                onsPingInterval = 5000L;
                continue;
            }
            if (onsPingFails == 0) continue;
            logger.log(Level.INFO, "ONS server ping succeeded");
            onsPingFails = 0;
            onsPingInterval = 60000L;
        }
        logger.log(Level.INFO, "Proxy stopping");
        this.cleanup();
        logger.log(Level.INFO, "Proxy terminating");
        this.rpcServer.shutdown();
    }

    private void rpcReply(RpcRequest request, String message, boolean end, boolean success) {
        if (!message.endsWith("\n")) {
            message = message + "\n";
        }
        if (!success) {
            end = true;
            message = message + "!>proxy-result: failure\n";
        }
        if (end) {
            request.sendResult(message.getBytes(), true);
        } else {
            request.sendResponse(message.getBytes(), false, true);
        }
    }

    private void rpcReply(RpcRequest request, String message) {
        this.rpcReply(request, message, false, true);
    }

    private static class PropertiesParser {
        private static final int EXPAND_LINE_CONTINUE = 0;

        protected PropertiesParser() {
        }

        protected static Map<String, List<String>> parse(String fileName) {
            HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
            HashMap<Integer, Boolean> expandFlags = new HashMap<Integer, Boolean>();
            String key = null;
            int lineNo = 0;
            int lineKey = 0;
            BufferedReader bReader = null;
            try {
                String raw;
                FileReader fReader = new FileReader(fileName);
                bReader = new BufferedReader(fReader);
                String value = "";
                while ((raw = bReader.readLine()) != null) {
                    List<String> values;
                    ++lineNo;
                    if (raw.startsWith("!") || raw.startsWith("#")) continue;
                    expandFlags.clear();
                    raw = PropertiesParser.stringExpand(raw, expandFlags);
                    boolean cont = false;
                    if (expandFlags.containsKey(0)) {
                        cont = true;
                    }
                    if (key == null) {
                        if (raw.length() == 0) continue;
                        int index = raw.indexOf(61);
                        if (index == -1) {
                            index = raw.indexOf(58);
                            if (index == -1) {
                                throw new RuntimeException("invalid syntax at line: " + lineNo);
                            }
                        } else {
                            int nIndex = raw.indexOf(58);
                            if (nIndex != -1 && nIndex < index) {
                                index = nIndex;
                            }
                        }
                        if ((key = raw.substring(0, index).trim()).length() == 0) {
                            throw new RuntimeException("empty property key at line: " + lineNo);
                        }
                        value = ++index < raw.length() ? raw.substring(index).replaceAll("^\\s+", "") : "";
                        lineKey = lineNo;
                    } else {
                        value = value + raw.replaceAll("^\\s+", "");
                    }
                    if (cont) continue;
                    if (properties.containsKey(key)) {
                        values = (List)properties.get(key);
                    } else {
                        values = new ArrayList();
                        properties.put(key, values);
                    }
                    values.add(value);
                    key = null;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(fileName + ": " + ex.getMessage());
            }
            finally {
                if (bReader != null) {
                    try {
                        bReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (key != null) {
                throw new RuntimeException(fileName + " incomplete value for property key '" + key + "' defined at line: " + lineKey);
            }
            return properties;
        }

        private static String stringExpand(String value, Map<Integer, Boolean> expandFlags) {
            value = value.replace("\\\\", "\b");
            value = value.replace("\\n", "\n");
            value = value.replace("\\r", "\r");
            if ((value = value.replace("\\t", "\t")).endsWith("\\")) {
                value = value.substring(0, value.length() - 1);
                expandFlags.put(0, true);
            }
            value = value.replace("\\", "");
            value = value.replace("\b", "\\");
            return value;
        }
    }

    private class ReloadRequest
    implements RpcRequestListener {
        protected ReloadRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequest(RpcRequest request) {
            logger.log(Level.INFO, "Reload request begin");
            Object object = Proxy.this.requestLock;
            synchronized (object) {
                Proxy.this.reloadRequest = request;
            }
            Proxy.this.wakeMain();
            object = Proxy.this.requestLock;
            synchronized (object) {
                while (Proxy.this.reloadRequest != null) {
                    try {
                        Proxy.this.requestLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            logger.log(Level.INFO, "Reload request completed");
        }
    }

    private class DebugRequest
    implements RpcRequestListener {
        protected DebugRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequest(RpcRequest request) {
            logger.log(Level.FINER, "Debug request begin");
            Object object = Proxy.this.requestLock;
            synchronized (object) {
                Proxy.this.debugRequest = request;
            }
            Proxy.this.wakeMain();
            object = Proxy.this.requestLock;
            synchronized (object) {
                while (Proxy.this.debugRequest != null) {
                    try {
                        Proxy.this.requestLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            logger.log(Level.FINER, "Debug request completed");
        }
    }

    private class ShutdownRequest
    implements RpcRequestListener {
        protected ShutdownRequest() {
        }

        @Override
        public void onRequest(RpcRequest request) {
            logger.log(Level.INFO, "Shutdown request begin");
            Proxy.this.proxyRun = false;
            Proxy.this.wakeMain();
            Proxy.this.proxySleep(120000);
            Proxy.this.rpcReply(request, "Shutdown timeout", true, false);
            logger.log(Level.SEVERE, "Shutdown request failed");
        }
    }

    private class PingRequest
    implements RpcRequestListener {
        protected PingRequest() {
        }

        @Override
        public void onRequest(RpcRequest request) {
            logger.log(Level.FINER, "Ping request begin");
            Proxy.this.rpcReply(request, "!>proxy-result: success", true, true);
            logger.log(Level.FINER, "Ping request completed");
        }
    }

    private class ClientContext {
        protected boolean discovered;
        private ONS ons = null;
        private String config;
        private final Map<Long, Subscriber> subscribers = new HashMap<Long, Subscriber>();
        private final Map<Long, Boolean> registered = new HashMap<Long, Boolean>();
        private CallBack callback;
        private CallBack rtCB;
        private Object statLock = new Object();
        private long notificationsReceived = 0L;
        private long rtNetReceived = 0L;

        protected ClientContext(ONSConfiguration config, boolean discovered) {
            this.ons = new ONS(config);
            this.discovered = discovered;
            this.callback = CallBack.create(this::publishCallBack);
            this.rtCB = CallBack.create(this::onNewNetworkNotification);
            this.config = config.toString();
            logger.log(Level.FINE, config + ": created context");
        }

        protected void close() {
            logger.log(Level.FINE, this.config + ": closing context");
            if (this.ons != null) {
                for (Map.Entry<Long, Subscriber> entry : this.subscribers.entrySet()) {
                    Subscriber sub = entry.getValue();
                    sub.close();
                }
                this.ons.close();
                this.ons = null;
            }
        }

        protected void addSubscriber(long sId, String subscription) {
            this.addSubscriber(sId, subscription, this.callback);
            logger.log(Level.FINER, this.config + ": added subscription (" + sId + "): " + subscription);
        }

        protected void addSubscriber(long sId, String subscription, CallBack cb) {
            if (!this.subscribers.containsKey(sId)) {
                Subscriber sub = Subscriber.backgroundSubscriber(this.ons.config, subscription, cb);
                this.subscribers.put(sId, sub);
                this.registered.put(sId, false);
            }
        }

        protected void removeSubscriber(long sId) {
            if (this.subscribers.containsKey(sId)) {
                this.subscribers.get(sId).close();
                this.subscribers.remove(sId);
                logger.log(Level.FINER, this.config + ": removed subscription (" + sId + ")");
            }
            if (this.registered.containsKey(sId)) {
                this.registered.remove(sId);
            }
        }

        protected boolean waitSubscriber(long sId, String subscription) {
            boolean regState;
            boolean needWait = false;
            if (this.registered.containsKey(sId) && this.subscribers.containsKey(sId) && !(regState = this.registered.get(sId).booleanValue())) {
                logger.log(Level.FINEST, this.config + ": register wait (" + sId + ")");
                needWait = true;
                try {
                    Subscriber sub = this.subscribers.get(sId);
                    regState = sub.waitUntilRegistered(10L, false);
                    if (regState) {
                        this.registered.put(sId, true);
                        needWait = false;
                        logger.log(Level.FINEST, this.config + ": registered (" + sId + ")");
                    }
                }
                catch (InterruptedException sub) {
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Subscription: " + subscription + " subscriber creation failed: " + ex);
                    this.removeSubscriber(sId);
                }
            }
            return needWait;
        }

        protected int countWaiters() {
            int count = 0;
            for (Map.Entry<Long, Boolean> entry : this.registered.entrySet()) {
                boolean regState = entry.getValue();
                if (regState) continue;
                ++count;
            }
            return count;
        }

        protected int countSubscribers() {
            return this.subscribers.size();
        }

        protected void addRtNetSubcriber(String subscription) {
            this.removeSubscriber(0L);
            this.addSubscriber(0L, subscription, this.rtCB);
            logger.log(Level.FINER, this.config + ": added run time network subscription: " + subscription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publishCallBack(Notification n) {
            if (n.getVerb().equals("event")) {
                Notification relay = new Notification(n);
                Proxy.this.publisher.publish(relay);
                Object object = this.statLock;
                synchronized (object) {
                    ++this.notificationsReceived;
                }
                logger.log(Level.FINEST, this.config + ": received and published: " + n.getEventType());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onNewNetworkNotification(Notification n) {
            block10: {
                if (!((Proxy)Proxy.this).proxyConfig.runtimeNetworkSubscription.isEmpty() && n.hasProperty("configuration")) {
                    String configStr = n.get("configuration");
                    logger.log(Level.FINEST, this.config + ": received: " + configStr);
                    try {
                        boolean wake = false;
                        ONSConfiguration config = ONSConfiguration.getRemoteConfigFromString(configStr);
                        Object object = Proxy.this.confLock;
                        synchronized (object) {
                            if (!Proxy.this.netConfigs.contains(config)) {
                                Proxy.this.netConfigs.add(config);
                                wake = true;
                            }
                        }
                        if (!wake) break block10;
                        logger.log(Level.FINEST, config + ": sending new network: " + configStr);
                        Proxy.this.wakeMain();
                        object = this.statLock;
                        synchronized (object) {
                            ++this.rtNetReceived;
                        }
                    }
                    catch (ONSException ex) {
                        logger.log(Level.WARNING, "Invalid discovered configuration: " + configStr + " : " + ex);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getNotificationsReceived() {
            long count;
            Object object = this.statLock;
            synchronized (object) {
                count = this.notificationsReceived;
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getRtNetReceived() {
            long count;
            Object object = this.statLock;
            synchronized (object) {
                count = this.rtNetReceived;
            }
            return count;
        }
    }

    private class ProxyConfig {
        protected String configHome;
        protected boolean debugLog = false;
        protected final List<String> subscriptions = new ArrayList<String>();
        protected final Map<String, ONSConfiguration> internalConfigs = new HashMap<String, ONSConfiguration>();
        protected final Map<String, String> configFile = new HashMap<String, String>();
        protected String runtimeNetworkSubscription = "";
        private String configPath;

        protected ProxyConfig(String configPath) throws RuntimeException {
            Map<String, List<String>> properties;
            this.configPath = configPath;
            logger.log(Level.INFO, "Loading configuration: " + configPath);
            try {
                properties = PropertiesParser.parse(configPath);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
            for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                ParseInterface parseReference = null;
                if (key.equals("addConfig")) {
                    parseReference = this::addConfig;
                } else if (key.equals("addNetwork")) {
                    parseReference = this::addNetwork;
                } else if (key.equals("addSubscription")) {
                    parseReference = this::addSubscription;
                } else if (key.equals("setConfigHome")) {
                    parseReference = this::setConfigHome;
                } else if (key.equals("enableDynamicNetworkSubscription")) {
                    parseReference = this::setDynamicNetworkSubscription;
                } else if (key.equals("debug")) {
                    parseReference = this::setDebug;
                } else if (key.equals("echo")) {
                    parseReference = this::echoValue;
                } else {
                    throw new RuntimeException(configPath + ": unknown property: " + key);
                }
                for (String value : values) {
                    logger.log(Level.FINEST, "Property: " + key + "=" + value);
                    parseReference.parseMethod(key, value);
                }
            }
        }

        private void logDuplicateKey(String key, String value) {
            logger.log(Level.WARNING, this.configPath + ": ignoring duplicate " + key + ": using value: " + value);
        }

        protected void addConfig(String key, String value) {
            int index = value.indexOf(61);
            if (index < 0) {
                index = value.indexOf(58);
            }
            if (index <= 0 || index >= value.length() - 1) {
                throw new RuntimeException(this.configPath + ": invalid syntax for " + key);
            }
            String cKey = value.substring(0, index).trim().toLowerCase();
            String cValue = value.substring(index + 1).trim();
            if (cKey.length() == 0 || cValue.length() == 0) {
                throw new RuntimeException(this.configPath + ": " + key + ": missing key or value");
            }
            if (this.configFile.containsKey(cKey)) {
                if (cKey.equals("nodes")) {
                    this.configFile.put(cKey, this.configFile.get(cKey) + "," + cValue);
                    logger.log(Level.FINE, this.configPath + ": updated ONS server configuration: " + cValue);
                } else {
                    logger.log(Level.WARNING, this.configPath + ": " + key + ": ignoring duplicate property " + cKey + ": using value: " + this.configFile.get(cKey));
                }
            } else {
                this.configFile.put(cKey.toLowerCase(), cValue);
                logger.log(Level.FINE, this.configPath + ": added ONS server configuration: " + cValue);
            }
        }

        private void addNetwork(String key, String value) {
            ONSConfiguration config = null;
            try {
                config = ONSConfiguration.getRemoteConfigFromString(value);
            }
            catch (ONSException ex) {
                logger.log(Level.WARNING, this.configPath + ": " + key + ": invalid value: " + value + " : " + ex);
            }
            if (config != null) {
                String nKey = config.toString();
                if (this.internalConfigs.containsKey(nKey)) {
                    this.logDuplicateKey(key + ": " + nKey, value);
                } else {
                    this.internalConfigs.put(nKey, config);
                    logger.log(Level.FINE, this.configPath + ": added network: " + value);
                }
            }
        }

        private void addSubscription(String key, String value) {
            if (this.subscriptions.contains(value)) {
                this.logDuplicateKey(key, value);
            } else {
                this.subscriptions.add(value);
                logger.log(Level.FINE, this.configPath + ": added subscription: " + value);
            }
        }

        protected void setConfigHome(String key, String value) {
            if (this.configHome != null && !this.configHome.equals(value)) {
                this.logDuplicateKey(key, this.configHome);
            } else {
                this.configHome = value;
                logger.log(Level.FINE, this.configPath + ": configHome=" + this.configHome);
            }
        }

        private void setDynamicNetworkSubscription(String key, String value) {
            if (!this.runtimeNetworkSubscription.isEmpty()) {
                this.logDuplicateKey(key, value);
            } else {
                this.runtimeNetworkSubscription = value;
                logger.log(Level.FINE, this.configPath + ": set run time network subscription: " + value);
            }
        }

        private void setDebug(String key, String value) {
            if (value.toLowerCase().equals("true")) {
                this.debugLog = true;
            }
        }

        private void echoValue(String key, String value) {
            logger.log(Level.INFO, value);
        }
    }

    @FunctionalInterface
    protected static interface ParseInterface {
        public void parseMethod(String var1, String var2);
    }
}

