/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.meta.split;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class StreamSplit
extends SourceSplitBase {
    private final Offset startingOffset;
    private final Offset endingOffset;
    private final List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final int totalFinishedSplitSize;
    @Nullable
    transient byte[] serializedFormCache;

    public StreamSplit(String splitId, Offset startingOffset, Offset endingOffset, List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos, Map<TableId, TableChanges.TableChange> tableSchemas, int totalFinishedSplitSize) {
        super(splitId);
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.finishedSnapshotSplitInfos = finishedSnapshotSplitInfos;
        this.tableSchemas = tableSchemas;
        this.totalFinishedSplitSize = totalFinishedSplitSize;
    }

    public Offset getStartingOffset() {
        return this.startingOffset;
    }

    public Offset getEndingOffset() {
        return this.endingOffset;
    }

    public List<FinishedSnapshotSplitInfo> getFinishedSnapshotSplitInfos() {
        return this.finishedSnapshotSplitInfos;
    }

    @Override
    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public int getTotalFinishedSplitSize() {
        return this.totalFinishedSplitSize;
    }

    public boolean isCompletedSplit() {
        return this.totalFinishedSplitSize == this.finishedSnapshotSplitInfos.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamSplit)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamSplit that = (StreamSplit)o;
        return this.totalFinishedSplitSize == that.totalFinishedSplitSize && Objects.equals(this.startingOffset, that.startingOffset) && Objects.equals(this.endingOffset, that.endingOffset) && Objects.equals(this.finishedSnapshotSplitInfos, that.finishedSnapshotSplitInfos) && Objects.equals(this.tableSchemas, that.tableSchemas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startingOffset, this.endingOffset, this.finishedSnapshotSplitInfos, this.tableSchemas, this.totalFinishedSplitSize);
    }

    public String toString() {
        return "StreamSplit{splitId='" + this.splitId + '\'' + ", offset=" + this.startingOffset + ", endOffset=" + this.endingOffset + '}';
    }

    public static StreamSplit appendFinishedSplitInfos(StreamSplit streamSplit, List<FinishedSnapshotSplitInfo> splitInfos) {
        splitInfos.addAll(streamSplit.getFinishedSnapshotSplitInfos());
        return new StreamSplit(streamSplit.splitId, streamSplit.getStartingOffset(), streamSplit.getEndingOffset(), splitInfos, streamSplit.getTableSchemas(), streamSplit.getTotalFinishedSplitSize());
    }

    public static StreamSplit fillTableSchemas(StreamSplit streamSplit, Map<TableId, TableChanges.TableChange> tableSchemas) {
        tableSchemas.putAll(streamSplit.getTableSchemas());
        return new StreamSplit(streamSplit.splitId, streamSplit.getStartingOffset(), streamSplit.getEndingOffset(), streamSplit.getFinishedSnapshotSplitInfos(), tableSchemas, streamSplit.getTotalFinishedSplitSize());
    }
}

