/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.provider.ConfigProvider;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.rest.ConnectRestExtension;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.Converter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import java.util.Locale;

public enum PluginType {
    SOURCE(SourceConnector.class),
    SINK(SinkConnector.class),
    CONVERTER(Converter.class),
    HEADER_CONVERTER(HeaderConverter.class),
    TRANSFORMATION(Transformation.class),
    PREDICATE(Predicate.class),
    CONFIGPROVIDER(ConfigProvider.class),
    REST_EXTENSION(ConnectRestExtension.class),
    CONNECTOR_CLIENT_CONFIG_OVERRIDE_POLICY(ConnectorClientConfigOverridePolicy.class),
    UNKNOWN(Object.class);

    private final Class<?> klass;

    private PluginType(Class<?> klass) {
        this.klass = klass;
    }

    public static PluginType from(Class<?> klass) {
        for (PluginType type : PluginType.values()) {
            if (!type.klass.isAssignableFrom(klass)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String simpleName() {
        return this.klass.getSimpleName();
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }
}

