/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.RegexValidator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SimpleConfig;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TopicNameMatches<R extends ConnectRecord<R>>
implements Predicate<R> {
    private static final String PATTERN_CONFIG = "pattern";
    public static final String OVERVIEW_DOC = "A predicate which is true for records with a topic name that matches the configured regular expression.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("pattern", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.CompositeValidator.of(new ConfigDef.NonEmptyString(), new RegexValidator()), ConfigDef.Importance.MEDIUM, "A Java regular expression for matching against the name of a record's topic.");
    private Pattern pattern;

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public boolean test(R record) {
        return ((ConnectRecord)record).topic() != null && this.pattern.matcher(((ConnectRecord)record).topic()).matches();
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> configs) {
        Pattern result;
        SimpleConfig simpleConfig = new SimpleConfig(this.config(), configs);
        String value = simpleConfig.getString(PATTERN_CONFIG);
        try {
            result = Pattern.compile(value);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException(PATTERN_CONFIG, value, "entry must be a Java-compatible regular expression: " + e.getMessage());
        }
        this.pattern = result;
    }

    public String toString() {
        return "TopicNameMatches{pattern=" + this.pattern + '}';
    }
}

