/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.sqlserver.source;

import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import com.ververica.cdc.connectors.base.source.meta.offset.OffsetFactory;
import com.ververica.cdc.connectors.sqlserver.source.config.SqlServerSourceConfigFactory;
import com.ververica.cdc.connectors.sqlserver.source.dialect.SqlServerDialect;
import com.ververica.cdc.connectors.sqlserver.source.offset.LsnFactory;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import java.time.Duration;
import java.util.Properties;
import org.apache.flink.util.Preconditions;

public class SqlServerSourceBuilder<T> {
    private final SqlServerSourceConfigFactory configFactory = new SqlServerSourceConfigFactory();
    private LsnFactory offsetFactory;
    private SqlServerDialect dialect;
    private DebeziumDeserializationSchema<T> deserializer;

    public SqlServerSourceBuilder<T> hostname(String hostname) {
        this.configFactory.hostname(hostname);
        return this;
    }

    public SqlServerSourceBuilder<T> port(int port) {
        this.configFactory.port(port);
        return this;
    }

    public SqlServerSourceBuilder<T> databaseList(String ... databaseList) {
        this.configFactory.databaseList(databaseList);
        return this;
    }

    public SqlServerSourceBuilder<T> tableList(String ... tableList) {
        this.configFactory.tableList(tableList);
        return this;
    }

    public SqlServerSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public SqlServerSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public SqlServerSourceBuilder<T> serverTimeZone(String timeZone) {
        this.configFactory.serverTimeZone(timeZone);
        return this;
    }

    public SqlServerSourceBuilder<T> splitSize(int splitSize) {
        this.configFactory.splitSize(splitSize);
        return this;
    }

    public SqlServerSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public SqlServerSourceBuilder<T> distributionFactorUpper(double distributionFactorUpper) {
        this.configFactory.distributionFactorUpper(distributionFactorUpper);
        return this;
    }

    public SqlServerSourceBuilder<T> distributionFactorLower(double distributionFactorLower) {
        this.configFactory.distributionFactorLower(distributionFactorLower);
        return this;
    }

    public SqlServerSourceBuilder<T> fetchSize(int fetchSize) {
        this.configFactory.fetchSize(fetchSize);
        return this;
    }

    public SqlServerSourceBuilder<T> connectTimeout(Duration connectTimeout) {
        this.configFactory.connectTimeout(connectTimeout);
        return this;
    }

    public SqlServerSourceBuilder<T> connectMaxRetries(int connectMaxRetries) {
        this.configFactory.connectMaxRetries(connectMaxRetries);
        return this;
    }

    public SqlServerSourceBuilder<T> connectionPoolSize(int connectionPoolSize) {
        this.configFactory.connectionPoolSize(connectionPoolSize);
        return this;
    }

    public SqlServerSourceBuilder<T> includeSchemaChanges(boolean includeSchemaChanges) {
        this.configFactory.includeSchemaChanges(includeSchemaChanges);
        return this;
    }

    public SqlServerSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public SqlServerSourceBuilder<T> chunkKeyColumn(String chunkKeyColumn) {
        this.configFactory.chunkKeyColumn(chunkKeyColumn);
        return this;
    }

    public SqlServerSourceBuilder<T> debeziumProperties(Properties properties) {
        this.configFactory.debeziumProperties(properties);
        return this;
    }

    public SqlServerSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public SqlServerSourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public SqlServerIncrementalSource<T> build() {
        this.offsetFactory = new LsnFactory();
        this.dialect = new SqlServerDialect(this.configFactory);
        return new SqlServerIncrementalSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer), this.offsetFactory, this.dialect);
    }

    public static class SqlServerIncrementalSource<T>
    extends JdbcIncrementalSource<T> {
        public SqlServerIncrementalSource(SqlServerSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, LsnFactory offsetFactory, SqlServerDialect dataSourceDialect) {
            super(configFactory, deserializationSchema, (OffsetFactory)offsetFactory, dataSourceDialect);
        }

        public static <T> SqlServerSourceBuilder<T> builder() {
            return new SqlServerSourceBuilder();
        }
    }
}

